/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.System;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u0005J\b\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/util/Stopwatch;", "", "<init>", "()V", "startTimestamp", "", "totalTime", "isRunning", "", "start", "", "stop", "reset", "split", "updateTotalTime", "time", "getTime", "()J", "timeString", "", "getTimeString", "()Ljava/lang/String;", "Companion", "kts-core"})
public final class Stopwatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long startTimestamp;
    private long totalTime;
    private boolean isRunning;

    public Stopwatch() {
        this.start();
    }

    public final void start() {
        if (this.isRunning) {
            return;
        }
        this.startTimestamp = System.INSTANCE.currentTimeMillis();
        this.isRunning = true;
    }

    public final long stop() {
        if (this.isRunning) {
            this.updateTotalTime();
            this.isRunning = false;
        }
        return this.totalTime;
    }

    public final void reset() {
        this.totalTime = 0L;
        this.startTimestamp = System.INSTANCE.currentTimeMillis();
    }

    public final long split() {
        if (this.isRunning) {
            this.updateTotalTime();
        }
        return this.totalTime;
    }

    private final void updateTotalTime() {
        long endTimestamp = System.INSTANCE.currentTimeMillis();
        long elapsedTime = endTimestamp - this.startTimestamp;
        this.startTimestamp = endTimestamp;
        this.totalTime += elapsedTime;
    }

    public final long getTime() {
        this.updateTotalTime();
        return this.totalTime;
    }

    @NotNull
    public final String getTimeString() {
        long totalTime = this.getTime();
        return Companion.getTimeString(totalTime);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/util/Stopwatch$Companion;", "", "<init>", "()V", "getTimeString", "", "timeMillis", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTimeString(long timeMillis) {
            return timeMillis < 10000L ? timeMillis + " ms" : (double)timeMillis / 1000.0 + " s";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

