/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.AbstractLabeling;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import java.awt.Color;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.font.MkFontKt;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Ja\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\u00062\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004\u00a8\u0006\u0016"}, d2={"Lcom/treemap/ExpandLabeling;", "Lcom/treemap/AbstractLabeling;", "<init>", "()V", "paintParent", "", "N", "Row", "Column", "g", "Lcom/treemap/crossplatform/TGraphics;", "bounds", "Lorg/mkui/geom/Rectangle;", "node", "view", "Lcom/treemap/TreeMapView;", "pass", "", "passes", "(Lcom/treemap/crossplatform/TGraphics;Lorg/mkui/geom/Rectangle;Ljava/lang/Object;Lcom/treemap/TreeMapView;II)V", "toString", "", "treemap"})
@StabilityInferred(parameters=1)
public final class ExpandLabeling
extends AbstractLabeling {
    public static final int $stable;

    @Override
    public <N, Row, Column> void paintParent(@NotNull TGraphics g, @NotNull Rectangle bounds, N node, @NotNull TreeMapView<N, Row, Column> view, int pass, int passes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if (pass == passes - 1 && bounds.getWidth() > 20.0 && bounds.getHeight() > 16.0) {
            Font headerFont;
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            g.save();
            g.setGlobalAlpha(0.5);
            TreeMapHeaderRenderer<N, Row, Column> treeMapHeaderRenderer = view.getHeaderRenderer();
            Intrinsics.checkNotNull(treeMapHeaderRenderer);
            EnhancedLabel elabel = treeMapHeaderRenderer.getTreeMapHeaderRendererComponent(model, node, new Dimension(bounds.getIwidth(), bounds.getIheight()));
            PreferredSize pf = g.sizeLabel(elabel, bounds.getIwidth(), bounds.getIheight());
            Column column = model.getGroupByColumn(node);
            Font font = headerFont = model.getSettings().getColumnSettings(column).getHeaderFont();
            Intrinsics.checkNotNull((Object)font);
            elabel.setFont(font);
            Dimension size = pf.getPreferredSize();
            float scalex = (float)bounds.getWidth() / (float)size.getWidth();
            float scaley = (float)bounds.getHeight() / (float)size.getHeight();
            float scale = Math.min(scalex, scaley);
            double fontSize = Math.max(MkFontKt.getFontSize((Font)headerFont), MkFontKt.getFontSize((Font)headerFont) * (double)scale);
            Color foreground = model.getSettings().getColumnSettings(column).getHeaderForeground();
            Color background = model.getSettings().getColumnSettings(column).getHeaderEffectColor();
            Font derivedFont = MkFontKt.deriveFontSize((Font)headerFont, (double)fontSize);
            elabel.setFont(derivedFont);
            Color color = foreground;
            Intrinsics.checkNotNull((Object)color);
            elabel.setForeground(color);
            Color color2 = background;
            Intrinsics.checkNotNull((Object)color2);
            elabel.setBackground(color2);
            size = pf.getPreferredSize();
            Point2D position = null;
            Shape shape = model.getShape(node);
            position = shape instanceof Arc2D ? AbstractLabeling.Companion.getCentroid(shape) : null;
            Rectangle rect = null;
            if (position != null) {
                int w = size.getIwidth();
                if (shape instanceof Arc2D) {
                    Arc2D arc = (Arc2D)shape;
                    Point2D startPoint = arc.getStartPoint();
                    Point2D endPoint = arc.getEndPoint();
                    Point2D s = (Point2D)new Point2D.Double((double)view.worldToScreenX(startPoint.getX()), (double)view.worldToScreenY(startPoint.getY()));
                    Point2D e = (Point2D)new Point2D.Double((double)view.worldToScreenX(endPoint.getX()), (double)view.worldToScreenY(endPoint.getY()));
                    w = Math.min((int)s.distance(e), w);
                }
                int h = size.getIheight();
                int x = view.worldToScreenX(position.getX()) - w / 2;
                int y = view.worldToScreenY(position.getY()) - h / 2;
                rect = new Rectangle(x, y, w, h).intersection(bounds);
            } else {
                rect = bounds;
            }
            g.paintLabel(elabel, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
            g.restore();
        }
    }

    @NotNull
    public String toString() {
        return "Expand";
    }
}

