/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Jm\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J2\u0010\u0018\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0014H\u0002J*\u0010\u001d\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0014H\u0002J\u0012\u0010 \u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004\u00a8\u0006$"}, d2={"Lcom/treemap/SplitAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "<init>", "()V", "breadthFirstLayout", "", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "splitLayout", "items", "", "r", "Lorg/mkui/geom/Rectangle2D;", "w", "list", "", "isCompatible", "toString", "", "Companion", "treemap"})
@StabilityInferred(parameters=1)
public final class SplitAlgorithm
extends AbstractAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        List items = new ArrayList();
        for (N child : children) {
            items.add(child);
        }
        this.splitLayout(items, bounds, accessor);
        return false;
    }

    private final <N> boolean splitLayout(List<N> items, Rectangle2D r, TreeMapAccessor<? super N> accessor) {
        N front;
        if (items.size() == 0) {
            return true;
        }
        if (items.size() == 1) {
            accessor.setShape(items.get(0), (Shape)r);
            return true;
        }
        List l1 = new ArrayList();
        List<N> l2 = new ArrayList();
        Rectangle2D r1 = null;
        Rectangle2D r2 = null;
        double halfSize = this.w(items, accessor) / (double)2;
        double w1 = 0.0;
        double tmp = 0.0;
        ListIterator<N> iterator2 = items.listIterator();
        while (iterator2.hasNext() && !(Math.abs(halfSize - (tmp = w1 + accessor.getSize(front = iterator2.next()))) > Math.abs(halfSize - w1)) && iterator2.hasNext()) {
            iterator2.remove();
            l1.add(front);
            w1 = tmp;
        }
        l2 = items;
        if (r.getWidth() > r.getHeight()) {
            r1 = (Rectangle2D)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth() * (this.w(l1, accessor) / (this.w(l1, accessor) + this.w(l2, accessor))), r.getHeight());
            r2 = (Rectangle2D)new Rectangle2D.Double(r.getX() + ((Rectangle2D.Double)r1).getWidth(), r.getY(), r.getWidth() - ((Rectangle2D.Double)r1).getWidth(), r.getHeight());
        } else {
            r1 = (Rectangle2D)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight() * (this.w(l1, accessor) / (this.w(l1, accessor) + this.w(l2, accessor))));
            r2 = (Rectangle2D)new Rectangle2D.Double(r.getX(), r.getY() + ((Rectangle2D.Double)r1).getHeight(), r.getWidth(), r.getHeight() - ((Rectangle2D.Double)r1).getHeight());
        }
        this.splitLayout(l1, r1, accessor);
        this.splitLayout(l2, r2, accessor);
        return false;
    }

    private final <N> double w(List<? extends N> list, TreeMapAccessor<? super N> accessor) {
        double sum = 0.0;
        for (N node : list) {
            sum += accessor.getSize(node);
        }
        return sum;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public String toString() {
        return SplitAlgorithm.Companion.getName();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/treemap/SplitAlgorithm$Companion;", "", "<init>", "()V", "getName", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        private final String getName() {
            return "Split";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

