/*
 * Decompiled with CFR 0.152.
 */
import com.treemap.AbstractTreeMap;
import com.treemap.AbstractTreeMapNode;
import com.treemap.Algorithm;
import com.treemap.DefaultTreeMap;
import com.treemap.Rendering;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import org.mkui.colormap.MutableColorMap;
import org.mkui.font.crossplatform.CPFont;
import org.mkui.palette.FixedPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;
import org.mkui.swing.HierarchicalComboBox;
import org.mkui.swing.Orientation;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.JsonDataFrame;
import scala.App;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;

public final class Demo$
implements App,
Serializable {
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer scala$App$$initCode;
    private static final InputStream inputStream;
    private static final DataFrame dataFrame;
    private static final AbstractTreeMap treeMap;
    private static final TreeMapModel model;
    private static final TreeMapSettings settings;
    private static final TreeMapColumnSettings profitsSettings;
    private static final FixedPalette negpos;
    private static final MutableColorMap colorMap;
    private static final TreeMapColumnSettings companySettings;
    private static final JPanel configuration;
    private static final JSplitPane splitPane;
    private static final JPanel mainPanel;
    private static final JFrame frame;
    public static final Demo$ MODULE$;

    private Demo$() {
    }

    static {
        MODULE$ = new Demo$();
        App.$init$((App)MODULE$);
        inputStream = MODULE$.getClass().getResourceAsStream("Forbes Global 2000 - 2021.json");
        dataFrame = JsonDataFrame.fromInputStream((InputStream)MODULE$.inputStream());
        treeMap = new DefaultTreeMap(MODULE$.dataFrame());
        model = MODULE$.treeMap().getModel();
        settings = MODULE$.model().getSettings();
        MODULE$.settings().setRendering(RenderingFactory.getFLAT());
        MODULE$.settings().setGroupByColumns(Arrays.asList("Sector", "Industry"));
        MODULE$.settings().setSizeColumn((Object)"Market Value");
        MODULE$.settings().setColorColumn((Object)"Profits");
        profitsSettings = MODULE$.settings().getColumnSettings((Object)"Profits");
        negpos = new PaletteFactory().get("negpos").getPalette();
        colorMap = MODULE$.model().getColorMap((Object)"Profits");
        MODULE$.colorMap().setPalette((MutablePalette)MODULE$.negpos());
        MODULE$.colorMap().getInterval().setValue(-88.205, 176.41);
        companySettings = MODULE$.settings().getColumnSettings((Object)"Company");
        MODULE$.companySettings().setLabelingFont(new CPFont(new Font("Helvetica", 0, 9)).getNativeFont());
        MODULE$.companySettings().setLabelingMinimumCharactersToDisplay(Predef$.MODULE$.int2Integer(5));
        MODULE$.companySettings().setLabelingResizeTextToFitShape(true);
        MODULE$.companySettings().setLabelingVerticalAlignment(0);
        MODULE$.companySettings().setLabelingHorizontalAlignment(0);
        configuration = MODULE$.createConfiguration(MODULE$.model(), MODULE$.settings());
        splitPane = new JSplitPane(1, true, MODULE$.configuration(), MODULE$.treeMap().getComponent().getNativeComponent());
        mainPanel = new JPanel(new BorderLayout());
        MODULE$.mainPanel().add((Component)MODULE$.createGroupBy(Orientation.Horizontal, MODULE$.model(), MODULE$.settings()), "North");
        MODULE$.mainPanel().add(MODULE$.splitPane());
        frame = new JFrame("TreeMap");
        MODULE$.frame().getContentPane().add(MODULE$.mainPanel());
        MODULE$.frame().setSize(1024, 768);
        MODULE$.frame().setDefaultCloseOperation(3);
        MODULE$.frame().setLocationRelativeTo(null);
        MODULE$.frame().setVisible(true);
        Statics.releaseFence();
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public ListBuffer scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$0) {
        executionStart = x$0;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$0) {
        scala$App$$initCode = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Demo$.class);
    }

    public InputStream inputStream() {
        return inputStream;
    }

    public DataFrame<Integer, String, Object> dataFrame() {
        return dataFrame;
    }

    public AbstractTreeMap<Integer, String> treeMap() {
        return treeMap;
    }

    public TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model() {
        return model;
    }

    public TreeMapSettings<String> settings() {
        return settings;
    }

    public TreeMapColumnSettings profitsSettings() {
        return profitsSettings;
    }

    public FixedPalette negpos() {
        return negpos;
    }

    public MutableColorMap colorMap() {
        return colorMap;
    }

    public TreeMapColumnSettings companySettings() {
        return companySettings;
    }

    public JPanel configuration() {
        return configuration;
    }

    public JSplitPane splitPane() {
        return splitPane;
    }

    public JPanel mainPanel() {
        return mainPanel;
    }

    public JFrame frame() {
        return frame;
    }

    private JPanel createConfiguration(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JPanel configuration = new JPanel();
        configuration.setLayout(new BoxLayout(configuration, 3));
        configuration.add((Component)this.createGroupBy(Orientation.Vertical, model, settings));
        configuration.add(this.createSizeComboBox(model, settings));
        configuration.add(this.createColorComboBox(model, settings));
        configuration.add(this.createAlgorithmComboBox(settings.getDefaultColumnSettings()));
        configuration.add(this.createRenderingComboBox(settings));
        configuration.add(Box.createGlue());
        return configuration;
    }

    private HierarchicalComboBox<String> createGroupBy(Orientation orientation, TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        HierarchicalComboBox<String> groupBy = new HierarchicalComboBox<String>(orientation, model, settings){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        groupBy.setBorder((Border)BorderFactory.createTitledBorder("Group by"));
        groupBy.setAlignmentX(0.0f);
        return groupBy;
    }

    private JComboBox<String> createSizeComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JComboBox<String> sizeComboBox = new JComboBox<String>(model, settings){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        sizeComboBox.setBorder(BorderFactory.createTitledBorder("Size"));
        sizeComboBox.setAlignmentX(0.0f);
        return sizeComboBox;
    }

    private JComboBox<String> createColorComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JComboBox<String> sizeComboBox = new JComboBox<String>(model, settings){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        sizeComboBox.setBorder(BorderFactory.createTitledBorder("Size"));
        sizeComboBox.setAlignmentX(0.0f);
        return sizeComboBox;
    }

    private JComboBox<Algorithm> createAlgorithmComboBox(TreeMapColumnSettings settings) {
        JComboBox<Algorithm> algorithmComboBox = new JComboBox<Algorithm>(settings){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        algorithmComboBox.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        algorithmComboBox.setAlignmentX(0.0f);
        return algorithmComboBox;
    }

    private JComboBox<Rendering> createRenderingComboBox(TreeMapSettings<String> settings) {
        JComboBox<Rendering> renderingComboBox = new JComboBox<Rendering>(settings){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        renderingComboBox.setBorder(BorderFactory.createTitledBorder("Rendering"));
        renderingComboBox.setAlignmentX(0.0f);
        return renderingComboBox;
    }
}

