/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.query;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.query.CuboidQuery;
import org.molap.aggregates.query.CuboidsQuery;
import org.molap.aggregates.query.OrderQuery;
import org.molap.aggregates.query.PivotQuery;
import org.molap.aggregates.query.Query;
import org.molap.aggregates.query.QueryDataFrame;
import org.molap.aggregates.query.QueryListener;
import org.molap.dataframe.DataFrame;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000 /2\u00020\u0001:\u0002./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0012\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0015\u001a\u00020\u00012\u0010\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u0017H\u0016J3\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0010\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001a2\u0010\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u0018\u001a\u00020\u00012\u0010\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J5\u0010\u001d\u001a\u00020\u00012&\u0010\u001e\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001a0\u000f\"\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u00020\u00012\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0\u000f\"\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0016J\b\u0010,\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020(H\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/molap/aggregates/query/AbstractQuery;", "Lorg/molap/aggregates/query/Query;", "<init>", "()V", "isDirty", "", "()Z", "setDirty", "(Z)V", "listeners", "", "Lorg/molap/aggregates/query/QueryListener;", "drillDown", "Lorg/molap/aggregates/query/CuboidQuery;", "columns", "", "", "([Ljava/lang/Object;)Lorg/molap/aggregates/query/CuboidQuery;", "drillUp", "slice", "value", "dice", "valuesSets", "", "pivot", "aggregation", "Lorg/molap/aggregates/aggregation/Aggregation;", "(Lorg/molap/aggregates/aggregation/Aggregation;[Ljava/lang/Object;)Lorg/molap/aggregates/query/Query;", "collapse", "order", "aggregations", "([Lorg/molap/aggregates/aggregation/Aggregation;)Lorg/molap/aggregates/query/Query;", "on", "cuboids", "Lorg/molap/aggregates/cuboid/Cuboid;", "([Lorg/molap/aggregates/cuboid/Cuboid;)Lorg/molap/aggregates/query/Query;", "asDataFrame", "Lorg/molap/dataframe/DataFrame;", "includeIndex", "addQueryListener", "", "listener", "addWeakQueryListener", "removeQueryListener", "removeQueryListeners", "notifyQueryChanged", "WeakQueryListener", "Companion", "molap"})
public abstract class AbstractQuery
implements Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isDirty = true;
    @NotNull
    private final List<QueryListener> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    @Override
    @NotNull
    public CuboidQuery drillDown(Object ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Aggregation<Object>[] aggregationArray = this.getAggregations();
        return new CuboidQuery(this, new CuboidQuery.DrillDownOperation(Arrays.copyOf(columns, columns.length)), Arrays.copyOf(aggregationArray, aggregationArray.length));
    }

    @Override
    @NotNull
    public Query drillUp() {
        Aggregation<Object>[] aggregationArray = this.getAggregations();
        return new CuboidQuery(this, new CuboidQuery.DrillUpOperation(), Arrays.copyOf(aggregationArray, aggregationArray.length));
    }

    @Override
    @NotNull
    public Query slice(@Nullable Object value) {
        Aggregation<Object>[] aggregationArray = this.getAggregations();
        return new CuboidQuery(this, new CuboidQuery.SliceOperation(value), Arrays.copyOf(aggregationArray, aggregationArray.length));
    }

    @Override
    @NotNull
    public Query dice(@Nullable Set<? extends Object> valuesSets) {
        Aggregation<Object>[] aggregationArray = this.getAggregations();
        return new CuboidQuery(this, new CuboidQuery.DiceOperation(valuesSets), Arrays.copyOf(aggregationArray, aggregationArray.length));
    }

    @Override
    @Nullable
    public Query pivot(@Nullable Aggregation<Object> aggregation, @Nullable Object[] columns) {
        Query query = this;
        Aggregation<Object> aggregation2 = aggregation;
        Intrinsics.checkNotNull(aggregation2);
        return new PivotQuery(query, aggregation2, columns);
    }

    @Override
    @NotNull
    public Query pivot(@Nullable Aggregation<Object> aggregation) {
        Query query = this;
        Aggregation<Object> aggregation2 = aggregation;
        Intrinsics.checkNotNull(aggregation2);
        return new PivotQuery(query, aggregation2);
    }

    @Override
    @NotNull
    public Query collapse() {
        Aggregation<Object>[] aggregationArray = this.getAggregations();
        return new CuboidQuery(this, new CuboidQuery.CollapseOperation(), Arrays.copyOf(aggregationArray, aggregationArray.length));
    }

    @Override
    @NotNull
    public Query order(Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        Aggregation<Object>[] a = aggregations;
        return new OrderQuery(this, a);
    }

    @Override
    @NotNull
    public Query on(Cuboid ... cuboids) {
        Intrinsics.checkNotNullParameter((Object)cuboids, (String)"cuboids");
        Aggregation<Object>[] aggregationArray = this.getAggregations();
        return new CuboidsQuery(cuboids, Arrays.copyOf(aggregationArray, aggregationArray.length));
    }

    @Override
    @NotNull
    public DataFrame<?, ?, ?> asDataFrame(boolean includeIndex) {
        return new QueryDataFrame(this, includeIndex);
    }

    @Override
    public void addQueryListener(@NotNull QueryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakQueryListener(@NotNull QueryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        WeakQueryListener weakListener = new WeakQueryListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeQueryListener(@NotNull QueryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (listener2 instanceof WeakQueryListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            QueryListener toRemove = null;
            for (QueryListener queryListener2 : this.listeners) {
                QueryListener comparable = null;
                comparable = queryListener2 instanceof WeakQueryListener ? ((WeakQueryListener)queryListener2).getReference() : queryListener2;
                if (!listener2.equals(comparable)) continue;
                toRemove = queryListener2;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeQueryListeners() {
        this.listeners.clear();
    }

    protected final void notifyQueryChanged() {
        for (QueryListener listener2 : this.listeners) {
            listener2.queryChanged();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/query/AbstractQuery$Companion;", "", "<init>", "()V", "abbreviate", "", "str", "maxWidth", "", "molap"})
    public static final class Companion {
        private Companion() {
        }

        private final String abbreviate(String str, int maxWidth) {
            Object object;
            if (str == null) {
                return null;
            }
            if (str.length() <= maxWidth) {
                object = str;
            } else {
                String string = str.substring(0, maxWidth - 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = string + "...";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/molap/aggregates/query/AbstractQuery$WeakQueryListener;", "E", "Lorg/molap/aggregates/query/QueryListener;", "listener", "<init>", "(Lorg/molap/aggregates/query/AbstractQuery;Lorg/molap/aggregates/query/QueryListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "queryChanged", "", "reference", "getReference", "()Lorg/molap/aggregates/query/QueryListener;", "toString", "", "molap"})
    private final class WeakQueryListener<E>
    implements QueryListener {
        @NotNull
        private final WeakReference<QueryListener> l_ref;

        public WeakQueryListener(QueryListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.l_ref = new WeakReference((Object)listener2);
        }

        @Override
        public void queryChanged() {
            QueryListener l = this.getReference();
            if (l != null) {
                l.queryChanged();
            } else {
                AbstractQuery.this.removeQueryListener(this);
            }
        }

        @Nullable
        public final QueryListener getReference() {
            return (QueryListener)this.l_ref.get();
        }

        @NotNull
        public String toString() {
            QueryListener l = this.getReference();
            return l != null ? "Weak[" + l + "]" : super.toString();
        }
    }
}

