/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.Column;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004B5\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00028\u00022\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/molap/dataframe/ListDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/AbstractDataFrame;", "", "list", "", "columns", "", "Lorg/molap/dataframe/Column;", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "getColumnClass", "Lkotlin/reflect/KClass;", "column", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getValueAt", "row", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "columnIndex", "getColumnIndex", "getRowClass", "molap"})
public final class ListDataFrame<R, C, V>
extends AbstractDataFrame<R, C, Object> {
    @NotNull
    private final Map<C, Column<R, V>> columns;
    @NotNull
    private final UniqueIndex<R> rowIndex;
    @NotNull
    private final UniqueIndex<C> columnIndex;

    public ListDataFrame(@NotNull List<? extends R> list, @NotNull Map<C, ? extends Column<R, ? extends V>> columns) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
        this.rowIndex = new DefaultUniqueIndex((Iterable)list, true);
        this.columnIndex = new DefaultUniqueIndex((Iterable)this.columns.keySet(), true);
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(C column) {
        Column<R, V> column2 = this.columns.get(column);
        Intrinsics.checkNotNull(column2);
        return column2.getType();
    }

    @Override
    public V getValueAt(R row, C column) {
        Column<R, V> column2 = this.columns.get(column);
        Intrinsics.checkNotNull(column2);
        return (V)column2.getValues().invoke(row);
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        return this.rowIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(R row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }
}

