/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.SortKey;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0012\u0012\u0004\u0012\u0002H\u00010\u0004j\b\u0012\u0004\u0012\u0002H\u0001`\u0005BA\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u001e\u0010\b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\t\"\b\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\t\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/molap/dataframe/SortComparator;", "Row", "Column", "V", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "sortKeys", "", "Lorg/molap/dataframe/SortKey;", "<init>", "(Lorg/molap/dataframe/DataFrame;[Lorg/molap/dataframe/SortKey;)V", "getDataFrame", "()Lorg/molap/dataframe/DataFrame;", "getSortKeys", "()[Lorg/molap/dataframe/SortKey;", "[Lorg/molap/dataframe/SortKey;", "compare", "", "o1", "o2", "(Ljava/lang/Object;Ljava/lang/Object;)I", "molap"})
final class SortComparator<Row, Column, V>
implements Comparator<Row> {
    @NotNull
    private final DataFrame<Row, Column, V> dataFrame;
    @NotNull
    private final SortKey<Column>[] sortKeys;

    public SortComparator(@NotNull DataFrame<Row, Column, V> dataFrame, SortKey<Column> ... sortKeys) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        this.dataFrame = dataFrame;
        this.sortKeys = sortKeys;
    }

    @NotNull
    public final DataFrame<Row, Column, V> getDataFrame() {
        return this.dataFrame;
    }

    @NotNull
    public final SortKey<Column>[] getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public int compare(Row o1, Row o2) {
        int y;
        for (SortKey<Column> sortKey : this.sortKeys) {
            int compare = sortKey.compare(this.dataFrame, o1, o2);
            if (compare == 0) continue;
            return compare;
        }
        int x = this.dataFrame.getRowAddress(o1);
        return x < (y = this.dataFrame.getRowAddress(o2)) ? -1 : (x == y ? 0 : 1);
    }
}

