/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.DataFrameExport;
import org.molap.exporter.DataFrameWriter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000eH\u0002J4\u0010\u000f\u001a\u00020\t\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/molap/exporter/DelimitedDataFrameExport;", "Lorg/molap/exporter/DataFrameExport;", "writer", "Lorg/molap/exporter/DataFrameWriter;", "<init>", "(Lorg/molap/exporter/DataFrameWriter;)V", "initialized", "", "initialize", "", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "write", "close", "molap"})
public final class DelimitedDataFrameExport
implements DataFrameExport {
    @NotNull
    private final DataFrameWriter writer;
    private boolean initialized;

    public DelimitedDataFrameExport(@NotNull DataFrameWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.writer = writer;
    }

    private final <R, C, V> void initialize(DataFrame<R, C, V> dataFrame) {
        KClass<?> value;
        int column;
        this.writer.start();
        int n = dataFrame.getColumnCount();
        for (column = 0; column < n; ++column) {
            value = dataFrame.getColumnName(dataFrame.getColumnKey(column));
            this.writer.writeColumnName((String)value, column < dataFrame.getColumnCount() - 1);
        }
        this.writer.nextRow();
        if (this.writer.includeType()) {
            n = dataFrame.getColumnCount();
            for (column = 0; column < n; ++column) {
                value = dataFrame.getColumnClass(dataFrame.getColumnKey(column));
                this.writer.writeType(value, column < dataFrame.getColumnCount() - 1);
            }
            this.writer.nextRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, C, V> void write(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (!this.initialized) {
            this.initialize(dataFrame);
            this.initialized = true;
        }
        int n = dataFrame.getRowCount();
        for (int row = 0; row < n; ++row) {
            int n2 = dataFrame.getColumnCount();
            for (int column = 0; column < n2; ++column) {
                try {
                    Object value = null;
                    R rowKey = dataFrame.getRowKey(row);
                    C columnKey = dataFrame.getColumnKey(column);
                    value = dataFrame.getValueAt(rowKey, columnKey);
                    this.writer.writeCell(value, dataFrame, rowKey, columnKey);
                    this.writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                    continue;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        this.writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                        throw throwable;
                    }
                }
            }
            this.writer.nextRow();
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

