/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.DataFrameExporter;
import org.molap.exporter.DataFrameWriter;
import org.molap.exporter.DelimitedDataFrameWriter;
import org.molap.exporter.JSONDataFrameWriter;
import org.molap.exporter.OutputStreamWriterDataFrameOutput;
import org.molap.exporter.StringDataFrameOutput;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\nJ:\u0010\r\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\fJ:\u0010\r\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000f\u001a\u00020\u0010JI\u0010\u0011\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/molap/exporter/FileDataFrameExporter;", "", "<init>", "()V", "exportCSV", "", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "file", "Ljava/io/File;", "exportJSon", "", "os", "Ljava/io/OutputStream;", "exportDelimited", "delimiter", "exportDelimited$molap", "molap"})
public final class FileDataFrameExporter {
    @NotNull
    public static final FileDataFrameExporter INSTANCE = new FileDataFrameExporter();

    private FileDataFrameExporter() {
    }

    public final <R, C, V> void exportCSV(@NotNull DataFrame<R, C, V> dataFrame, @NotNull File file) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.exportDelimited$molap(dataFrame, file, ",");
    }

    @NotNull
    public final <R, C, V> String exportJSon(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        String newLine = "\n";
        StringBuilder sb = new StringBuilder("\ufeff");
        StringDataFrameOutput output2 = new StringDataFrameOutput(sb);
        DataFrameWriter writer = new JSONDataFrameWriter(output2, newLine);
        DataFrameExporter.INSTANCE.export(dataFrame, writer);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final <R, C, V> void exportJSon(@NotNull DataFrame<R, C, V> dataFrame, @NotNull File file) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String newLine = "\n";
        OutputStreamWriterDataFrameOutput output2 = new OutputStreamWriterDataFrameOutput(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        DataFrameWriter writer = new JSONDataFrameWriter(output2, newLine);
        DataFrameExporter.INSTANCE.export(dataFrame, writer);
    }

    public final <R, C, V> void exportJSon(@NotNull DataFrame<R, C, V> dataFrame, @NotNull OutputStream os) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        String newLine = "\n";
        OutputStreamWriterDataFrameOutput output2 = new OutputStreamWriterDataFrameOutput(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        DataFrameWriter writer = new JSONDataFrameWriter(output2, newLine);
        DataFrameExporter.INSTANCE.export(dataFrame, writer);
    }

    public final <R, C, V> void exportDelimited$molap(@NotNull DataFrame<R, C, V> dataFrame, @NotNull File file, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        String newLine = "\n";
        OutputStreamWriterDataFrameOutput output2 = new OutputStreamWriterDataFrameOutput(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        output2.write("\ufeff");
        DataFrameWriter writer = new DelimitedDataFrameWriter(output2, delimiter, newLine);
        DataFrameExporter.INSTANCE.export(dataFrame, writer);
    }
}

