/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import com.macrofocus.common.units.Quantity;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;
import org.molap.exporter.AbstractDataFrameWriter;
import org.molap.exporter.DataFrameOutput;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u001a\u0010\u0012\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u001c\u0010\u0015\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0016JS\u0010\u0017\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u0019\"\u0004\b\u0002\u0010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a0\u001e2\u0006\u0010\u001f\u001a\u0002H\u00182\u0006\u0010 \u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020\u0010H\u0016J\u0006\u0010$\u001a\u00020\u0010J\b\u0010%\u001a\u00020\u0010H\u0016J\u0006\u0010&\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/molap/exporter/JSONDataFrameWriter;", "Lorg/molap/exporter/AbstractDataFrameWriter;", "output", "Lorg/molap/exporter/DataFrameOutput;", "newLine", "", "<init>", "(Lorg/molap/exporter/DataFrameOutput;Ljava/lang/String;)V", "columnNames", "", "", "row", "column", "first", "", "start", "", "name", "writeColumnName", "hasMore", "includeType", "writeType", "Lkotlin/reflect/KClass;", "writeCell", "Row", "Column", "Value", "value", "", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "rowKey", "columnKey", "(Ljava/lang/Object;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "nextColumn", "nextRow", "end", "close", "terminate", "Companion", "molap"})
@SourceDebugExtension(value={"SMAP\nJSONDataFrameWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONDataFrameWriter.kt\norg/molap/exporter/JSONDataFrameWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class JSONDataFrameWriter
extends AbstractDataFrameWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFrameOutput output;
    @NotNull
    private final Map<Integer, String> columnNames;
    @NotNull
    private final String newLine;
    private int row;
    private int column;
    private boolean first;

    public JSONDataFrameWriter(@NotNull DataFrameOutput output2, @NotNull String newLine) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)newLine, (String)"newLine");
        this.output = output2;
        this.first = true;
        this.columnNames = new HashMap();
        this.newLine = newLine;
        this.output.write("{");
        this.output.write(newLine);
    }

    @Override
    @JvmOverloads
    public void start() throws IOException {
        this.start("data");
    }

    @JvmOverloads
    public final void start(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.first) {
            this.output.write(",");
            this.output.write(this.newLine);
        } else {
            this.first = false;
        }
        this.output.write("\t\"" + name + "\": [");
    }

    @Override
    public void writeColumnName(@Nullable String name, boolean hasMore) throws IOException {
        Integer n = this.column;
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        this.columnNames.put(n, string);
        int n2 = this.column;
        this.column = n2 + 1;
    }

    @Override
    public boolean includeType() {
        return false;
    }

    @Override
    public void writeType(@NotNull KClass<?> name, boolean hasMore) throws IOException {
        Intrinsics.checkNotNullParameter(name, (String)"name");
    }

    /*
     * WARNING - void declaration
     */
    public <Row, Column, Value> void writeCell(@Nullable Object value, @NotNull DataFrame<Row, Column, Value> dataFrame, Row rowKey, Column columnKey) throws IOException {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (this.column == 0) {
            if (this.row > 1) {
                this.output.write("},");
            }
            this.output.write(this.newLine);
            this.output.write("\t\t{");
        } else {
            this.output.write(", ");
        }
        Object str = null;
        if (value == null) {
            str = "null";
        } else if (value instanceof Date) {
            str = "\"" + this.dateToString(dataFrame, columnKey, (Date)value) + "\"";
        } else if (value instanceof Number) {
            str = AbstractDataFrameWriter.Companion.numberToString((Number)value);
        } else if (value instanceof Quantity) {
            str = AbstractDataFrameWriter.Companion.numberToString(((Quantity)value).getAmount());
        } else if (value instanceof DateTimeTz) {
            str = "\"" + ((DateTimeTz)value).toISOString() + "\"";
        } else if (value instanceof Boolean) {
            str = String.valueOf((Boolean)value);
        } else if (value instanceof byte[]) {
            void $this$writeCell_u24lambda_u240;
            HexFormat.Builder builder;
            HexFormat.Builder builder2 = builder = new HexFormat.Builder();
            byte[] byArray = (byte[])value;
            boolean bl = false;
            $this$writeCell_u24lambda_u240.getNumber().setPrefix("0x");
            str = HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)builder.build());
        } else if (value instanceof Object[]) {
            Object array = value;
            str = "[";
            int n = ((Object[])array).length;
            for (int i = 0; i < n; ++i) {
                Object s = ((Object[])array)[i];
                Intrinsics.checkNotNull((Object)s, (String)"null cannot be cast to non-null type kotlin.String");
                str = (String)str + "\"" + Companion.quote((String)s) + "\"";
                if (i >= ((Object[])array).length - 1) continue;
                str = (String)str + ", ";
            }
            str = (String)str + "]";
        } else {
            str = value.toString();
            str = ((String)str).length() > 0 ? "\"" + Companion.quote((String)str) + "\"" : "null";
        }
        this.output.write("\"" + this.columnNames.get(this.column) + "\": ");
        this.output.write((String)str);
    }

    @Override
    public void nextColumn(boolean hasMore) throws IOException {
        int n = this.column;
        this.column = n + 1;
    }

    @Override
    public void nextRow() throws IOException {
        this.column = 0;
        int n = this.row;
        this.row = n + 1;
    }

    public final void end() throws IOException {
        if (this.row > 2) {
            this.output.write("}");
        }
        this.output.write(this.newLine);
        this.output.write("\t]");
        this.row = 0;
        this.column = 0;
    }

    @Override
    public void close() throws IOException {
        this.end();
        this.terminate();
    }

    public final void terminate() throws IOException {
        this.output.write(this.newLine);
        this.output.write("}");
        this.output.close();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/molap/exporter/JSONDataFrameWriter$Companion;", "", "<init>", "()V", "quote", "", "string", "molap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String quote(@Nullable String string) {
            if (string == null || string.length() == 0) {
                return "";
            }
            char c = '\u0000';
            int i = 0;
            int len = string.length();
            StringBuilder sb = new StringBuilder(len + 4);
            String t = null;
            block8: for (i = 0; i < len; ++i) {
                c = string.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        sb.append('\\');
                        StringBuilder stringBuilder = sb.append(c);
                        continue block8;
                    }
                    case '/': {
                        sb.append('\\');
                        StringBuilder stringBuilder = sb.append(c);
                        continue block8;
                    }
                    case '\b': {
                        StringBuilder stringBuilder = sb.append("\\b");
                        continue block8;
                    }
                    case '\t': {
                        StringBuilder stringBuilder = sb.append("\\t");
                        continue block8;
                    }
                    case '\n': {
                        StringBuilder stringBuilder = sb.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        StringBuilder stringBuilder = sb.append("\\r");
                        continue block8;
                    }
                    default: {
                        StringBuilder stringBuilder;
                        if (Intrinsics.compare((int)c, (int)32) < 0) {
                            t = "000" + Integer.toHexString(c);
                            String string2 = t.substring(t.length() - 4);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            stringBuilder = sb.append("\\u" + string2);
                            continue block8;
                        }
                        stringBuilder = sb.append(c);
                    }
                }
            }
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

