/*
 * Decompiled with CFR 0.152.
 */
package org.molap.series;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.series.AbstractSeries;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0016\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020\u001aJ\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020\u001aR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/molap/series/IndexedSeries;", "K", "V", "Lorg/molap/series/AbstractSeries;", "name", "", "values", "", "keys", "<init>", "(Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)V", "index", "Lorg/molap/index/UniqueIndex;", "(Ljava/lang/Object;[Ljava/lang/Object;Lorg/molap/index/UniqueIndex;)V", "[Ljava/lang/Object;", "getName", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "i", "", "(I)Ljava/lang/Object;", "size", "getAddress", "(Ljava/lang/Object;)I", "", "head", "Lorg/molap/series/Series;", "count", "tail", "molap"})
public final class IndexedSeries<K, V>
extends AbstractSeries<K, V> {
    @NotNull
    private final V[] values;
    @NotNull
    private final UniqueIndex<K> index;
    @Nullable
    private final Object name;

    @Override
    @Nullable
    public Object getName() {
        return this.name;
    }

    public IndexedSeries(@Nullable Object name, @NotNull V[] values, @NotNull K[] keys2) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        this.name = name;
        this.values = values;
        this.index = new DefaultUniqueIndex<K>(UniqueIndex.Duplicate.UseFirstWarn, Arrays.copyOf(keys2, keys2.length));
    }

    public IndexedSeries(@Nullable Object name, @NotNull V[] values, @NotNull UniqueIndex<K> index) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(index, (String)"index");
        this.name = name;
        this.values = values;
        this.index = index;
    }

    @Override
    @NotNull
    public KClass<? extends Object> getType() {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    public V get(K key) {
        int index = this.index.getAddress(key);
        return this.values[index];
    }

    @Override
    public K getKey(int i) {
        return (K)this.index.getKey(i);
    }

    @Override
    public int size() {
        return this.index.getSize();
    }

    @Override
    public int getAddress(K key) {
        return this.index.getAddress(key);
    }

    @Override
    @NotNull
    public Iterable<K> keys() {
        return this.index.keys();
    }

    @NotNull
    public final Series<K, V> head(int count) {
        return new IndexedSeries<K, V>((Object)("head(" + this.getName() + ")"), this.values, this.index.head(count));
    }

    @NotNull
    public final Series<K, V> tail(int count) {
        return new IndexedSeries<K, V>((Object)("tail(" + this.getName() + ")"), this.values, this.index.tail(count));
    }
}

