/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.series.Series;
import org.molap.subset.Reducer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J;\u0010\b\u001a\u00020\t2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00028\u0001`\f2\u0006\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ;\u0010\u0010\u001a\u00020\t2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00028\u0001`\f2\u0006\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/molap/subset/SumReducer;", "Row", "Bin", "Lorg/molap/subset/Reducer;", "series", "Lorg/molap/series/Series;", "<init>", "(Lorg/molap/series/Series;)V", "add", "", "sums", "", "Lcom/macrofocus/common/collection/TObjectDoubleMap;", "bin", "row", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)D", "remove", "getNumber", "", "(Ljava/lang/Object;)Ljava/lang/Number;", "molap"})
public final class SumReducer<Row, Bin>
implements Reducer<Row, Bin> {
    @NotNull
    private final Series<Row, ?> series;

    public SumReducer(@NotNull Series<Row, Bin> series) {
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this.series = series;
    }

    @Override
    public double add(@NotNull Map<Bin, Double> sums, Bin bin, Row row) {
        Intrinsics.checkNotNullParameter(sums, (String)"sums");
        double sum = ((Number)MapsKt.getValue(sums, bin)).doubleValue();
        Number value = this.getNumber(row);
        if (value != null) {
            sums.put(bin, sum += value.doubleValue());
        }
        return sum;
    }

    @Override
    public double remove(@NotNull Map<Bin, Double> sums, Bin bin, Row row) {
        Intrinsics.checkNotNullParameter(sums, (String)"sums");
        double sum = ((Number)MapsKt.getValue(sums, bin)).doubleValue();
        Number value = this.getNumber(row);
        if (value != null) {
            sums.put(bin, sum -= value.doubleValue());
        }
        return sum;
    }

    @Override
    @Nullable
    public Number getNumber(Row row) {
        Object obj = this.series.get(row);
        Intrinsics.checkNotNull(obj);
        Object value = obj;
        return value instanceof Number ? (Number)((Number)value) : (Number)null;
    }
}

