/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AbstractAveragingLayer;
import org.mkui.canvas.AntiAliasingBufferedImageOp;
import org.mkui.canvas.SwingLayer;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/mkui/canvas/AveragingSwingLayer;", "Lorg/mkui/canvas/AbstractAveragingLayer;", "Lorg/mkui/canvas/SwingLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "antialiasing", "", "<init>", "(Lorg/mkui/graphics/IDrawing;Z)V", "image", "Ljava/awt/image/BufferedImage;", "prepare", "", "width", "", "height", "resize", "render", "g", "Ljava/awt/Graphics2D;", "createAntiAliasedImage", "img", "clear", "Companion", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAveragingSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AveragingSwingLayer.kt\norg/mkui/canvas/AveragingSwingLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class AveragingSwingLayer
extends AbstractAveragingLayer
implements SwingLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    @Nullable
    private BufferedImage image;
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = false;
    private static final int nAvailableProcessors = Math.max(Runtime.getRuntime().availableProcessors(), 1);

    public AveragingSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            this.iDrawing.draw(this.getG(), null, width, height, new Rectangle(0, 0, width, height));
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getData(...)");
            int[] pixels = nArray;
            int n = this.getOverlay().length;
            for (int i = 0; i < n; ++i) {
                int count = this.getOverlay()[i];
                if (count > 0) {
                    boolean bl;
                    float[] c2 = this.getRgb()[i];
                    float red = c2[0] / (float)count;
                    float green = c2[1] / (float)count;
                    float blue = c2[2] / (float)count;
                    boolean bl2 = bl = red >= 0.0f && red <= 1.0f;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-AveragingSwingLayer$prepare$42 = false;
                        String $i$a$-assert-AveragingSwingLayer$prepare$42 = red + ", " + c2[0] + ", " + count;
                        throw new AssertionError((Object)$i$a$-assert-AveragingSwingLayer$prepare$42);
                    }
                    boolean bl3 = bl = green >= 0.0f && green <= 1.0f;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-AveragingSwingLayer$prepare$52 = false;
                        String $i$a$-assert-AveragingSwingLayer$prepare$52 = green + ", " + c2[1] + ", " + count;
                        throw new AssertionError((Object)$i$a$-assert-AveragingSwingLayer$prepare$52);
                    }
                    boolean bl4 = bl = blue >= 0.0f && blue <= 1.0f;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl5 = false;
                        String string = blue + ", " + c2[2] + ", " + count;
                        throw new AssertionError((Object)string);
                    }
                    Color color = new Color(red, green, blue);
                    pixels[i] = color.getRGB();
                    continue;
                }
                pixels[i] = 0xFFFFFF;
            }
            if (this.antialiasing) {
                this.image = this.createAntiAliasedImage(this.image);
            }
        }
    }

    public final void resize(int width, int height) {
        if ((this.getWidth() != width || this.getHeight() != height) && width > 0 && height > 0) {
            int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
            WritableRaster writableRaster = Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, width, height, nArray), new Point(0, 0));
            Intrinsics.checkNotNullExpressionValue((Object)writableRaster, (String)"createWritableRaster(...)");
            WritableRaster ras = writableRaster;
            BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216), ras, false, new Hashtable());
            int[] o = new int[width * height];
            int n = 0;
            int n2 = width * height;
            float[][] fArrayArray = new float[n2][];
            while (n < n2) {
                int n3 = n++;
                fArrayArray[n3] = new float[3];
            }
            float[][] rgb = fArrayArray;
            n2 = ((Object[])rgb).length;
            for (int i = 0; i < n2; ++i) {
                rgb[i] = new float[3];
            }
            this.setWidth(width);
            this.setHeight(height);
            this.image = bufferedImage;
            this.setOverlay(o);
            this.setRgb(rgb);
            this.setCx1(0);
            this.setCy1(0);
            this.setCx2(width - 1);
            this.setCy2(height - 1);
        } else {
            this.clear();
        }
    }

    @Override
    public void render(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
        if (this.iDrawing.isActive() && this.image != null) {
            g2.drawImage((Image)this.image, 0, 0, null);
        }
    }

    private final BufferedImage createAntiAliasedImage(BufferedImage img) {
        return img != null ? new AntiAliasingBufferedImageOp().filter(img, null) : null;
    }

    public final void clear() {
        if (this.image != null) {
            Arrays.fill(this.getOverlay(), 0);
            float[][] fArray = this.getRgb();
            int n = ((Object[])fArray).length;
            for (int i = 0; i < n; ++i) {
                float[] c2 = fArray[i];
                c2[0] = 0.0f;
                c2[1] = 0.0f;
                c2[2] = 0.0f;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/mkui/canvas/AveragingSwingLayer$Companion;", "", "<init>", "()V", "MULTITHREADED", "", "nAvailableProcessors", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

