/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.NoninvertibleTransformException;
import org.mkui.geom.Path2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 p2\u00020\u0001:\u0001pBA\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\t\b\u0016\u00a2\u0006\u0004\b\u000b\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\u000fB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u000b\u0010\u0014B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\u0015B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0017J\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003J\u000e\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u0003J\u001e\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u0016\u00106\u001a\u0002022\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J&\u00106\u001a\u0002022\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u000e\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\nJ\u001e\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\n2\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u0016\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003J\u0016\u0010A\u001a\u0002022\u0006\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J\b\u0010F\u001a\u000202H\u0002J\u000e\u0010G\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\u0016J\u001e\u0010H\u001a\u0002022\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u0016\u0010I\u001a\u0002022\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003J\u000e\u0010H\u001a\u0002022\u0006\u00107\u001a\u00020\u0003J\b\u0010J\u001a\u000202H\u0002J\b\u0010K\u001a\u000202H\u0002J\b\u0010L\u001a\u000202H\u0002J&\u0010H\u001a\u0002022\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u0016\u0010H\u001a\u0002022\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J\u000e\u0010M\u001a\u0002022\u0006\u0010=\u001a\u00020\nJ\u001e\u0010M\u001a\u0002022\u0006\u0010=\u001a\u00020\n2\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u0016\u0010N\u001a\u0002022\u0006\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J\u0006\u0010O\u001a\u000202J\u000e\u0010P\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u0000J6\u0010P\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010Q\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u0000J\u0016\u0010R\u001a\u0002022\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010S\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u0000J\b\u0010T\u001a\u0004\u0018\u00010\u0000J\u0006\u0010U\u001a\u000202J\u001a\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020W2\b\u0010Y\u001a\u0004\u0018\u00010WJA\u0010V\u001a\u0002022\f\u0010X\u001a\b\u0012\u0004\u0012\u00020W0Z2\u0006\u0010[\u001a\u00020\n2\u000e\u0010Y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010W0Z2\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\n\u00a2\u0006\u0002\u0010^J.\u0010V\u001a\u0002022\u0006\u0010_\u001a\u00020\u00132\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nJ.\u0010V\u001a\u0002022\u0006\u0010_\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nJ.\u0010V\u001a\u0002022\u0006\u0010_\u001a\u00020\u00132\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nJ.\u0010V\u001a\u0002022\u0006\u0010_\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nJ\u0018\u0010a\u001a\u00020W2\u0006\u0010X\u001a\u00020W2\b\u0010Y\u001a\u0004\u0018\u00010WJ.\u0010a\u001a\u0002022\u0006\u0010_\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nJ\u001a\u0010b\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020W2\b\u0010Y\u001a\u0004\u0018\u00010WJ.\u0010b\u001a\u0002022\u0006\u0010_\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\n2\u0006\u0010]\u001a\u00020\nJ\u0012\u0010c\u001a\u0004\u0018\u00010d2\b\u0010e\u001a\u0004\u0018\u00010dJ\u0006\u0010i\u001a\u00020\nJ\b\u0010j\u001a\u000202H\u0002J\n\u0010k\u001a\u00020\nH\u0096\u0080\u0004J\u0014\u0010l\u001a\u00020g2\b\u0010m\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010n\u001a\u00020oH\u0096\u0080\u0004R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u001a\u0010)\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u001cR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010D\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u001aR\u0011\u0010f\u001a\u00020g8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010h\u00a8\u0006q"}, d2={"Lorg/mkui/geom/AffineTransform;", "", "m00", "", "m10", "m01", "m11", "m02", "m12", "state", "", "<init>", "(DDDDDDI)V", "()V", "Tx", "(Lorg/mkui/geom/AffineTransform;)V", "", "(FFFFFF)V", "flatmatrix", "", "([F)V", "(DDDDDD)V", "", "([D)V", "scaleX", "getScaleX", "()D", "setScaleX", "(D)V", "shearY", "getShearY", "setShearY", "shearX", "getShearX", "setShearX", "scaleY", "getScaleY", "setScaleY", "translateX", "getTranslateX", "setTranslateX", "translateY", "getTranslateY", "setTranslateY", "getState", "()I", "setState", "(I)V", "type", "updateState", "", "setToTranslation", "tx", "ty", "setToRotation", "theta", "anchorx", "anchory", "vecx", "vecy", "setToQuadrantRotation", "numquadrants", "setToScale", "sx", "sy", "setToShear", "shx", "shy", "determinant", "getDeterminant", "stateError", "getMatrix", "rotate", "translate", "rotate90", "rotate180", "rotate270", "quadrantRotate", "shear", "setToIdentity", "setTransform", "concatenate", "scale", "preConcatenate", "createInverse", "invert", "transform", "Lorg/mkui/geom/Point2D;", "ptSrc", "ptDst", "", "srcOff", "dstOff", "numPts", "([Lorg/mkui/geom/Point2D;I[Lorg/mkui/geom/Point2D;II)V", "srcPts", "dstPts", "inverseTransform", "deltaTransform", "createTransformedShape", "Lorg/mkui/geom/Shape;", "pSrc", "isIdentity", "", "()Z", "getType", "calculateType", "hashCode", "equals", "obj", "toString", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAffineTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffineTransform.kt\norg/mkui/geom/AffineTransform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,4612:1\n1#2:4613\n*E\n"})
public final class AffineTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double scaleX;
    private double shearY;
    private double shearX;
    private double scaleY;
    private double translateX;
    private double translateY;
    private transient int state;
    private transient int type;
    public static final int $stable = 8;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int APPLY_IDENTITY = 0;
    public static final int APPLY_TRANSLATE = 1;
    public static final int APPLY_SCALE = 2;
    public static final int APPLY_SHEAR = 4;
    private static final int TYPE_UNKNOWN = -1;
    private static final int HI_SHIFT = 3;
    private static final int HI_IDENTITY = 0;
    private static final int HI_TRANSLATE = 8;
    private static final int HI_SCALE = 16;
    private static final int HI_SHEAR = 32;
    @NotNull
    private static final int[] rot90conversion;

    public final double getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(double d) {
        this.scaleX = d;
    }

    public final double getShearY() {
        return this.shearY;
    }

    public final void setShearY(double d) {
        this.shearY = d;
    }

    public final double getShearX() {
        return this.shearX;
    }

    public final void setShearX(double d) {
        this.shearX = d;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(double d) {
        this.scaleY = d;
    }

    public final double getTranslateX() {
        return this.translateX;
    }

    public final void setTranslateX(double d) {
        this.translateX = d;
    }

    public final double getTranslateY() {
        return this.translateY;
    }

    public final void setTranslateY(double d) {
        this.translateY = d;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    private AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12, int state) {
        this.scaleX = m00;
        this.shearY = m10;
        this.shearX = m01;
        this.scaleY = m11;
        this.translateX = m02;
        this.translateY = m12;
        this.state = state;
        this.type = -1;
    }

    public AffineTransform() {
        this.scaleX = this.scaleY = 1.0;
    }

    public AffineTransform(@NotNull AffineTransform Tx) {
        Intrinsics.checkNotNullParameter((Object)Tx, (String)"Tx");
        this.scaleX = Tx.scaleX;
        this.shearY = Tx.shearY;
        this.shearX = Tx.shearX;
        this.scaleY = Tx.scaleY;
        this.translateX = Tx.translateX;
        this.translateY = Tx.translateY;
        this.state = Tx.state;
        this.type = Tx.type;
    }

    public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.scaleX = m00;
        this.shearY = m10;
        this.shearX = m01;
        this.scaleY = m11;
        this.translateX = m02;
        this.translateY = m12;
        this.updateState();
    }

    public final void updateState() {
        if (this.shearX == 0.0 && this.shearY == 0.0) {
            if (this.scaleX == 1.0 && this.scaleY == 1.0) {
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 0;
                    this.type = 0;
                } else {
                    this.state = 1;
                    this.type = 1;
                }
            } else if (this.translateX == 0.0 && this.translateY == 0.0) {
                this.state = 2;
                this.type = -1;
            } else {
                this.state = 3;
                this.type = -1;
            }
        } else if (this.scaleX == 0.0 && this.scaleY == 0.0) {
            if (this.translateX == 0.0 && this.translateY == 0.0) {
                this.state = 4;
                this.type = -1;
            } else {
                this.state = 5;
                this.type = -1;
            }
        } else if (this.translateX == 0.0 && this.translateY == 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 7;
            this.type = -1;
        }
    }

    public AffineTransform(@NotNull float[] flatmatrix) {
        Intrinsics.checkNotNullParameter((Object)flatmatrix, (String)"flatmatrix");
        this.scaleX = flatmatrix[0];
        this.shearY = flatmatrix[1];
        this.shearX = flatmatrix[2];
        this.scaleY = flatmatrix[3];
        if (flatmatrix.length > 5) {
            this.translateX = flatmatrix[4];
            this.translateY = flatmatrix[5];
        }
        this.updateState();
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.scaleX = m00;
        this.shearY = m10;
        this.shearX = m01;
        this.scaleY = m11;
        this.translateX = m02;
        this.translateY = m12;
        this.updateState();
    }

    public AffineTransform(@NotNull double[] flatmatrix) {
        Intrinsics.checkNotNullParameter((Object)flatmatrix, (String)"flatmatrix");
        this.scaleX = flatmatrix[0];
        this.shearY = flatmatrix[1];
        this.shearX = flatmatrix[2];
        this.scaleY = flatmatrix[3];
        if (flatmatrix.length > 5) {
            this.translateX = flatmatrix[4];
            this.translateY = flatmatrix[5];
        }
        this.updateState();
    }

    public final void setToTranslation(double tx, double ty) {
        this.scaleX = 1.0;
        this.shearY = 0.0;
        this.shearX = 0.0;
        this.scaleY = 1.0;
        this.translateX = tx;
        this.translateY = ty;
        if (!(tx == 0.0) || !(ty == 0.0)) {
            this.state = 1;
            this.type = 1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public final void setToRotation(double theta) {
        double sin = Math.sin(theta);
        double cos = 0.0;
        if (sin == 1.0 || sin == -1.0) {
            cos = 0.0;
            this.state = 4;
            this.type = 8;
        } else {
            cos = Math.cos(theta);
            double d = cos;
            if (d == -1.0) {
                sin = 0.0;
                this.state = 2;
                this.type = 8;
            } else if (d == 1.0) {
                sin = 0.0;
                this.state = 0;
                this.type = 0;
            } else {
                this.state = 6;
                this.type = 16;
            }
        }
        this.scaleX = cos;
        this.shearY = sin;
        this.shearX = -sin;
        this.scaleY = cos;
        this.translateX = 0.0;
        this.translateY = 0.0;
    }

    public final void setToRotation(double theta, double anchorx, double anchory) {
        this.setToRotation(theta);
        double sin = this.shearY;
        double oneMinusCos = 1.0 - this.scaleX;
        this.translateX = anchorx * oneMinusCos + anchory * sin;
        this.translateY = anchory * oneMinusCos - anchorx * sin;
        if (!(this.translateX == 0.0) || !(this.translateY == 0.0)) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public final void setToRotation(double vecx, double vecy) {
        double sin = 0.0;
        double cos = 0.0;
        if (vecy == 0.0) {
            sin = 0.0;
            if (vecx < 0.0) {
                cos = -1.0;
                this.state = 2;
                this.type = 8;
            } else {
                cos = 1.0;
                this.state = 0;
                this.type = 0;
            }
        } else if (vecx == 0.0) {
            cos = 0.0;
            sin = vecy > 0.0 ? 1.0 : -1.0;
            this.state = 4;
            this.type = 8;
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            cos = vecx / len;
            sin = vecy / len;
            this.state = 6;
            this.type = 16;
        }
        this.scaleX = cos;
        this.shearY = sin;
        this.shearX = -sin;
        this.scaleY = cos;
        this.translateX = 0.0;
        this.translateY = 0.0;
    }

    public final void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        this.setToRotation(vecx, vecy);
        double sin = this.shearY;
        double oneMinusCos = 1.0 - this.scaleX;
        this.translateX = anchorx * oneMinusCos + anchory * sin;
        this.translateY = anchory * oneMinusCos - anchorx * sin;
        if (!(this.translateX == 0.0) || !(this.translateY == 0.0)) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public final void setToQuadrantRotation(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                this.scaleX = 1.0;
                this.shearY = 0.0;
                this.shearX = 0.0;
                this.scaleY = 1.0;
                this.translateX = 0.0;
                this.translateY = 0.0;
                this.state = 0;
                this.type = 0;
                break;
            }
            case 1: {
                this.scaleX = 0.0;
                this.shearY = 1.0;
                this.shearX = -1.0;
                this.scaleY = 0.0;
                this.translateX = 0.0;
                this.translateY = 0.0;
                this.state = 4;
                this.type = 8;
                break;
            }
            case 2: {
                this.scaleX = -1.0;
                this.shearY = 0.0;
                this.shearX = 0.0;
                this.scaleY = -1.0;
                this.translateX = 0.0;
                this.translateY = 0.0;
                this.state = 2;
                this.type = 8;
                break;
            }
            case 3: {
                this.scaleX = 0.0;
                this.shearY = -1.0;
                this.shearX = 1.0;
                this.scaleY = 0.0;
                this.translateX = 0.0;
                this.translateY = 0.0;
                this.state = 4;
                this.type = 8;
            }
        }
    }

    public final void setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                this.scaleX = 1.0;
                this.shearY = 0.0;
                this.shearX = 0.0;
                this.scaleY = 1.0;
                this.translateX = 0.0;
                this.translateY = 0.0;
                this.state = 0;
                this.type = 0;
                break;
            }
            case 1: {
                this.scaleX = 0.0;
                this.shearY = 1.0;
                this.shearX = -1.0;
                this.scaleY = 0.0;
                this.translateX = anchorx + anchory;
                this.translateY = anchory - anchorx;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 4;
                    this.type = 8;
                    break;
                }
                this.state = 5;
                this.type = 9;
                break;
            }
            case 2: {
                this.scaleX = -1.0;
                this.shearY = 0.0;
                this.shearX = 0.0;
                this.scaleY = -1.0;
                this.translateX = anchorx + anchorx;
                this.translateY = anchory + anchory;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 2;
                    this.type = 8;
                    break;
                }
                this.state = 3;
                this.type = 9;
                break;
            }
            case 3: {
                this.scaleX = 0.0;
                this.shearY = -1.0;
                this.shearX = 1.0;
                this.scaleY = 0.0;
                this.translateX = anchorx - anchory;
                this.translateY = anchory + anchorx;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 4;
                    this.type = 8;
                    break;
                }
                this.state = 5;
                this.type = 9;
            }
        }
    }

    public final void setToScale(double sx, double sy) {
        this.scaleX = sx;
        this.shearY = 0.0;
        this.shearX = 0.0;
        this.scaleY = sy;
        this.translateX = 0.0;
        this.translateY = 0.0;
        if (!(sx == 1.0) || !(sy == 1.0)) {
            this.state = 2;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public final void setToShear(double shx, double shy) {
        this.scaleX = 1.0;
        this.shearX = shx;
        this.shearY = shy;
        this.scaleY = 1.0;
        this.translateX = 0.0;
        this.translateY = 0.0;
        if (!(shx == 0.0) || !(shy == 0.0)) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public final double getDeterminant() {
        return switch (this.state) {
            case 6, 7 -> this.scaleX * this.scaleY - this.shearX * this.shearY;
            case 4, 5 -> -(this.shearX * this.shearY);
            case 2, 3 -> this.scaleX * this.scaleY;
            case 0, 1 -> 1.0;
            default -> {
                this.stateError();
                yield this.scaleX * this.scaleY - this.shearX * this.shearY;
            }
        };
    }

    private final void stateError() {
        throw new UnsupportedOperationException("missing case in transform state switch");
    }

    public final void getMatrix(@NotNull double[] flatmatrix) {
        Intrinsics.checkNotNullParameter((Object)flatmatrix, (String)"flatmatrix");
        flatmatrix[0] = this.scaleX;
        flatmatrix[1] = this.shearY;
        flatmatrix[2] = this.shearX;
        flatmatrix[3] = this.scaleY;
        if (flatmatrix.length > 5) {
            flatmatrix[4] = this.translateX;
            flatmatrix[5] = this.translateY;
        }
    }

    public final void rotate(double theta, double anchorx, double anchory) {
        this.translate(anchorx, anchory);
        this.rotate(theta);
        this.translate(-anchorx, -anchory);
    }

    public final void translate(double tx, double ty) {
        switch (this.state) {
            case 7: {
                this.translateX = tx * this.scaleX + ty * this.shearX + this.translateX;
                this.translateY = tx * this.shearY + ty * this.scaleY + this.translateY;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 6;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 6: {
                this.translateX = tx * this.scaleX + ty * this.shearX;
                this.translateY = tx * this.shearY + ty * this.scaleY;
                if (!(this.translateX == 0.0) || !(this.translateY == 0.0)) {
                    this.state = 7;
                    this.type |= 1;
                }
                return;
            }
            case 5: {
                this.translateX = ty * this.shearX + this.translateX;
                this.translateY = tx * this.shearY + this.translateY;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 4;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 4: {
                this.translateX = ty * this.shearX;
                this.translateY = tx * this.shearY;
                if (!(this.translateX == 0.0) || !(this.translateY == 0.0)) {
                    this.state = 5;
                    this.type |= 1;
                }
                return;
            }
            case 3: {
                this.translateX = tx * this.scaleX + this.translateX;
                this.translateY = ty * this.scaleY + this.translateY;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 2;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 2: {
                this.translateX = tx * this.scaleX;
                this.translateY = ty * this.scaleY;
                if (!(this.translateX == 0.0) || !(this.translateY == 0.0)) {
                    this.state = 3;
                    this.type |= 1;
                }
                return;
            }
            case 1: {
                this.translateX = tx + this.translateX;
                this.translateY = ty + this.translateY;
                if (this.translateX == 0.0 && this.translateY == 0.0) {
                    this.state = 0;
                    this.type = 0;
                }
                return;
            }
            case 0: {
                this.translateX = tx;
                this.translateY = ty;
                if (!(tx == 0.0) || !(ty == 0.0)) {
                    this.state = 1;
                    this.type = 1;
                }
                return;
            }
        }
        this.stateError();
    }

    public final void rotate(double theta) {
        double sin = Math.sin(theta);
        if (sin == 1.0) {
            this.rotate90();
        } else if (sin == -1.0) {
            this.rotate270();
        } else {
            double cos = Math.cos(theta);
            if (cos == -1.0) {
                this.rotate180();
            } else if (!(cos == 1.0)) {
                double M0 = this.scaleX;
                double M1 = this.shearX;
                this.scaleX = cos * M0 + sin * M1;
                this.shearX = -sin * M0 + cos * M1;
                M0 = this.shearY;
                M1 = this.scaleY;
                this.shearY = cos * M0 + sin * M1;
                this.scaleY = -sin * M0 + cos * M1;
                this.updateState();
            }
        }
    }

    private final void rotate90() {
        double M0 = this.scaleX;
        this.scaleX = this.shearX;
        this.shearX = -M0;
        M0 = this.shearY;
        this.shearY = this.scaleY;
        this.scaleY = -M0;
        int state = rot90conversion[this.state];
        if ((state & 6) == 2 && this.scaleX == 1.0 && this.scaleY == 1.0) {
            state -= 2;
        }
        this.state = state;
        this.type = -1;
    }

    private final void rotate180() {
        this.scaleX = -this.scaleX;
        this.scaleY = -this.scaleY;
        int state = this.state;
        if ((state & 4) != 0) {
            this.shearX = -this.shearX;
            this.shearY = -this.shearY;
        } else {
            this.state = this.scaleX == 1.0 && this.scaleY == 1.0 ? state & 0xFFFFFFFD : state | 2;
        }
        this.type = -1;
    }

    private final void rotate270() {
        double M0 = this.scaleX;
        this.scaleX = -this.shearX;
        this.shearX = M0;
        M0 = this.shearY;
        this.shearY = -this.scaleY;
        this.scaleY = M0;
        int state = rot90conversion[this.state];
        if ((state & 6) == 2 && this.scaleX == 1.0 && this.scaleY == 1.0) {
            state -= 2;
        }
        this.state = state;
        this.type = -1;
    }

    public final void rotate(double vecx, double vecy, double anchorx, double anchory) {
        this.translate(anchorx, anchory);
        this.rotate(vecx, vecy);
        this.translate(-anchorx, -anchory);
    }

    public final void rotate(double vecx, double vecy) {
        if (vecy == 0.0) {
            if (vecx < 0.0) {
                this.rotate180();
            }
        } else if (vecx == 0.0) {
            if (vecy > 0.0) {
                this.rotate90();
            } else {
                this.rotate270();
            }
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            double M0 = this.scaleX;
            double M1 = this.shearX;
            double cos = vecx / len;
            double sin = vecy / len;
            this.scaleX = cos * M0 + sin * M1;
            this.shearX = -sin * M0 + cos * M1;
            M0 = this.shearY;
            M1 = this.scaleY;
            this.shearY = cos * M0 + sin * M1;
            this.scaleY = -sin * M0 + cos * M1;
            this.updateState();
        }
    }

    public final void quadrantRotate(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                break;
            }
            case 1: {
                this.rotate90();
                break;
            }
            case 2: {
                this.rotate180();
                break;
            }
            case 3: {
                this.rotate270();
            }
        }
    }

    public final void quadrantRotate(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                return;
            }
            case 1: {
                this.translateX += anchorx * (this.scaleX - this.shearX) + anchory * (this.shearX + this.scaleX);
                this.translateY += anchorx * (this.shearY - this.scaleY) + anchory * (this.scaleY + this.shearY);
                this.rotate90();
                break;
            }
            case 2: {
                this.translateX += anchorx * (this.scaleX + this.scaleX) + anchory * (this.shearX + this.shearX);
                this.translateY += anchorx * (this.shearY + this.shearY) + anchory * (this.scaleY + this.scaleY);
                this.rotate180();
                break;
            }
            case 3: {
                this.translateX += anchorx * (this.scaleX + this.shearX) + anchory * (this.shearX - this.scaleX);
                this.translateY += anchorx * (this.shearY + this.scaleY) + anchory * (this.scaleY - this.shearY);
                this.rotate270();
            }
        }
        this.state = this.translateX == 0.0 && this.translateY == 0.0 ? this.state & 0xFFFFFFFE : this.state | 1;
    }

    public final void shear(double shx, double shy) {
        int state = this.state;
        switch (state) {
            case 6: 
            case 7: {
                double M0 = 0.0;
                double M1 = 0.0;
                M0 = this.scaleX;
                M1 = this.shearX;
                this.scaleX = M0 + M1 * shy;
                this.shearX = M0 * shx + M1;
                M0 = this.shearY;
                M1 = this.scaleY;
                this.shearY = M0 + M1 * shy;
                this.scaleY = M0 * shx + M1;
                this.updateState();
                return;
            }
            case 4: 
            case 5: {
                this.scaleX = this.shearX * shy;
                this.scaleY = this.shearY * shx;
                if (!(this.scaleX == 0.0) || !(this.scaleY == 0.0)) {
                    this.state = state | 2;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.shearX = this.scaleX * shx;
                this.shearY = this.scaleY * shy;
                if (!(this.shearX == 0.0) || !(this.shearY == 0.0)) {
                    this.state = state | 4;
                }
                this.type = -1;
                return;
            }
            case 0: 
            case 1: {
                this.shearX = shx;
                this.shearY = shy;
                if (!(this.shearX == 0.0) || !(this.shearY == 0.0)) {
                    this.state = state | 2 | 4;
                    this.type = -1;
                }
                return;
            }
        }
        this.stateError();
    }

    public final void setToIdentity() {
        this.scaleX = this.scaleY = 1.0;
        this.shearY = this.shearX = (this.translateX = (this.translateY = 0.0));
        this.state = 0;
        this.type = 0;
    }

    public final void setTransform(@NotNull AffineTransform Tx) {
        Intrinsics.checkNotNullParameter((Object)Tx, (String)"Tx");
        this.scaleX = Tx.scaleX;
        this.shearY = Tx.shearY;
        this.shearX = Tx.shearX;
        this.scaleY = Tx.scaleY;
        this.translateX = Tx.translateX;
        this.translateY = Tx.translateY;
        this.state = Tx.state;
        this.type = Tx.type;
    }

    public final void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.scaleX = m00;
        this.shearY = m10;
        this.shearX = m01;
        this.scaleY = m11;
        this.translateX = m02;
        this.translateY = m12;
        this.updateState();
    }

    public final void concatenate(@NotNull AffineTransform Tx) {
        Intrinsics.checkNotNullParameter((Object)Tx, (String)"Tx");
        double M0 = 0.0;
        double T01 = 0.0;
        double T10 = 0.0;
        int mystate = this.state;
        int txstate = Tx.state;
        switch (txstate << 3 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 56: {
                this.shearX = Tx.shearX;
                this.shearY = Tx.shearY;
                this.scaleX = Tx.scaleX;
                this.scaleY = Tx.scaleY;
                this.translateX = Tx.translateX;
                this.translateY = Tx.translateY;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 24: {
                this.scaleX = Tx.scaleX;
                this.scaleY = Tx.scaleY;
                this.translateX = Tx.translateX;
                this.translateY = Tx.translateY;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 8: {
                this.translateX = Tx.translateX;
                this.translateY = Tx.translateY;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 48: {
                this.shearX = Tx.shearX;
                this.shearY = Tx.shearY;
                this.scaleX = Tx.scaleX;
                this.scaleY = Tx.scaleY;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 16: {
                this.scaleX = Tx.scaleX;
                this.scaleY = Tx.scaleY;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 40: {
                this.translateX = Tx.translateX;
                this.translateY = Tx.translateY;
                this.shearX = Tx.shearX;
                this.shearY = Tx.shearY;
                AffineTransform $this$concatenate_u24lambda_u240 = this;
                boolean bl = false;
                $this$concatenate_u24lambda_u240.scaleX = $this$concatenate_u24lambda_u240.scaleY = 0.0;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 32: {
                this.shearX = Tx.shearX;
                this.shearY = Tx.shearY;
                AffineTransform $this$concatenate_u24lambda_u241 = this;
                boolean bl = false;
                $this$concatenate_u24lambda_u241.scaleX = $this$concatenate_u24lambda_u241.scaleY = 0.0;
                this.state = txstate;
                this.type = Tx.type;
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.translate(Tx.translateX, Tx.translateY);
                return;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.scale(Tx.scaleX, Tx.scaleY);
                return;
            }
            case 38: 
            case 39: {
                T01 = Tx.shearX;
                T10 = Tx.shearY;
                M0 = this.scaleX;
                this.scaleX = this.shearX * T10;
                this.shearX = M0 * T01;
                M0 = this.shearY;
                this.shearY = this.scaleY * T10;
                this.scaleY = M0 * T01;
                this.type = -1;
                return;
            }
            case 36: 
            case 37: {
                this.scaleX = this.shearX * Tx.shearY;
                this.shearX = 0.0;
                this.scaleY = this.shearY * Tx.shearX;
                this.shearY = 0.0;
                this.state = mystate ^ 6;
                this.type = -1;
                return;
            }
            case 34: 
            case 35: {
                this.shearX = this.scaleX * Tx.shearX;
                this.scaleX = 0.0;
                this.shearY = this.scaleY * Tx.shearY;
                this.scaleY = 0.0;
                this.state = mystate ^ 6;
                this.type = -1;
                return;
            }
            case 33: {
                this.scaleX = 0.0;
                this.shearX = Tx.shearX;
                this.shearY = Tx.shearY;
                this.scaleY = 0.0;
                this.state = 5;
                this.type = -1;
                return;
            }
        }
        double T00 = Tx.scaleX;
        T01 = Tx.shearX;
        double T02 = Tx.translateX;
        T10 = Tx.shearY;
        double T11 = Tx.scaleY;
        double T12 = Tx.translateY;
        double M1 = 0.0;
        switch (mystate) {
            case 6: {
                this.state = mystate | txstate;
                M0 = this.scaleX;
                M1 = this.shearX;
                this.scaleX = T00 * M0 + T10 * M1;
                this.shearX = T01 * M0 + T11 * M1;
                this.translateX += T02 * M0 + T12 * M1;
                M0 = this.shearY;
                M1 = this.scaleY;
                this.shearY = T00 * M0 + T10 * M1;
                this.scaleY = T01 * M0 + T11 * M1;
                this.translateY += T02 * M0 + T12 * M1;
                this.type = -1;
                return;
            }
            case 7: {
                M0 = this.scaleX;
                M1 = this.shearX;
                this.scaleX = T00 * M0 + T10 * M1;
                this.shearX = T01 * M0 + T11 * M1;
                this.translateX += T02 * M0 + T12 * M1;
                M0 = this.shearY;
                M1 = this.scaleY;
                this.shearY = T00 * M0 + T10 * M1;
                this.scaleY = T01 * M0 + T11 * M1;
                this.translateY += T02 * M0 + T12 * M1;
                this.type = -1;
                return;
            }
            case 4: 
            case 5: {
                M0 = this.shearX;
                this.scaleX = T10 * M0;
                this.shearX = T11 * M0;
                this.translateX += T12 * M0;
                M0 = this.shearY;
                this.shearY = T00 * M0;
                this.scaleY = T01 * M0;
                this.translateY += T02 * M0;
                break;
            }
            case 2: 
            case 3: {
                M0 = this.scaleX;
                this.scaleX = T00 * M0;
                this.shearX = T01 * M0;
                this.translateX += T02 * M0;
                M0 = this.scaleY;
                this.shearY = T10 * M0;
                this.scaleY = T11 * M0;
                this.translateY += T12 * M0;
                break;
            }
            case 1: {
                this.scaleX = T00;
                this.shearX = T01;
                this.translateX += T02;
                this.shearY = T10;
                this.scaleY = T11;
                this.translateY += T12;
                this.state = txstate | 1;
                this.type = -1;
                return;
            }
            default: {
                this.stateError();
                this.state = mystate | txstate;
                M0 = this.scaleX;
                M1 = this.shearX;
                this.scaleX = T00 * M0 + T10 * M1;
                this.shearX = T01 * M0 + T11 * M1;
                this.translateX += T02 * M0 + T12 * M1;
                M0 = this.shearY;
                M1 = this.scaleY;
                this.shearY = T00 * M0 + T10 * M1;
                this.scaleY = T01 * M0 + T11 * M1;
                this.translateY += T02 * M0 + T12 * M1;
                this.type = -1;
                return;
            }
        }
        this.updateState();
    }

    /*
     * WARNING - void declaration
     */
    public final void scale(double sx, double sy) {
        int state = 0;
        state = this.state;
        switch (state) {
            case 6: 
            case 7: {
                this.scaleX *= sx;
                this.scaleY *= sy;
                this.shearX *= sy;
                this.shearY *= sx;
                if (this.shearX == 0.0 && this.shearY == 0.0) {
                    state &= 1;
                    if (this.scaleX == 1.0 && this.scaleY == 1.0) {
                        this.type = state == 0 ? 0 : 1;
                    } else {
                        state |= 2;
                        this.type = -1;
                    }
                    this.state = state;
                }
                return;
            }
            case 4: 
            case 5: {
                this.shearX *= sy;
                this.shearY *= sx;
                if (this.shearX == 0.0 && this.shearY == 0.0) {
                    state &= 1;
                    if (this.scaleX == 1.0 && this.scaleY == 1.0) {
                        this.type = state == 0 ? 0 : 1;
                    } else {
                        state |= 2;
                        this.type = -1;
                    }
                    this.state = state;
                }
                return;
            }
            case 2: 
            case 3: {
                this.scaleX *= sx;
                this.scaleY *= sy;
                if (this.scaleX == 1.0 && this.scaleY == 1.0) {
                    void it;
                    boolean bl = true;
                    AffineTransform affineTransform = this;
                    boolean bl2 = false;
                    int n = state &= it;
                    affineTransform.state = n;
                    this.type = state == 0 ? 0 : 1;
                } else {
                    this.type = -1;
                }
                return;
            }
            case 0: 
            case 1: {
                this.scaleX = sx;
                this.scaleY = sy;
                if (!(sx == 1.0) || !(sy == 1.0)) {
                    this.state = state | 2;
                    this.type = -1;
                }
                return;
            }
        }
        this.stateError();
        this.scaleX *= sx;
        this.scaleY *= sy;
        this.shearX *= sy;
        this.shearY *= sx;
        if (this.shearX == 0.0 && this.shearY == 0.0) {
            state &= 1;
            if (this.scaleX == 1.0 && this.scaleY == 1.0) {
                this.type = state == 0 ? 0 : 1;
            } else {
                state |= 2;
                this.type = -1;
            }
            this.state = state;
        }
    }

    public final void preConcatenate(@NotNull AffineTransform Tx) {
        Intrinsics.checkNotNullParameter((Object)Tx, (String)"Tx");
        double M0 = 0.0;
        double T00 = 0.0;
        double T01 = 0.0;
        double T10 = 0.0;
        double T11 = 0.0;
        int mystate = this.state;
        int txstate = Tx.state;
        switch (txstate << 3 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.translateX = Tx.translateX;
                this.translateY = Tx.translateY;
                this.state = mystate | 1;
                this.type |= 1;
                return;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.translateX += Tx.translateX;
                this.translateY += Tx.translateY;
                return;
            }
            case 16: 
            case 17: {
                this.state = mystate | 2;
                T00 = Tx.scaleX;
                T11 = Tx.scaleY;
                if ((mystate & 4) != 0) {
                    this.shearX *= T00;
                    this.shearY *= T11;
                    if ((mystate & 2) != 0) {
                        this.scaleX *= T00;
                        this.scaleY *= T11;
                    }
                } else {
                    this.scaleX *= T00;
                    this.scaleY *= T11;
                }
                if ((mystate & 1) != 0) {
                    this.translateX *= T00;
                    this.translateY *= T11;
                }
                this.type = -1;
                return;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                T00 = Tx.scaleX;
                T11 = Tx.scaleY;
                if ((mystate & 4) != 0) {
                    this.shearX *= T00;
                    this.shearY *= T11;
                    if ((mystate & 2) != 0) {
                        this.scaleX *= T00;
                        this.scaleY *= T11;
                    }
                } else {
                    this.scaleX *= T00;
                    this.scaleY *= T11;
                }
                if ((mystate & 1) != 0) {
                    this.translateX *= T00;
                    this.translateY *= T11;
                }
                this.type = -1;
                return;
            }
            case 36: 
            case 37: {
                this.state = (mystate |= 2) ^ 4;
                T01 = Tx.shearX;
                T10 = Tx.shearY;
                M0 = this.scaleX;
                this.scaleX = this.shearY * T01;
                this.shearY = M0 * T10;
                M0 = this.shearX;
                this.shearX = this.scaleY * T01;
                this.scaleY = M0 * T10;
                M0 = this.translateX;
                this.translateX = this.translateY * T01;
                this.translateY = M0 * T10;
                this.type = -1;
                return;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.state = mystate ^ 4;
                T01 = Tx.shearX;
                T10 = Tx.shearY;
                M0 = this.scaleX;
                this.scaleX = this.shearY * T01;
                this.shearY = M0 * T10;
                M0 = this.shearX;
                this.shearX = this.scaleY * T01;
                this.scaleY = M0 * T10;
                M0 = this.translateX;
                this.translateX = this.translateY * T01;
                this.translateY = M0 * T10;
                this.type = -1;
                return;
            }
            case 38: 
            case 39: {
                T01 = Tx.shearX;
                T10 = Tx.shearY;
                M0 = this.scaleX;
                this.scaleX = this.shearY * T01;
                this.shearY = M0 * T10;
                M0 = this.shearX;
                this.shearX = this.scaleY * T01;
                this.scaleY = M0 * T10;
                M0 = this.translateX;
                this.translateX = this.translateY * T01;
                this.translateY = M0 * T10;
                this.type = -1;
                return;
            }
        }
        T00 = Tx.scaleX;
        T01 = Tx.shearX;
        double T02 = Tx.translateX;
        T10 = Tx.shearY;
        T11 = Tx.scaleY;
        double T12 = Tx.translateY;
        double M1 = 0.0;
        switch (mystate) {
            case 7: {
                M0 = this.translateX;
                M1 = this.translateY;
                this.translateX = T02 += M0 * T00 + M1 * T01;
                this.translateY = T12 += M0 * T10 + M1 * T11;
                M0 = this.scaleX;
                M1 = this.shearY;
                this.scaleX = M0 * T00 + M1 * T01;
                this.shearY = M0 * T10 + M1 * T11;
                M0 = this.shearX;
                M1 = this.scaleY;
                this.shearX = M0 * T00 + M1 * T01;
                this.scaleY = M0 * T10 + M1 * T11;
                break;
            }
            case 6: {
                this.translateX = T02;
                this.translateY = T12;
                M0 = this.scaleX;
                M1 = this.shearY;
                this.scaleX = M0 * T00 + M1 * T01;
                this.shearY = M0 * T10 + M1 * T11;
                M0 = this.shearX;
                M1 = this.scaleY;
                this.shearX = M0 * T00 + M1 * T01;
                this.scaleY = M0 * T10 + M1 * T11;
                break;
            }
            case 5: {
                M0 = this.translateX;
                M1 = this.translateY;
                this.translateX = T02 += M0 * T00 + M1 * T01;
                this.translateY = T12 += M0 * T10 + M1 * T11;
                M0 = this.shearY;
                this.scaleX = M0 * T01;
                this.shearY = M0 * T11;
                M0 = this.shearX;
                this.shearX = M0 * T00;
                this.scaleY = M0 * T10;
                break;
            }
            case 4: {
                this.translateX = T02;
                this.translateY = T12;
                M0 = this.shearY;
                this.scaleX = M0 * T01;
                this.shearY = M0 * T11;
                M0 = this.shearX;
                this.shearX = M0 * T00;
                this.scaleY = M0 * T10;
                break;
            }
            case 3: {
                M0 = this.translateX;
                M1 = this.translateY;
                this.translateX = T02 += M0 * T00 + M1 * T01;
                this.translateY = T12 += M0 * T10 + M1 * T11;
                M0 = this.scaleX;
                this.scaleX = M0 * T00;
                this.shearY = M0 * T10;
                M0 = this.scaleY;
                this.shearX = M0 * T01;
                this.scaleY = M0 * T11;
                break;
            }
            case 2: {
                this.translateX = T02;
                this.translateY = T12;
                M0 = this.scaleX;
                this.scaleX = M0 * T00;
                this.shearY = M0 * T10;
                M0 = this.scaleY;
                this.shearX = M0 * T01;
                this.scaleY = M0 * T11;
                break;
            }
            case 1: {
                M0 = this.translateX;
                M1 = this.translateY;
                this.translateX = T02 += M0 * T00 + M1 * T01;
                this.translateY = T12 += M0 * T10 + M1 * T11;
                this.scaleX = T00;
                this.shearY = T10;
                this.shearX = T01;
                this.scaleY = T11;
                this.state = mystate | txstate;
                this.type = -1;
                return;
            }
            case 0: {
                this.translateX = T02;
                this.translateY = T12;
                this.scaleX = T00;
                this.shearY = T10;
                this.shearX = T01;
                this.scaleY = T11;
                this.state = mystate | txstate;
                this.type = -1;
                return;
            }
            default: {
                this.stateError();
                M0 = this.translateX;
                M1 = this.translateY;
                this.translateX = T02 += M0 * T00 + M1 * T01;
                this.translateY = T12 += M0 * T10 + M1 * T11;
                M0 = this.scaleX;
                M1 = this.shearY;
                this.scaleX = M0 * T00 + M1 * T01;
                this.shearY = M0 * T10 + M1 * T11;
                M0 = this.shearX;
                M1 = this.scaleY;
                this.shearX = M0 * T00 + M1 * T01;
                this.scaleY = M0 * T10 + M1 * T11;
            }
        }
        this.updateState();
    }

    @Nullable
    public final AffineTransform createInverse() {
        double det = 0.0;
        return switch (this.state) {
            case 7 -> {
                det = this.scaleX * this.scaleY - this.shearX * this.shearY;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                yield new AffineTransform(this.scaleY / det, -this.shearY / det, -this.shearX / det, this.scaleX / det, (this.shearX * this.translateY - this.scaleY * this.translateX) / det, (this.shearY * this.translateX - this.scaleX * this.translateY) / det, 7);
            }
            case 6 -> {
                det = this.scaleX * this.scaleY - this.shearX * this.shearY;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                yield new AffineTransform(this.scaleY / det, -this.shearY / det, -this.shearX / det, this.scaleX / det, 0.0, 0.0, 6);
            }
            case 5 -> {
                if (this.shearX == 0.0 || this.shearY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                yield new AffineTransform(0.0, 1.0 / this.shearX, 1.0 / this.shearY, 0.0, -this.translateY / this.shearY, -this.translateX / this.shearX, 5);
            }
            case 4 -> {
                if (this.shearX == 0.0 || this.shearY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                yield new AffineTransform(0.0, 1.0 / this.shearX, 1.0 / this.shearY, 0.0, 0.0, 0.0, 4);
            }
            case 3 -> {
                if (this.scaleX == 0.0 || this.scaleY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                yield new AffineTransform(1.0 / this.scaleX, 0.0, 0.0, 1.0 / this.scaleY, -this.translateX / this.scaleX, -this.translateY / this.scaleY, 3);
            }
            case 2 -> {
                if (this.scaleX == 0.0 || this.scaleY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                yield new AffineTransform(1.0 / this.scaleX, 0.0, 0.0, 1.0 / this.scaleY, 0.0, 0.0, 2);
            }
            case 1 -> new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.translateX, -this.translateY, 1);
            case 0 -> new AffineTransform();
            default -> {
                this.stateError();
                yield null;
            }
        };
    }

    public final void invert() {
        double M00 = 0.0;
        double M01 = 0.0;
        double M02 = 0.0;
        double M10 = 0.0;
        double M11 = 0.0;
        double M12 = 0.0;
        double det = 0.0;
        switch (this.state) {
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M11 = this.scaleY;
                M12 = this.translateY;
                det = M00 * M11 - M01 * M10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                this.scaleX = M11 / det;
                this.shearY = -M10 / det;
                this.shearX = -M01 / det;
                this.scaleY = M00 / det;
                this.translateX = (M01 * M12 - M11 * M02) / det;
                this.translateY = (M10 * M02 - M00 * M12) / det;
                break;
            }
            case 6: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                det = M00 * M11 - M01 * M10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                this.scaleX = M11 / det;
                this.shearY = -M10 / det;
                this.shearX = -M01 / det;
                this.scaleY = M00 / det;
                break;
            }
            case 5: {
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M12 = this.translateY;
                if (M01 == 0.0 || M10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.shearY = 1.0 / M01;
                this.shearX = 1.0 / M10;
                this.translateX = -M12 / M10;
                this.translateY = -M02 / M01;
                break;
            }
            case 4: {
                M01 = this.shearX;
                M10 = this.shearY;
                if (M01 == 0.0 || M10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.shearY = 1.0 / M01;
                this.shearX = 1.0 / M10;
                break;
            }
            case 3: {
                M00 = this.scaleX;
                M02 = this.translateX;
                M11 = this.scaleY;
                M12 = this.translateY;
                if (M00 == 0.0 || M11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.scaleX = 1.0 / M00;
                this.scaleY = 1.0 / M11;
                this.translateX = -M02 / M00;
                this.translateY = -M12 / M11;
                break;
            }
            case 2: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                if (M00 == 0.0 || M11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.scaleX = 1.0 / M00;
                this.scaleY = 1.0 / M11;
                break;
            }
            case 1: {
                this.translateX = -this.translateX;
                this.translateY = -this.translateY;
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.stateError();
                return;
            }
        }
    }

    @Nullable
    public final Point2D transform(@NotNull Point2D ptSrc, @Nullable Point2D ptDst) {
        Intrinsics.checkNotNullParameter((Object)ptSrc, (String)"ptSrc");
        Point2D ptDst2 = ptDst;
        if (ptDst2 == null) {
            ptDst2 = ptSrc instanceof Point2D.Double ? (Point2D)new Point2D.Double() : (Point2D)new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        return switch (this.state) {
            case 7 -> {
                ptDst2.setLocation(x * this.scaleX + y * this.shearX + this.translateX, x * this.shearY + y * this.scaleY + this.translateY);
                yield ptDst2;
            }
            case 6 -> {
                ptDst2.setLocation(x * this.scaleX + y * this.shearX, x * this.shearY + y * this.scaleY);
                yield ptDst2;
            }
            case 5 -> {
                ptDst2.setLocation(y * this.shearX + this.translateX, x * this.shearY + this.translateY);
                yield ptDst2;
            }
            case 4 -> {
                ptDst2.setLocation(y * this.shearX, x * this.shearY);
                yield ptDst2;
            }
            case 3 -> {
                ptDst2.setLocation(x * this.scaleX + this.translateX, y * this.scaleY + this.translateY);
                yield ptDst2;
            }
            case 2 -> {
                ptDst2.setLocation(x * this.scaleX, y * this.scaleY);
                yield ptDst2;
            }
            case 1 -> {
                ptDst2.setLocation(x + this.translateX, y + this.translateY);
                yield ptDst2;
            }
            case 0 -> {
                ptDst2.setLocation(x, y);
                yield ptDst2;
            }
            default -> {
                this.stateError();
                yield null;
            }
        };
    }

    public final void transform(@NotNull Point2D[] ptSrc, int srcOff, @NotNull Point2D[] ptDst, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)ptSrc, (String)"ptSrc");
        Intrinsics.checkNotNullParameter((Object)ptDst, (String)"ptDst");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        int state = this.state;
        block10: while (--numPts2 >= 0) {
            Point2D dst;
            Point2D src = ptSrc[srcOff2++];
            double x = src.getX();
            double y = src.getY();
            if ((dst = ptDst[dstOff2++]) == null) {
                ptDst[dstOff2 - 1] = dst = src instanceof Point2D.Double ? (Point2D)new Point2D.Double() : (Point2D)new Point2D.Float();
            }
            switch (state) {
                case 7: {
                    dst.setLocation(x * this.scaleX + y * this.shearX + this.translateX, x * this.shearY + y * this.scaleY + this.translateY);
                    continue block10;
                }
                case 6: {
                    dst.setLocation(x * this.scaleX + y * this.shearX, x * this.shearY + y * this.scaleY);
                    continue block10;
                }
                case 5: {
                    dst.setLocation(y * this.shearX + this.translateX, x * this.shearY + this.translateY);
                    continue block10;
                }
                case 4: {
                    dst.setLocation(y * this.shearX, x * this.shearY);
                    continue block10;
                }
                case 3: {
                    dst.setLocation(x * this.scaleX + this.translateX, y * this.scaleY + this.translateY);
                    continue block10;
                }
                case 2: {
                    dst.setLocation(x * this.scaleX, y * this.scaleY);
                    continue block10;
                }
                case 1: {
                    dst.setLocation(x + this.translateX, y + this.translateY);
                    continue block10;
                }
                case 0: {
                    dst.setLocation(x, y);
                    continue block10;
                }
            }
            this.stateError();
            return;
        }
    }

    public final void transform(@NotNull float[] srcPts, int srcOff, @NotNull float[] dstPts, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        Intrinsics.checkNotNullParameter((Object)dstPts, (String)"dstPts");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        if (Intrinsics.areEqual((Object)dstPts, (Object)srcPts) && dstOff2 > srcOff2 && dstOff2 < srcOff2 + numPts2 * 2) {
            ArrayFnKt.arraycopy((float[])srcPts, (int)srcOff2, (float[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
            srcOff2 = dstOff2;
        }
        double M12 = 0.0;
        double M11 = 0.0;
        double M10 = 0.0;
        double M02 = 0.0;
        double M01 = 0.0;
        double M00 = 0.0;
        switch (this.state) {
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M00 * x + M01 * y + M02);
                    dstPts[dstOff2++] = (float)(M10 * x + M11 * y + M12);
                }
                return;
            }
            case 6: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M00 * x + M01 * y);
                    dstPts[dstOff2++] = (float)(M10 * x + M11 * y);
                }
                return;
            }
            case 5: {
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M01 * (double)srcPts[srcOff2++] + M02);
                    dstPts[dstOff2++] = (float)(M10 * x + M12);
                }
                return;
            }
            case 4: {
                M01 = this.shearX;
                M10 = this.shearY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M01 * (double)srcPts[srcOff2++]);
                    dstPts[dstOff2++] = (float)(M10 * x);
                }
                return;
            }
            case 3: {
                M00 = this.scaleX;
                M02 = this.translateX;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)(M00 * (double)srcPts[srcOff2++] + M02);
                    dstPts[dstOff2++] = (float)(M11 * (double)srcPts[srcOff2++] + M12);
                }
                return;
            }
            case 2: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)(M00 * (double)srcPts[srcOff2++]);
                    dstPts[dstOff2++] = (float)(M11 * (double)srcPts[srcOff2++]);
                }
                return;
            }
            case 1: {
                M02 = this.translateX;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)((double)srcPts[srcOff2++] + M02);
                    dstPts[dstOff2++] = (float)((double)srcPts[srcOff2++] + M12);
                }
                return;
            }
            case 0: {
                if (!Intrinsics.areEqual((Object)srcPts, (Object)dstPts) || srcOff2 != dstOff2) {
                    ArrayFnKt.arraycopy((float[])srcPts, (int)srcOff2, (float[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
                }
                return;
            }
        }
        this.stateError();
    }

    public final void transform(@NotNull double[] srcPts, int srcOff, @NotNull double[] dstPts, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        Intrinsics.checkNotNullParameter((Object)dstPts, (String)"dstPts");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        if (Intrinsics.areEqual((Object)dstPts, (Object)srcPts) && dstOff2 > srcOff2 && dstOff2 < srcOff2 + numPts2 * 2) {
            ArrayFnKt.arraycopy((double[])srcPts, (int)srcOff2, (double[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
            srcOff2 = dstOff2;
        }
        double M12 = 0.0;
        double M11 = 0.0;
        double M10 = 0.0;
        double M02 = 0.0;
        double M01 = 0.0;
        double M00 = 0.0;
        switch (this.state) {
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M00 * x + M01 * y + M02;
                    dstPts[dstOff2++] = M10 * x + M11 * y + M12;
                }
                return;
            }
            case 6: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M00 * x + M01 * y;
                    dstPts[dstOff2++] = M10 * x + M11 * y;
                }
                return;
            }
            case 5: {
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M01 * srcPts[srcOff2++] + M02;
                    dstPts[dstOff2++] = M10 * x + M12;
                }
                return;
            }
            case 4: {
                M01 = this.shearX;
                M10 = this.shearY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M01 * srcPts[srcOff2++];
                    dstPts[dstOff2++] = M10 * x;
                }
                return;
            }
            case 3: {
                M00 = this.scaleX;
                M02 = this.translateX;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = M00 * srcPts[srcOff2++] + M02;
                    dstPts[dstOff2++] = M11 * srcPts[srcOff2++] + M12;
                }
                return;
            }
            case 2: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = M00 * srcPts[srcOff2++];
                    dstPts[dstOff2++] = M11 * srcPts[srcOff2++];
                }
                return;
            }
            case 1: {
                M02 = this.translateX;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = srcPts[srcOff2++] + M02;
                    dstPts[dstOff2++] = srcPts[srcOff2++] + M12;
                }
                return;
            }
            case 0: {
                if (!Intrinsics.areEqual((Object)srcPts, (Object)dstPts) || srcOff2 != dstOff2) {
                    ArrayFnKt.arraycopy((double[])srcPts, (int)srcOff2, (double[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
                }
                return;
            }
        }
        this.stateError();
    }

    public final void transform(@NotNull float[] srcPts, int srcOff, @NotNull double[] dstPts, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        Intrinsics.checkNotNullParameter((Object)dstPts, (String)"dstPts");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        double M00 = 0.0;
        double M01 = 0.0;
        double M02 = 0.0;
        double M10 = 0.0;
        double M11 = 0.0;
        double M12 = 0.0;
        switch (this.state) {
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M00 * x + M01 * y + M02;
                    dstPts[dstOff2++] = M10 * x + M11 * y + M12;
                }
                return;
            }
            case 6: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M00 * x + M01 * y;
                    dstPts[dstOff2++] = M10 * x + M11 * y;
                }
                return;
            }
            case 5: {
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M01 * (double)srcPts[srcOff2++] + M02;
                    dstPts[dstOff2++] = M10 * x + M12;
                }
                return;
            }
            case 4: {
                M01 = this.shearX;
                M10 = this.shearY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = M01 * (double)srcPts[srcOff2++];
                    dstPts[dstOff2++] = M10 * x;
                }
                return;
            }
            case 3: {
                M00 = this.scaleX;
                M02 = this.translateX;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = M00 * (double)srcPts[srcOff2++] + M02;
                    dstPts[dstOff2++] = M11 * (double)srcPts[srcOff2++] + M12;
                }
                return;
            }
            case 2: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = M00 * (double)srcPts[srcOff2++];
                    dstPts[dstOff2++] = M11 * (double)srcPts[srcOff2++];
                }
                return;
            }
            case 1: {
                M02 = this.translateX;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (double)srcPts[srcOff2++] + M02;
                    dstPts[dstOff2++] = (double)srcPts[srcOff2++] + M12;
                }
                return;
            }
            case 0: {
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = srcPts[srcOff2++];
                    dstPts[dstOff2++] = srcPts[srcOff2++];
                }
                return;
            }
        }
        this.stateError();
    }

    public final void transform(@NotNull double[] srcPts, int srcOff, @NotNull float[] dstPts, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        Intrinsics.checkNotNullParameter((Object)dstPts, (String)"dstPts");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        double M00 = 0.0;
        double M01 = 0.0;
        double M02 = 0.0;
        double M10 = 0.0;
        double M11 = 0.0;
        double M12 = 0.0;
        switch (this.state) {
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M00 * x + M01 * y + M02);
                    dstPts[dstOff2++] = (float)(M10 * x + M11 * y + M12);
                }
                return;
            }
            case 6: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M00 * x + M01 * y);
                    dstPts[dstOff2++] = (float)(M10 * x + M11 * y);
                }
                return;
            }
            case 5: {
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M01 * srcPts[srcOff2++] + M02);
                    dstPts[dstOff2++] = (float)(M10 * x + M12);
                }
                return;
            }
            case 4: {
                M01 = this.shearX;
                M10 = this.shearY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)(M01 * srcPts[srcOff2++]);
                    dstPts[dstOff2++] = (float)(M10 * x);
                }
                return;
            }
            case 3: {
                M00 = this.scaleX;
                M02 = this.translateX;
                M11 = this.scaleY;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)(M00 * srcPts[srcOff2++] + M02);
                    dstPts[dstOff2++] = (float)(M11 * srcPts[srcOff2++] + M12);
                }
                return;
            }
            case 2: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)(M00 * srcPts[srcOff2++]);
                    dstPts[dstOff2++] = (float)(M11 * srcPts[srcOff2++]);
                }
                return;
            }
            case 1: {
                M02 = this.translateX;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)(srcPts[srcOff2++] + M02);
                    dstPts[dstOff2++] = (float)(srcPts[srcOff2++] + M12);
                }
                return;
            }
            case 0: {
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (float)srcPts[srcOff2++];
                    dstPts[dstOff2++] = (float)srcPts[srcOff2++];
                }
                return;
            }
        }
        this.stateError();
    }

    @NotNull
    public final Point2D inverseTransform(@NotNull Point2D ptSrc, @Nullable Point2D ptDst) {
        Intrinsics.checkNotNullParameter((Object)ptSrc, (String)"ptSrc");
        Point2D ptDst2 = ptDst;
        if (ptDst2 == null) {
            ptDst2 = ptSrc instanceof Point2D.Double ? (Point2D)new Point2D.Double() : (Point2D)new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        return switch (this.state) {
            case 7 -> {
                x -= this.translateX;
                y -= this.translateY;
                double det = this.scaleX * this.scaleY - this.shearX * this.shearY;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                ptDst2.setLocation((x * this.scaleY - y * this.shearX) / det, (y * this.scaleX - x * this.shearY) / det);
                yield ptDst2;
            }
            case 6 -> {
                double det = this.scaleX * this.scaleY - this.shearX * this.shearY;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                ptDst2.setLocation((x * this.scaleY - y * this.shearX) / det, (y * this.scaleX - x * this.shearY) / det);
                yield ptDst2;
            }
            case 5 -> {
                x -= this.translateX;
                y -= this.translateY;
                if (this.shearX == 0.0 || this.shearY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst2.setLocation(y / this.shearY, x / this.shearX);
                yield ptDst2;
            }
            case 4 -> {
                if (this.shearX == 0.0 || this.shearY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst2.setLocation(y / this.shearY, x / this.shearX);
                yield ptDst2;
            }
            case 3 -> {
                x -= this.translateX;
                y -= this.translateY;
                if (this.scaleX == 0.0 || this.scaleY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst2.setLocation(x / this.scaleX, y / this.scaleY);
                yield ptDst2;
            }
            case 2 -> {
                if (this.scaleX == 0.0 || this.scaleY == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst2.setLocation(x / this.scaleX, y / this.scaleY);
                yield ptDst2;
            }
            case 1 -> {
                ptDst2.setLocation(x - this.translateX, y - this.translateY);
                yield ptDst2;
            }
            case 0 -> {
                ptDst2.setLocation(x, y);
                yield ptDst2;
            }
            default -> {
                this.stateError();
                x -= this.translateX;
                y -= this.translateY;
                double det = this.scaleX * this.scaleY - this.shearX * this.shearY;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                ptDst2.setLocation((x * this.scaleY - y * this.shearX) / det, (y * this.scaleX - x * this.shearY) / det);
                yield ptDst2;
            }
        };
    }

    public final void inverseTransform(@NotNull double[] srcPts, int srcOff, @NotNull double[] dstPts, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        Intrinsics.checkNotNullParameter((Object)dstPts, (String)"dstPts");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        if (Intrinsics.areEqual((Object)dstPts, (Object)srcPts) && dstOff2 > srcOff2 && dstOff2 < srcOff2 + numPts2 * 2) {
            ArrayFnKt.arraycopy((double[])srcPts, (int)srcOff2, (double[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
            srcOff2 = dstOff2;
        }
        double det = 0.0;
        double M12 = 0.0;
        double M11 = 0.0;
        double M10 = 0.0;
        double M02 = 0.0;
        double M01 = 0.0;
        double M00 = 0.0;
        switch (this.state) {
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M11 = this.scaleY;
                M12 = this.translateY;
                det = M00 * M11 - M01 * M10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++] - M02;
                    double y = srcPts[srcOff2++] - M12;
                    dstPts[dstOff2++] = (x * M11 - y * M01) / det;
                    dstPts[dstOff2++] = (y * M00 - x * M10) / det;
                }
                return;
            }
            case 6: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                det = M00 * M11 - M01 * M10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = (x * M11 - y * M01) / det;
                    dstPts[dstOff2++] = (y * M00 - x * M10) / det;
                }
                return;
            }
            case 5: {
                M01 = this.shearX;
                M02 = this.translateX;
                M10 = this.shearY;
                M12 = this.translateY;
                if (M01 == 0.0 || M10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++] - M02;
                    dstPts[dstOff2++] = (srcPts[srcOff2++] - M12) / M10;
                    dstPts[dstOff2++] = x / M01;
                }
                return;
            }
            case 4: {
                M01 = this.shearX;
                M10 = this.shearY;
                if (M01 == 0.0 || M10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = srcPts[srcOff2++] / M10;
                    dstPts[dstOff2++] = x / M01;
                }
                return;
            }
            case 3: {
                M00 = this.scaleX;
                M02 = this.translateX;
                M11 = this.scaleY;
                M12 = this.translateY;
                if (M00 == 0.0 || M11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = (srcPts[srcOff2++] - M02) / M00;
                    dstPts[dstOff2++] = (srcPts[srcOff2++] - M12) / M11;
                }
                return;
            }
            case 2: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                if (M00 == 0.0 || M11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = srcPts[srcOff2++] / M00;
                    dstPts[dstOff2++] = srcPts[srcOff2++] / M11;
                }
                return;
            }
            case 1: {
                M02 = this.translateX;
                M12 = this.translateY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = srcPts[srcOff2++] - M02;
                    dstPts[dstOff2++] = srcPts[srcOff2++] - M12;
                }
                return;
            }
            case 0: {
                if (!Intrinsics.areEqual((Object)srcPts, (Object)dstPts) || srcOff2 != dstOff2) {
                    ArrayFnKt.arraycopy((double[])srcPts, (int)srcOff2, (double[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
                }
                return;
            }
        }
        this.stateError();
    }

    @Nullable
    public final Point2D deltaTransform(@NotNull Point2D ptSrc, @Nullable Point2D ptDst) {
        Intrinsics.checkNotNullParameter((Object)ptSrc, (String)"ptSrc");
        Point2D ptDst2 = ptDst;
        if (ptDst2 == null) {
            ptDst2 = ptSrc instanceof Point2D.Double ? (Point2D)new Point2D.Double() : (Point2D)new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        return switch (this.state) {
            case 6, 7 -> {
                ptDst2.setLocation(x * this.scaleX + y * this.shearX, x * this.shearY + y * this.scaleY);
                yield ptDst2;
            }
            case 4, 5 -> {
                ptDst2.setLocation(y * this.shearX, x * this.shearY);
                yield ptDst2;
            }
            case 2, 3 -> {
                ptDst2.setLocation(x * this.scaleX, y * this.scaleY);
                yield ptDst2;
            }
            case 0, 1 -> {
                ptDst2.setLocation(x, y);
                yield ptDst2;
            }
            default -> {
                this.stateError();
                yield null;
            }
        };
    }

    public final void deltaTransform(@NotNull double[] srcPts, int srcOff, @NotNull double[] dstPts, int dstOff, int numPts) {
        Intrinsics.checkNotNullParameter((Object)srcPts, (String)"srcPts");
        Intrinsics.checkNotNullParameter((Object)dstPts, (String)"dstPts");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        int numPts2 = numPts;
        if (Intrinsics.areEqual((Object)dstPts, (Object)srcPts) && dstOff2 > srcOff2 && dstOff2 < srcOff2 + numPts2 * 2) {
            ArrayFnKt.arraycopy((double[])srcPts, (int)srcOff2, (double[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
            srcOff2 = dstOff2;
        }
        double M11 = 0.0;
        double M10 = 0.0;
        double M01 = 0.0;
        double M00 = 0.0;
        switch (this.state) {
            case 6: 
            case 7: {
                M00 = this.scaleX;
                M01 = this.shearX;
                M10 = this.shearY;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    double y = srcPts[srcOff2++];
                    dstPts[dstOff2++] = x * M00 + y * M01;
                    dstPts[dstOff2++] = x * M10 + y * M11;
                }
                return;
            }
            case 4: 
            case 5: {
                M01 = this.shearX;
                M10 = this.shearY;
                while (--numPts2 >= 0) {
                    double x = srcPts[srcOff2++];
                    dstPts[dstOff2++] = srcPts[srcOff2++] * M01;
                    dstPts[dstOff2++] = x * M10;
                }
                return;
            }
            case 2: 
            case 3: {
                M00 = this.scaleX;
                M11 = this.scaleY;
                while (--numPts2 >= 0) {
                    dstPts[dstOff2++] = srcPts[srcOff2++] * M00;
                    dstPts[dstOff2++] = srcPts[srcOff2++] * M11;
                }
                return;
            }
            case 0: 
            case 1: {
                if (!Intrinsics.areEqual((Object)srcPts, (Object)dstPts) || srcOff2 != dstOff2) {
                    ArrayFnKt.arraycopy((double[])srcPts, (int)srcOff2, (double[])dstPts, (int)dstOff2, (int)(numPts2 * 2));
                }
                return;
            }
        }
        this.stateError();
    }

    @Nullable
    public final Shape createTransformedShape(@Nullable Shape pSrc) {
        return pSrc == null ? null : (Shape)new Path2D.Double(pSrc, this);
    }

    public final boolean isIdentity() {
        return this.state == 0 || this.getType() == 0;
    }

    public final int getType() {
        if (this.type == -1) {
            this.calculateType();
        }
        return this.type;
    }

    private final void calculateType() {
        this.updateState();
        double M3 = 0.0;
        double M2 = 0.0;
        double M1 = 0.0;
        double M0 = 0.0;
        boolean sgn1 = false;
        boolean sgn0 = false;
        int ret = 0;
        switch (this.state) {
            case 7: {
                double d;
                ret = 1;
                double it = d = this.scaleX;
                boolean bl = false;
                M0 = it;
                double d2 = d;
                it = d = this.shearX;
                double d3 = d2;
                boolean bl2 = false;
                M2 = it;
                Unit unit = Unit.INSTANCE;
                double d4 = d3 * d;
                it = d = this.shearY;
                d3 = d4;
                boolean bl3 = false;
                M3 = it;
                unit = Unit.INSTANCE;
                double d5 = d;
                it = d = this.scaleY;
                double d6 = d5;
                boolean bl4 = false;
                M1 = it;
                Unit unit2 = Unit.INSTANCE;
                if (!(d3 + d6 * d == 0.0)) {
                    this.type = 32;
                    return;
                }
                sgn0 = M0 >= 0.0;
                boolean bl5 = sgn1 = M1 >= 0.0;
                ret = sgn0 == sgn1 ? (!(M0 == M1) || !(M2 == -M3) ? ret | 0x14 : (!(M0 * M1 - M2 * M3 == 1.0) ? ret | 0x12 : ret | 0x10)) : (!(M0 == -M1) || !(M2 == M3) ? ret | 0x54 : (!(M0 * M1 - M2 * M3 == 1.0) ? ret | 0x52 : ret | 0x50));
                break;
            }
            case 6: {
                double d;
                double it = d = this.scaleX;
                boolean bl = false;
                M0 = it;
                double d7 = d;
                it = d = this.shearX;
                double d8 = d7;
                boolean bl6 = false;
                M2 = it;
                Unit unit = Unit.INSTANCE;
                double d9 = d8 * d;
                it = d = this.shearY;
                d8 = d9;
                boolean bl7 = false;
                M3 = it;
                unit = Unit.INSTANCE;
                double d10 = d;
                it = d = this.scaleY;
                double d11 = d10;
                boolean bl8 = false;
                M1 = it;
                Unit unit3 = Unit.INSTANCE;
                if (!(d8 + d11 * d == 0.0)) {
                    this.type = 32;
                    return;
                }
                sgn0 = M0 >= 0.0;
                boolean bl9 = sgn1 = M1 >= 0.0;
                ret = sgn0 == sgn1 ? (!(M0 == M1) || !(M2 == -M3) ? ret | 0x14 : (!(M0 * M1 - M2 * M3 == 1.0) ? ret | 0x12 : ret | 0x10)) : (!(M0 == -M1) || !(M2 == M3) ? ret | 0x54 : (!(M0 * M1 - M2 * M3 == 1.0) ? ret | 0x52 : ret | 0x50));
                break;
            }
            case 5: {
                double d;
                ret = 1;
                double it = d = this.shearX;
                boolean bl = false;
                M0 = it;
                sgn0 = d >= 0.0;
                it = d = this.shearY;
                boolean bl10 = false;
                M1 = it;
                boolean bl11 = sgn1 = d >= 0.0;
                ret = sgn0 != sgn1 ? (!(M0 == -M1) ? ret | 0xC : (!(M0 == 1.0) && !(M0 == -1.0) ? ret | 0xA : ret | 8)) : (M0 == M1 ? ret | 0x4A : ret | 0x4C);
                break;
            }
            case 4: {
                double d;
                double it = d = this.shearX;
                boolean bl = false;
                M0 = it;
                sgn0 = d >= 0.0;
                it = d = this.shearY;
                boolean bl12 = false;
                M1 = it;
                boolean bl13 = sgn1 = d >= 0.0;
                ret = sgn0 != sgn1 ? (!(M0 == -M1) ? ret | 0xC : (!(M0 == 1.0) && !(M0 == -1.0) ? ret | 0xA : ret | 8)) : (M0 == M1 ? ret | 0x4A : ret | 0x4C);
                break;
            }
            case 3: {
                double d;
                ret = 1;
                double it = d = this.scaleX;
                boolean bl = false;
                M0 = it;
                sgn0 = d >= 0.0;
                it = d = this.scaleY;
                boolean bl14 = false;
                M1 = it;
                boolean bl15 = sgn1 = d >= 0.0;
                ret = sgn0 == sgn1 ? (sgn0 ? (M0 == M1 ? ret | 2 : ret | 4) : (!(M0 == M1) ? ret | 0xC : (!(M0 == -1.0) ? ret | 0xA : ret | 8))) : (M0 == -M1 ? (M0 == 1.0 || M0 == -1.0 ? ret | 0x40 : ret | 0x42) : ret | 0x44);
                break;
            }
            case 2: {
                double d;
                double it = d = this.scaleX;
                boolean bl = false;
                M0 = it;
                sgn0 = d >= 0.0;
                it = d = this.scaleY;
                boolean bl16 = false;
                M1 = it;
                boolean bl17 = sgn1 = d >= 0.0;
                ret = sgn0 == sgn1 ? (sgn0 ? (M0 == M1 ? ret | 2 : ret | 4) : (!(M0 == M1) ? ret | 0xC : (!(M0 == -1.0) ? ret | 0xA : ret | 8))) : (M0 == -M1 ? (M0 == 1.0 || M0 == -1.0 ? ret | 0x40 : ret | 0x42) : ret | 0x44);
                break;
            }
            case 1: {
                ret = 1;
                break;
            }
            case 0: {
                break;
            }
            default: {
                double d;
                this.stateError();
                ret = 1;
                double it = d = this.scaleX;
                boolean bl = false;
                M0 = it;
                double d12 = d;
                it = d = this.shearX;
                double d13 = d12;
                boolean bl18 = false;
                M2 = it;
                Unit unit = Unit.INSTANCE;
                double d14 = d13 * d;
                it = d = this.shearY;
                d13 = d14;
                boolean bl19 = false;
                M3 = it;
                unit = Unit.INSTANCE;
                double d15 = d;
                it = d = this.scaleY;
                double d16 = d15;
                boolean bl20 = false;
                M1 = it;
                Unit unit4 = Unit.INSTANCE;
                if (!(d13 + d16 * d == 0.0)) {
                    this.type = 32;
                    return;
                }
                sgn0 = M0 >= 0.0;
                boolean bl21 = sgn1 = M1 >= 0.0;
                ret = sgn0 == sgn1 ? (!(M0 == M1) || !(M2 == -M3) ? ret | 0x14 : (!(M0 * M1 - M2 * M3 == 1.0) ? ret | 0x12 : ret | 0x10)) : (!(M0 == -M1) || !(M2 == M3) ? ret | 0x54 : (!(M0 * M1 - M2 * M3 == 1.0) ? ret | 0x52 : ret | 0x50));
            }
        }
        this.type = ret;
    }

    public int hashCode() {
        long bits = Double.doubleToRawLongBits(this.scaleX);
        bits = bits * (long)31 + Double.doubleToRawLongBits(this.shearX);
        bits = bits * (long)31 + Double.doubleToRawLongBits(this.translateX);
        bits = bits * (long)31 + Double.doubleToRawLongBits(this.shearY);
        bits = bits * (long)31 + Double.doubleToRawLongBits(this.scaleY);
        bits = bits * (long)31 + Double.doubleToRawLongBits(this.translateY);
        return (int)bits ^ (int)(bits >> 32);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        return this.scaleX == ((AffineTransform)obj).scaleX && this.shearX == ((AffineTransform)obj).shearX && this.translateX == ((AffineTransform)obj).translateX && this.shearY == ((AffineTransform)obj).shearY && this.scaleY == ((AffineTransform)obj).scaleY && this.translateY == ((AffineTransform)obj).translateY;
    }

    @NotNull
    public String toString() {
        return "AffineTransform[[" + AffineTransform.Companion._matround(this.scaleX) + ", " + AffineTransform.Companion._matround(this.shearX) + ", " + AffineTransform.Companion._matround(this.translateX) + "], [" + AffineTransform.Companion._matround(this.shearY) + ", " + AffineTransform.Companion._matround(this.scaleY) + ", " + AffineTransform.Companion._matround(this.translateY) + "]]";
    }

    static {
        int[] nArray = new int[]{4, 5, 4, 5, 2, 3, 6, 7};
        rot90conversion = nArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001eJ\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eJ\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eJ&\u0010 \u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eJ\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0005J\u001e\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eJ\u0016\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001eJ\u0016\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u001eJ\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/mkui/geom/AffineTransform$Companion;", "", "<init>", "()V", "TYPE_IDENTITY", "", "TYPE_TRANSLATION", "TYPE_UNIFORM_SCALE", "TYPE_GENERAL_SCALE", "TYPE_MASK_SCALE", "TYPE_FLIP", "TYPE_QUADRANT_ROTATION", "TYPE_GENERAL_ROTATION", "TYPE_MASK_ROTATION", "TYPE_GENERAL_TRANSFORM", "APPLY_IDENTITY", "APPLY_TRANSLATE", "APPLY_SCALE", "APPLY_SHEAR", "TYPE_UNKNOWN", "HI_SHIFT", "HI_IDENTITY", "HI_TRANSLATE", "HI_SCALE", "HI_SHEAR", "rot90conversion", "", "getTranslateInstance", "Lorg/mkui/geom/AffineTransform;", "tx", "", "ty", "getRotateInstance", "theta", "anchorx", "anchory", "vecx", "vecy", "getQuadrantRotateInstance", "numquadrants", "getScaleInstance", "sx", "sy", "getShearInstance", "shx", "shy", "_matround", "matval", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AffineTransform getTranslateInstance(double tx, double ty) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToTranslation(tx, ty);
            return Tx;
        }

        @NotNull
        public final AffineTransform getRotateInstance(double theta) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToRotation(theta);
            return Tx;
        }

        @NotNull
        public final AffineTransform getRotateInstance(double theta, double anchorx, double anchory) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToRotation(theta, anchorx, anchory);
            return Tx;
        }

        @NotNull
        public final AffineTransform getRotateInstance(double vecx, double vecy) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToRotation(vecx, vecy);
            return Tx;
        }

        @NotNull
        public final AffineTransform getRotateInstance(double vecx, double vecy, double anchorx, double anchory) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToRotation(vecx, vecy, anchorx, anchory);
            return Tx;
        }

        @NotNull
        public final AffineTransform getQuadrantRotateInstance(int numquadrants) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToQuadrantRotation(numquadrants);
            return Tx;
        }

        @NotNull
        public final AffineTransform getQuadrantRotateInstance(int numquadrants, double anchorx, double anchory) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToQuadrantRotation(numquadrants, anchorx, anchory);
            return Tx;
        }

        @NotNull
        public final AffineTransform getScaleInstance(double sx, double sy) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToScale(sx, sy);
            return Tx;
        }

        @NotNull
        public final AffineTransform getShearInstance(double shx, double shy) {
            AffineTransform Tx = new AffineTransform();
            Tx.setToShear(shx, shy);
            return Tx;
        }

        private final double _matround(double matval) {
            return Math.rint(matval * 1.0E15) / 1.0E15;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

