/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.palette.AbstractPalette;
import org.mkui.palette.Cycle;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteListener;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nB\u0015\b\u0016\u0012\n\u0010\u0005\u001a\u00020\u000b\"\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB\u001d\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00020\u000b\"\u00020\f\u00a2\u0006\u0004\b\t\u0010\u000fB%\b\u0016\u0012\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0007j\u0002`\b0\u0010\"\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\u0011B-\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0007j\u0002`\b0\u0010\"\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\u0012B\u001b\b\u0016\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u00a2\u0006\u0004\b\t\u0010\u0013J\u0019\u0010\u001a\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010#\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\n\u00101\u001a\u000202H\u0096\u0080\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R(\u0010,\u001a\u0004\u0018\u00010+2\b\u0010*\u001a\u0004\u0018\u00010+8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u00064"}, d2={"Lorg/mkui/palette/FixedPalette;", "Lorg/mkui/palette/AbstractPalette;", "Lorg/mkui/palette/MutablePalette;", "isInverted", "", "colors", "", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "<init>", "(ZLjava/util/List;)V", "", "", "([I)V", "inverted", "(Z[I)V", "", "([Ljava/awt/Color;)V", "(Z[Ljava/awt/Color;)V", "(Ljava/util/List;)V", "()Z", "setInverted", "(Z)V", "getColors", "()Ljava/util/List;", "setColors", "getColor", "fraction", "", "(D)Ljava/awt/Color;", "lowestFraction", "getLowestFraction", "()D", "highestFraction", "getHighestFraction", "getColorAt", "(I)Ljava/awt/Color;", "addPaletteListener", "", "listener", "Lorg/mkui/palette/PaletteListener;", "removePaletteListener", "value", "Lorg/mkui/palette/Cycle;", "cycle", "getCycle", "()Lorg/mkui/palette/Cycle;", "setCycle", "(Lorg/mkui/palette/Cycle;)V", "toString", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public class FixedPalette
extends AbstractPalette
implements MutablePalette {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isInverted;
    @NotNull
    private List<? extends Color> colors;
    public static final int $stable = 8;

    public FixedPalette(boolean isInverted, @NotNull List<? extends Color> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.isInverted = isInverted;
        this.colors = colors;
        this.setColorCount(this.colors != null ? this.colors.size() : 0);
    }

    @Override
    public boolean isInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    @NotNull
    public final List<Color> getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull List<? extends Color> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    public FixedPalette(int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, Arrays.copyOf(colors, colors.length));
    }

    public FixedPalette(boolean inverted, int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, FixedPalette.Companion.toCPColorList(colors));
    }

    public FixedPalette(Color ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, ArraysKt.toMutableList((Object[])colors));
    }

    public FixedPalette(boolean inverted, Color ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(inverted, ArraysKt.toMutableList((Object[])colors));
    }

    public FixedPalette(@NotNull List<? extends Color> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this(false, colors);
    }

    @Override
    @NotNull
    public Color getColor(double fraction) {
        Color color;
        double fraction2 = fraction;
        boolean inverted = this.isInverted();
        Cycle cycle = this.getCycle();
        switch (cycle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()]) {
            case 1: {
                inverted = (int)fraction2 % 2 == 0;
                fraction2 -= (double)((int)fraction2);
                break;
            }
            case 2: {
                fraction2 -= (double)((int)fraction2);
                break;
            }
            default: {
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            color = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            color = this.getColor(this.getHighestFraction());
        } else {
            int index = this.getEntry(!inverted ? fraction2 : 1.0 - fraction2, this.getColorCount(), this.colors.size());
            color = this.colors.get(index);
        }
        return color;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public Color getColorAt(int fraction) {
        return this.getColorCount() == this.colors.size() ? (fraction < 0 ? this.getColorAt(0) : (fraction > this.getColorCount() - 1 ? this.getColorAt(this.getColorCount() - 1) : this.colors.get(fraction))) : this.getColor((double)this.getColorCount() / (double)fraction);
    }

    @Override
    public void addPaletteListener(@NotNull PaletteListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Override
    public void removePaletteListener(@NotNull PaletteListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Override
    @Nullable
    public Cycle getCycle() {
        return super.getCycle();
    }

    @Override
    public void setCycle(@Nullable Cycle value) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String toString() {
        return this.getColor(0.0) + "-" + this.getColor(1.0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/mkui/palette/FixedPalette$Companion;", "", "<init>", "()V", "toCPColorList", "", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "colors", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Color> toCPColorList(int[] colors) {
            List list = new ArrayList(colors.length);
            for (int color : colors) {
                list.add(MkColorKt.colorOf(color));
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Cycle.values().length];
            try {
                nArray[Cycle.REFLECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Cycle.REPEAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

