/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.swing;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSingleSelection;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.swing.Orientation;
import org.mkui.swing.SingleSelectionComboBoxModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0017J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001cH\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f0\u0015R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/mkui/swing/HierarchicalComboBox;", "E", "Ljavax/swing/JPanel;", "orientation", "Lorg/mkui/swing/Orientation;", "selection", "Lcom/macrofocus/common/selection/MutableSelection;", "values", "", "<init>", "(Lorg/mkui/swing/Orientation;Lcom/macrofocus/common/selection/MutableSelection;Ljava/lang/Iterable;)V", "getOrientation", "()Lorg/mkui/swing/Orientation;", "getSelection", "()Lcom/macrofocus/common/selection/MutableSelection;", "getValues", "()Ljava/lang/Iterable;", "comboBoxes", "", "Ljavax/swing/JComboBox;", "itemListener", "Lorg/mkui/swing/HierarchicalComboBox$GroupByItemListener;", "createComboBoxes", "", "createComboBox", "element", "(Ljava/lang/Object;)Ljavax/swing/JComboBox;", "comboBoxModel", "Ljavax/swing/ComboBoxModel;", "GroupByItemListener", "mkui"})
@StabilityInferred(parameters=0)
public class HierarchicalComboBox<E>
extends JPanel {
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final MutableSelection<E> selection;
    @NotNull
    private final Iterable<E> values;
    @NotNull
    private final List<JComboBox<E>> comboBoxes;
    @NotNull
    private final GroupByItemListener itemListener;
    public static final int $stable = 8;

    public HierarchicalComboBox(@NotNull Orientation orientation, @NotNull MutableSelection<E> selection, @NotNull Iterable<? extends E> values) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.orientation = orientation;
        this.selection = selection;
        this.values = values;
        this.comboBoxes = new ArrayList();
        this.itemListener = new GroupByItemListener();
        this.setLayout(new BoxLayout(this, this.orientation == Orientation.Vertical ? 3 : 2));
        this.selection.addSelectionListener(new SelectionListener<E>(){

            public void selectionChanged(SelectionEvent<E> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.createComboBoxes();
            }
        });
        this.createComboBoxes();
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final MutableSelection<E> getSelection() {
        return this.selection;
    }

    @NotNull
    public final Iterable<E> getValues() {
        return this.values;
    }

    public final void createComboBoxes() {
        for (JComboBox<E> jComboBox : this.comboBoxes) {
            jComboBox.removeItemListener(this.itemListener);
        }
        this.removeAll();
        this.comboBoxes.clear();
        MutableSelection<E> groupByTreeMapFields = this.selection;
        for (Object e : groupByTreeMapFields) {
            JComboBox comboBox = this.createComboBox(e);
            this.comboBoxes.add(comboBox);
        }
        JComboBox<Object> jComboBox = this.createComboBox((E)null);
        this.comboBoxes.add(jComboBox);
        for (JComboBox comboBox : this.comboBoxes) {
            this.add(comboBox);
            comboBox.addItemListener(this.itemListener);
        }
        this.invalidate();
        if (this.getParent() != null) {
            if (this.getParent().getParent() != null) {
                if (this.getParent().getParent().getParent() != null) {
                    this.getParent().getParent().getParent().validate();
                }
            } else {
                this.validate();
            }
        } else {
            this.validate();
        }
    }

    @NotNull
    protected final JComboBox<E> createComboBox(@Nullable E element) {
        MutableSingleSelection selection = element != null ? (MutableSingleSelection)new SimpleSingleSelection(element) : (MutableSingleSelection)new SimpleSingleSelection();
        ComboBoxModel comboBoxModel = new SingleSelectionComboBoxModel<E>(selection, this.values);
        return this.createComboBox(comboBoxModel);
    }

    @NotNull
    protected final JComboBox<E> createComboBox(@NotNull ComboBoxModel<E> comboBoxModel) {
        Intrinsics.checkNotNullParameter(comboBoxModel, (String)"comboBoxModel");
        return new JComboBox<E>(comboBoxModel);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/mkui/swing/HierarchicalComboBox$GroupByItemListener;", "Ljava/awt/event/ItemListener;", "<init>", "(Lorg/mkui/swing/HierarchicalComboBox;)V", "itemStateChanged", "", "e", "Ljava/awt/event/ItemEvent;", "mkui"})
    private final class GroupByItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(@NotNull ItemEvent e) {
            JComboBox comboBox;
            Object item;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ArrayList<Object> groupBy = new ArrayList<Object>();
            Set selected = new HashSet();
            Iterator iterator = HierarchicalComboBox.this.comboBoxes.iterator();
            while (iterator.hasNext() && (item = (comboBox = (JComboBox)iterator.next()).getSelectedItem()) != null && !selected.contains(item)) {
                selected.add(item);
                groupBy.add(item);
                if (e.getSource() != comboBox) continue;
            }
            HierarchicalComboBox.this.getSelection().setSelectedIterable((Iterable)groupBy);
        }
    }
}

