/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00020\b\"\u00020\u0006J\"\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005\"\u0004\b\u0000\u0010\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0005J0\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00052\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\n0\u000eJ7\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0005\"\u0004\b\u0000\u0010\u00102\u001e\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00050\u0012\"\b\u0012\u0004\u0012\u0002H\u00100\u0005\u00a2\u0006\u0002\u0010\u0013J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0005\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00050\u0014\u00a8\u0006\u001d"}, d2={"Lcom/macrofocus/common/collection/Iterables;", "", "<init>", "()V", "forIntArray", "", "", "array", "", "nonNull", "T", "original", "conditional", "condition", "Lcom/macrofocus/common/collection/Iterables$Condition;", "concatenate", "E", "iterables", "", "([Ljava/lang/Iterable;)Ljava/lang/Iterable;", "", "Condition", "Converter", "ToStringConverter", "ConditionalIterable", "IntegerIterable", "ConcatenateIterable", "EqualCondition", "NonNullCondition", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nIterables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Iterables.kt\ncom/macrofocus/common/collection/Iterables\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n777#2:286\n873#2,2:287\n*S KotlinDebug\n*F\n+ 1 Iterables.kt\ncom/macrofocus/common/collection/Iterables\n*L\n36#1:286\n36#1:287,2\n*E\n"})
public final class Iterables {
    @NotNull
    public static final Iterables INSTANCE = new Iterables();

    private Iterables() {
    }

    @NotNull
    public final Iterable<Integer> forIntArray(int ... array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return new IntegerIterable(Arrays.copyOf(array, array.length));
    }

    @NotNull
    public final <T> Iterable<T> nonNull(@NotNull Iterable<? extends T> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Iterable<? extends T> iterable = this.conditional(original, new NonNullCondition());
        Intrinsics.checkNotNull(iterable, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<T of com.macrofocus.common.collection.Iterables.nonNull>");
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Iterable<T> conditional(@NotNull Iterable<? extends T> original, @NotNull Condition<? super T> condition) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterable<? extends T> $this$filter$iv = original;
        boolean $i$f$filter = false;
        Iterable<? extends T> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!condition.apply(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final <E> Iterable<E> concatenate(Iterable<? extends E> ... iterables) {
        Intrinsics.checkNotNullParameter(iterables, (String)"iterables");
        return this.concatenate(ArraysKt.toList((Object[])iterables));
    }

    @NotNull
    public final <E> Iterable<E> concatenate(@NotNull List<? extends Iterable<? extends E>> iterables) {
        Intrinsics.checkNotNullParameter(iterables, (String)"iterables");
        return new ConcatenateIterable(iterables);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\f\rB\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0096\u0082\u0004R\u001f\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0003\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/macrofocus/common/collection/Iterables$ConcatenateIterable;", "E", "", "iterables", "", "<init>", "(Ljava/util/List;)V", "iterablesIterator", "", "getIterablesIterator", "()Ljava/util/Iterator;", "iterator", "ConcatenateIterator", "EmptyIterator", "macrofocus-common"})
    private static final class ConcatenateIterable<E>
    implements Iterable<E>,
    KMappedMarker {
        @Nullable
        private final Iterator<Iterable<E>> iterablesIterator;
        @Nullable
        private final Iterable<Iterable<E>> iterables;

        public ConcatenateIterable(@NotNull List<? extends Iterable<? extends E>> iterables) {
            Intrinsics.checkNotNullParameter(iterables, (String)"iterables");
            this.iterables = iterables;
            this.iterablesIterator = iterables.iterator();
        }

        @Nullable
        public final Iterator<Iterable<E>> getIterablesIterator() {
            return this.iterablesIterator;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            Iterator<Iterable<E>> iterator2 = this.iterablesIterator;
            Intrinsics.checkNotNull(iterator2);
            return !iterator2.hasNext() ? (Iterator)new EmptyIterator() : new ConcatenateIterator().findNext();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\t\u001a\u00020\nH\u0096\u0082\u0004J\u000f\u0010\u000b\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/common/collection/Iterables$ConcatenateIterable$ConcatenateIterator;", "", "<init>", "(Lcom/macrofocus/common/collection/Iterables$ConcatenateIterable;)V", "iterableIterator", "getIterableIterator", "()Ljava/util/Iterator;", "setIterableIterator", "(Ljava/util/Iterator;)V", "hasNext", "", "next", "()Ljava/lang/Object;", "nextIterator", "findNext", "macrofocus-common"})
        private final class ConcatenateIterator
        implements Iterator<E>,
        KMappedMarker {
            @NotNull
            private Iterator<? extends E> iterableIterator = this.nextIterator();

            @NotNull
            public final Iterator<E> getIterableIterator() {
                return this.iterableIterator;
            }

            public final void setIterableIterator(@NotNull Iterator<? extends E> iterator2) {
                Intrinsics.checkNotNullParameter(iterator2, (String)"<set-?>");
                this.iterableIterator = iterator2;
            }

            @Override
            public boolean hasNext() {
                return this.iterableIterator.hasNext();
            }

            @Override
            public E next() {
                Object e = this.iterableIterator.next();
                Intrinsics.checkNotNull(e);
                Object next = e;
                this.findNext();
                return next;
            }

            @NotNull
            public final Iterator<E> nextIterator() {
                Iterator iterator2 = ConcatenateIterable.this.getIterablesIterator();
                Intrinsics.checkNotNull(iterator2);
                return iterator2.next().iterator();
            }

            @NotNull
            public final Iterator<E> findNext() {
                while (!this.iterableIterator.hasNext()) {
                    Iterator iterator2 = ConcatenateIterable.this.getIterablesIterator();
                    Intrinsics.checkNotNull(iterator2);
                    if (!iterator2.hasNext()) break;
                    this.iterableIterator = this.nextIterator();
                }
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0005\u001a\u00020\u0006H\u0096\u0082\u0004J\u000f\u0010\u0007\u001a\u00028\u0001H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/macrofocus/common/collection/Iterables$ConcatenateIterable$EmptyIterator;", "E", "", "<init>", "()V", "hasNext", "", "next", "()Ljava/lang/Object;", "macrofocus-common"})
        private static final class EmptyIterator<E>
        implements Iterator<E>,
        KMappedMarker {
            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new IllegalStateException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/macrofocus/common/collection/Iterables$Condition;", "T", "", "apply", "", "var1", "(Ljava/lang/Object;)Z", "macrofocus-common"})
    public static interface Condition<T> {
        public boolean apply(T var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\tH\u0096\u0082\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/collection/Iterables$ConditionalIterable;", "T", "", "original", "condition", "Lcom/macrofocus/common/collection/Iterables$Condition;", "<init>", "(Ljava/lang/Iterable;Lcom/macrofocus/common/collection/Iterables$Condition;)V", "iterator", "", "macrofocus-common"})
    private static final class ConditionalIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        @NotNull
        private final Iterable<T> original;
        @NotNull
        private final Condition<? super T> condition;

        public ConditionalIterable(@NotNull Iterable<? extends T> original, @NotNull Condition<? super T> condition) {
            Intrinsics.checkNotNullParameter(original, (String)"original");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            this.original = original;
            this.condition = condition;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(this){
                private Iterator<? extends T> it;
                private T nextEntry;
                private boolean queryNext;
                final /* synthetic */ ConditionalIterable<T> this$0;
                {
                    this.this$0 = $receiver;
                    this.it = ConditionalIterable.access$getOriginal$p($receiver).iterator();
                    this.queryNext = true;
                }

                public final Iterator<T> getIt() {
                    return this.it;
                }

                public final void setIt(Iterator<? extends T> iterator2) {
                    this.it = iterator2;
                }

                public final T getNextEntry() {
                    return this.nextEntry;
                }

                public final void setNextEntry(T t) {
                    this.nextEntry = t;
                }

                public final boolean getQueryNext() {
                    return this.queryNext;
                }

                public final void setQueryNext(boolean bl) {
                    this.queryNext = bl;
                }

                public boolean hasNext() {
                    if (this.queryNext) {
                        this.nextEntry = this.findNext();
                        this.queryNext = false;
                    }
                    return this.nextEntry != null;
                }

                public T next() {
                    if (this.queryNext) {
                        this.nextEntry = this.findNext();
                    }
                    this.queryNext = true;
                    T t = this.nextEntry;
                    Intrinsics.checkNotNull(t);
                    return t;
                }

                private final T findNext() {
                    block1: {
                        T t;
                        do {
                            Iterator<T> iterator2 = this.it;
                            Intrinsics.checkNotNull(iterator2);
                            if (!iterator2.hasNext()) break block1;
                            Iterator<T> iterator3 = this.it;
                            Intrinsics.checkNotNull(iterator3);
                            Intrinsics.checkNotNull(iterator3.next());
                        } while (!ConditionalIterable.access$getCondition$p(this.this$0).apply(t));
                        return t;
                    }
                    return null;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public static final /* synthetic */ Iterable access$getOriginal$p(ConditionalIterable $this) {
            return $this.original;
        }

        public static final /* synthetic */ Condition access$getCondition$p(ConditionalIterable $this) {
            return $this.condition;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003J\u0019\u0010\u0004\u001a\u0004\u0018\u00018\u00012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/macrofocus/common/collection/Iterables$Converter;", "T", "C", "", "convert", "var1", "(Ljava/lang/Object;)Ljava/lang/Object;", "macrofocus-common"})
    public static interface Converter<T, C> {
        @Nullable
        public C convert(@Nullable T var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\nR\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/macrofocus/common/collection/Iterables$EqualCondition;", "T", "Lcom/macrofocus/common/collection/Iterables$Condition;", "value", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "apply", "", "var1", "(Ljava/lang/Object;)Z", "macrofocus-common"})
    private static final class EqualCondition<T>
    implements Condition<T> {
        @Nullable
        private final T value;

        public EqualCondition(@Nullable T value) {
            this.value = value;
        }

        @Override
        public boolean apply(@Nullable T var1) {
            return var1 == null ? var1 != this.value : !Intrinsics.areEqual(var1, this.value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u00020\u0004\"\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0096\u0082\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/macrofocus/common/collection/Iterables$IntegerIterable;", "", "", "array", "", "<init>", "([I)V", "iterator", "", "macrofocus-common"})
    private static final class IntegerIterable
    implements Iterable<Integer>,
    KMappedMarker {
        @Nullable
        private final int[] array;

        public IntegerIterable(int ... array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.array = array;
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(this){
                private int pos;
                final /* synthetic */ IntegerIterable this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean hasNext() {
                    return IntegerIterable.access$getArray$p(this.this$0) != null && IntegerIterable.access$getArray$p(this.this$0).length > this.pos;
                }

                public Integer next() {
                    int[] nArray = IntegerIterable.access$getArray$p(this.this$0);
                    Intrinsics.checkNotNull((Object)nArray);
                    int n = this.pos;
                    this.pos = n + 1;
                    return nArray[n];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public static final /* synthetic */ int[] access$getArray$p(IntegerIterable $this) {
            return $this.array;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/macrofocus/common/collection/Iterables$NonNullCondition;", "T", "Lcom/macrofocus/common/collection/Iterables$Condition;", "<init>", "()V", "apply", "", "var1", "(Ljava/lang/Object;)Z", "macrofocus-common"})
    private static final class NonNullCondition<T>
    implements Condition<T> {
        @Override
        public boolean apply(@Nullable T var1) {
            return var1 != null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/macrofocus/common/collection/Iterables$ToStringConverter;", "Lcom/macrofocus/common/collection/Iterables$Converter;", "", "", "<init>", "()V", "convert", "var1", "macrofocus-common"})
    public static final class ToStringConverter
    implements Converter<Object, String> {
        @Override
        @Nullable
        public String convert(@Nullable Object var1) {
            Object object = var1;
            return object != null ? object.toString() : null;
        }
    }
}

