/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.crossplatform;

import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.timer.SwingTimer;
import java.sql.Date;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\n\u0018\u0000 22\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010\u001f\u001a\u00020\u00182\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030!J\u0012\u0010#\u001a\u00020\u00182\n\u0010$\u001a\u0006\u0012\u0002\b\u00030!J\u0012\u0010%\u001a\u00020\u00182\n\u0010$\u001a\u0006\u0012\u0002\b\u00030!J\u0010\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010\u0001J\u0010\u0010(\u001a\u00020)2\b\u0010'\u001a\u0004\u0018\u00010\u0001J\u0012\u0010*\u001a\u00020\u00182\n\u0010$\u001a\u0006\u0012\u0002\b\u00030!J\u0012\u0010+\u001a\u00020\u00182\n\u0010$\u001a\u0006\u0012\u0002\b\u00030!R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010,\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\t\u001a\u0004\b,\u0010-R\u0011\u0010/\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lcom/macrofocus/common/crossplatform/CPHelper;", "", "<init>", "()V", "nAvailableProcessors", "", "getNAvailableProcessors", "()I", "nAvailableProcessors$delegate", "Lkotlin/Lazy;", "visualizationExecutorService", "Lcom/macrofocus/common/concurrent/ExecutorService;", "getVisualizationExecutorService", "()Lcom/macrofocus/common/concurrent/ExecutorService;", "visualizationExecutorService$delegate", "newFixedThreadPool", "name", "", "corePoolSize", "maximumPoolSize", "createTimer", "Lcom/macrofocus/common/timer/CPTimer;", "delay", "postponing", "", "timerListener", "Lcom/macrofocus/common/timer/CPTimerListener;", "sleep", "", "millis", "", "isAssignableFrom", "a", "Lkotlin/reflect/KClass;", "b", "isNumericType", "cl", "isTemporalType", "isTemporalValue", "value", "doubleTemporalValue", "", "isVisualType", "isArray", "isMac", "()Z", "isMac$delegate", "currentTimeMillis", "getCurrentTimeMillis", "()J", "Companion", "macrofocus-common"})
public final class CPHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy nAvailableProcessors$delegate = LazyKt.lazy(CPHelper::nAvailableProcessors_delegate$lambda$0);
    @NotNull
    private final Lazy visualizationExecutorService$delegate = LazyKt.lazy(() -> CPHelper.visualizationExecutorService_delegate$lambda$0(this));
    @NotNull
    private final Lazy isMac$delegate = LazyKt.lazy(CPHelper::isMac_delegate$lambda$0);
    @NotNull
    private static final CPHelper instance = new CPHelper();

    public final int getNAvailableProcessors() {
        Lazy lazy = this.nAvailableProcessors$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Nullable
    public final ExecutorService getVisualizationExecutorService() {
        Lazy lazy = this.visualizationExecutorService$delegate;
        return (ExecutorService)lazy.getValue();
    }

    @Nullable
    public final ExecutorService newFixedThreadPool(@NotNull String name, int corePoolSize, int maximumPoolSize) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ThreadPoolExecutor threadPoolExecutor2 = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 20L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new ThreadFactory(name){
            private final ThreadGroup group;
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                this.group = System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup();
            }

            public final ThreadGroup getGroup() {
                return this.group;
            }

            public Thread newThread(Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Thread t = new Thread(this.group, r, this.$name, 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
        return new ExecutorService(threadPoolExecutor2);
    }

    @Nullable
    public final ExecutorService visualizationExecutorService() {
        return this.getVisualizationExecutorService();
    }

    @NotNull
    public final CPTimer createTimer(@NotNull String name, int delay, boolean postponing) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SwingTimer(name, delay, 10000, postponing);
    }

    @NotNull
    public final CPTimer createTimer(@NotNull String name, int delay, boolean postponing, @NotNull CPTimerListener timerListener) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)timerListener, (String)"timerListener");
        CPTimer timer = this.createTimer(name, delay, postponing);
        timer.addTimerListener(timerListener);
        return timer;
    }

    public final void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public final boolean isAssignableFrom(@NotNull KClass<?> a, @NotNull KClass<?> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return JvmClassMappingKt.getJavaClass(a).isAssignableFrom(JvmClassMappingKt.getJavaClass(b));
    }

    public final boolean isNumericType(@NotNull KClass<?> cl) {
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
        return this.isAssignableFrom(Reflection.getOrCreateKotlinClass(Number.class), cl) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) || Intrinsics.areEqual(cl, Double.TYPE) || Intrinsics.areEqual(cl, Integer.TYPE) || Intrinsics.areEqual(cl, Float.TYPE) || Intrinsics.areEqual(cl, Short.TYPE) || Intrinsics.areEqual(cl, Long.TYPE);
    }

    public final boolean isTemporalType(@NotNull KClass<?> cl) {
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
        return Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(java.util.Date.class)) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Date.class)) || Intrinsics.areEqual(cl, (Object)Reflection.getOrCreateKotlinClass(Instant.class));
    }

    public final boolean isTemporalValue(@Nullable Object value) {
        return value instanceof java.util.Date || value instanceof Date;
    }

    public final double doubleTemporalValue(@Nullable Object value) {
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).getTime();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        throw new UnsupportedOperationException();
    }

    public final boolean isVisualType(@NotNull KClass<?> cl) {
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
        return Intrinsics.areEqual((Object)cl.getSimpleName(), (Object)"Color");
    }

    public final boolean isArray(@NotNull KClass<?> cl) {
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
        return JvmClassMappingKt.getJavaClass(cl).isArray();
    }

    public final boolean isMac() {
        Lazy lazy = this.isMac$delegate;
        return (Boolean)lazy.getValue();
    }

    public final long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    private static final int nAvailableProcessors_delegate$lambda$0() {
        return Math.max(Runtime.getRuntime().availableProcessors(), 1);
    }

    private static final ExecutorService visualizationExecutorService_delegate$lambda$0(CPHelper this$0) {
        return this$0.newFixedThreadPool("VisualizationExecutorService", 0, this$0.getNAvailableProcessors());
    }

    private static final boolean isMac_delegate$lambda$0() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String os = string2;
        return os != null && Intrinsics.areEqual((Object)"mac os x", (Object)os);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/macrofocus/common/crossplatform/CPHelper$Companion;", "", "<init>", "()V", "instance", "Lcom/macrofocus/common/crossplatform/CPHelper;", "getInstance", "()Lcom/macrofocus/common/crossplatform/CPHelper;", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CPHelper getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

