/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonBoolean;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonNull;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonString;
import com.macrofocus.common.json.JsonTokenizer;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JvmJsonArray;
import com.macrofocus.common.json.JvmJsonBoolean;
import com.macrofocus.common.json.JvmJsonNull;
import com.macrofocus.common.json.JvmJsonNumber;
import com.macrofocus.common.json.JvmJsonObject;
import com.macrofocus.common.json.JvmJsonString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u001f\u0010\u0014\u001a\u0002H\u0015\"\n\b\u0000\u0010\u0015*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/common/json/JsonFactory;", "", "<init>", "()V", "create", "Lcom/macrofocus/common/json/JsonString;", "string", "", "Lcom/macrofocus/common/json/JsonNumber;", "number", "", "Lcom/macrofocus/common/json/JsonBoolean;", "bool", "", "createArray", "Lcom/macrofocus/common/json/JsonArray;", "createNull", "Lcom/macrofocus/common/json/JsonNull;", "createObject", "Lcom/macrofocus/common/json/JsonObject;", "parse", "T", "Lcom/macrofocus/common/json/JsonValue;", "jsonString", "(Ljava/lang/String;)Lcom/macrofocus/common/json/JsonValue;", "macrofocus-common"})
public final class JsonFactory {
    @NotNull
    public static final JsonFactory INSTANCE = new JsonFactory();

    private JsonFactory() {
    }

    @NotNull
    public final JsonString create(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new JvmJsonString(string);
    }

    @NotNull
    public final JsonNumber create(double number) {
        return new JvmJsonNumber(number);
    }

    @NotNull
    public final JsonBoolean create(boolean bool) {
        return new JvmJsonBoolean(bool);
    }

    @NotNull
    public final JsonArray createArray() {
        return new JvmJsonArray(this);
    }

    @NotNull
    public final JsonNull createNull() {
        return JvmJsonNull.Companion.getNULL_INSTANCE();
    }

    @NotNull
    public final JsonObject createObject() {
        return new JvmJsonObject(this);
    }

    public final <T extends JsonValue> T parse(@NotNull String jsonString) throws JsonException {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        String jsonString2 = jsonString;
        if (StringsKt.startsWith$default((String)jsonString2, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)jsonString2, (String)")", (boolean)false, (int)2, null)) {
            String string = jsonString2.substring(1, jsonString2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            jsonString2 = string;
        }
        return new JsonTokenizer(this, jsonString2).nextValue();
    }
}

