/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonBoolean;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonObjectContext;
import com.macrofocus.common.json.JsonString;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonUtil;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0016J\"\u0010\u0012\u001a\u0002H\u0013\"\n\b\u0000\u0010\u0013*\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\bH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0012\u0010$\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\tH\u0016J\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'H\u0016\u00a2\u0006\u0002\u0010(J\u001a\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010%\u001a\u00020\rH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u000bH\u0016J\u0012\u0010,\u001a\u00020*2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u001b\u0010-\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\tH\u0086\u0002J\b\u0010.\u001a\u00020\bH\u0016J\n\u0010/\u001a\u00020\bH\u0096\u0080\u0004J\u0018\u00100\u001a\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020*2\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001dR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00069"}, d2={"Lcom/macrofocus/common/json/JvmJsonObject;", "Lcom/macrofocus/common/json/JsonObject;", "factory", "Lcom/macrofocus/common/json/JsonFactory;", "<init>", "(Lcom/macrofocus/common/json/JsonFactory;)V", "map", "", "", "Lcom/macrofocus/common/json/JsonValue;", "asBoolean", "", "asNumber", "", "asString", "asJsonArray", "Lcom/macrofocus/common/json/JsonArray;", "asJsonObject", "get", "T", "key", "(Ljava/lang/String;)Lcom/macrofocus/common/json/JsonValue;", "getArray", "getBoolean", "getNumber", "getObject", "toNative", "", "object", "()Ljava/lang/Object;", "getString", "type", "Lcom/macrofocus/common/json/JsonType;", "getType", "()Lcom/macrofocus/common/json/JsonType;", "hasKey", "jsEquals", "value", "keys", "", "()[Ljava/lang/String;", "put", "", "bool", "remove", "set", "toJson", "toString", "traverse", "visitor", "Lcom/macrofocus/common/json/JsonVisitor;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "writeObject", "stream", "Ljava/io/ObjectOutputStream;", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nJsonObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonObject.kt\ncom/macrofocus/common/json/JvmJsonObject\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,354:1\n37#2,2:355\n*S KotlinDebug\n*F\n+ 1 JsonObject.kt\ncom/macrofocus/common/json/JvmJsonObject\n*L\n268#1:355,2\n*E\n"})
public final class JvmJsonObject
implements JsonObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private JsonFactory factory;
    @NotNull
    private Map<String, JsonValue> map;
    private static final long serialVersionUID = 1L;

    public JvmJsonObject(@NotNull JsonFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.map = new LinkedHashMap();
        this.factory = factory;
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        return Double.NaN;
    }

    @Override
    @NotNull
    public String asString() {
        return "[object Object]";
    }

    @Override
    @Nullable
    public JsonArray asJsonArray() {
        return null;
    }

    @Override
    @Nullable
    public JsonObject asJsonObject() {
        return this;
    }

    @Override
    public <T extends JsonValue> T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (T)this.map.get(key);
    }

    @Override
    @Nullable
    public JsonArray getArray(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (JsonArray)this.get(key);
    }

    @Override
    public boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object t = this.get(key);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonBoolean");
        return ((JsonBoolean)t).getBoolean();
    }

    @Override
    public double getNumber(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object t = this.get(key);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonNumber");
        return ((JsonNumber)t).getNumber();
    }

    @Override
    @Nullable
    public JsonObject getObject(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (JsonObject)this.get(key);
    }

    @Override
    @Nullable
    public Object toNative() {
        return this;
    }

    @Override
    @NotNull
    public Object getObject() {
        Map obj = new HashMap();
        for (Map.Entry<String, JsonValue> entry : this.map.entrySet()) {
            String key = entry.getKey();
            JsonValue value = entry.getValue();
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
            obj.put(key, value.getObject());
        }
        return obj;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object t = this.get(key);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonString");
        return ((JsonString)t).getString();
    }

    @Override
    @NotNull
    public JsonType getType() {
        return JsonType.OBJECT;
    }

    @Override
    public boolean hasKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.map.containsKey(key);
    }

    @Override
    public boolean jsEquals(@Nullable JsonValue value) {
        Object object = this.getObject();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
        return Intrinsics.areEqual((Object)object, (Object)value.getObject());
    }

    @Override
    @NotNull
    public String[] keys() {
        Collection $this$toTypedArray$iv = this.map.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    public void put(@NotNull String key, @Nullable JsonValue value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonValue value2 = value;
        if (value2 == null) {
            value2 = this.factory.createNull();
        }
        this.map.put(key, value2);
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.put(key, this.factory.create(value));
    }

    @Override
    public void put(@NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.put(key, this.factory.create(value));
    }

    @Override
    public void put(@NotNull String key, boolean bool) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.put(key, this.factory.create(bool));
    }

    @Override
    public void remove(@Nullable String key) {
        TypeIntrinsics.asMutableMap(this.map).remove(key);
    }

    public final void set(@NotNull String key, @Nullable JsonValue value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.put(key, value);
    }

    @Override
    @NotNull
    public String toJson() {
        return JsonUtil.INSTANCE.stringify(this);
    }

    @NotNull
    public String toString() {
        return this.toJson();
    }

    @Override
    public void traverse(@NotNull JsonVisitor visitor, @NotNull JsonContext ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (visitor.visit(this, ctx)) {
            JsonObjectContext objCtx = new JsonObjectContext(this);
            for (String key : JvmJsonObject.Companion.stringifyOrder(this.keys())) {
                objCtx.setCurrentKey(key);
                if (!visitor.visitKey(objCtx.getCurrentKey(), objCtx)) continue;
                visitor.accept((JsonValue)this.get(key), objCtx);
                objCtx.setFirst(false);
            }
        }
        visitor.endVisit(this, ctx);
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/macrofocus/common/json/JvmJsonObject$Companion;", "", "<init>", "()V", "serialVersionUID", "", "stringifyOrder", "", "", "keys", "", "([Ljava/lang/String;)Ljava/util/List;", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> stringifyOrder(String[] keys) {
            List toReturn = new ArrayList();
            List nonNumeric = new ArrayList();
            for (String key : keys) {
                CharSequence charSequence = key;
                boolean bl = new Regex("\\d+").matches(charSequence) ? toReturn.add(key) : nonNumeric.add(key);
            }
            CollectionsKt.sort((List)toReturn);
            toReturn.addAll(nonNumeric);
            return toReturn;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

