/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math.big;

import com.macrofocus.common.math.big.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/macrofocus/common/math/big/MathContext;", "", "precision", "", "roundingMode", "Lcom/macrofocus/common/math/big/RoundingMode;", "<init>", "(ILcom/macrofocus/common/math/big/RoundingMode;)V", "getPrecision", "()I", "getRoundingMode", "()Lcom/macrofocus/common/math/big/RoundingMode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "macrofocus-common"})
public final class MathContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int precision;
    @NotNull
    private final RoundingMode roundingMode;
    @JvmField
    @NotNull
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    @JvmField
    @NotNull
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    @JvmField
    @NotNull
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    @JvmField
    @NotNull
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);

    public MathContext(int precision, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        this.precision = precision;
        this.roundingMode = roundingMode;
        if (!(this.precision >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ MathContext(int n, RoundingMode roundingMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 9;
        }
        if ((n2 & 2) != 0) {
            roundingMode = RoundingMode.HALF_UP;
        }
        this(n, roundingMode);
    }

    public final int getPrecision() {
        return this.precision;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public final int component1() {
        return this.precision;
    }

    @NotNull
    public final RoundingMode component2() {
        return this.roundingMode;
    }

    @NotNull
    public final MathContext copy(int precision, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        return new MathContext(precision, roundingMode);
    }

    public static /* synthetic */ MathContext copy$default(MathContext mathContext, int n, RoundingMode roundingMode, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mathContext.precision;
        }
        if ((n2 & 2) != 0) {
            roundingMode = mathContext.roundingMode;
        }
        return mathContext.copy(n, roundingMode);
    }

    @NotNull
    public String toString() {
        return "MathContext(precision=" + this.precision + ", roundingMode=" + this.roundingMode + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.precision);
        result = result * 31 + this.roundingMode.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MathContext)) {
            return false;
        }
        MathContext mathContext = (MathContext)other;
        if (this.precision != mathContext.precision) {
            return false;
        }
        return this.roundingMode == mathContext.roundingMode;
    }

    public MathContext() {
        this(0, null, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/macrofocus/common/math/big/MathContext$Companion;", "", "<init>", "()V", "UNLIMITED", "Lcom/macrofocus/common/math/big/MathContext;", "DECIMAL32", "DECIMAL64", "DECIMAL128", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

