/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math.big;

import com.macrofocus.common.math.big.MutableBigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/macrofocus/common/math/big/SignedMutableBigInteger;", "Lcom/macrofocus/common/math/big/MutableBigInteger;", "<init>", "()V", "val", "", "(I)V", "(Lcom/macrofocus/common/math/big/MutableBigInteger;)V", "sign", "getSign", "()I", "setSign", "signedAdd", "", "addend", "signedSubtract", "toString", "", "macrofocus-common"})
public final class SignedMutableBigInteger
extends MutableBigInteger {
    private int sign;

    public final int getSign() {
        return this.sign;
    }

    public final void setSign(int n) {
        this.sign = n;
    }

    public SignedMutableBigInteger() {
        this.sign = 1;
    }

    public SignedMutableBigInteger(int val) {
        super(val);
        this.sign = 1;
    }

    public SignedMutableBigInteger(@NotNull MutableBigInteger val) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        super(val);
        this.sign = 1;
    }

    public final void signedAdd(@NotNull SignedMutableBigInteger addend) {
        Intrinsics.checkNotNullParameter((Object)addend, (String)"addend");
        if (this.sign == addend.sign) {
            this.add(addend);
        } else {
            this.sign *= this.subtract(addend);
        }
    }

    public final void signedAdd(@NotNull MutableBigInteger addend) {
        Intrinsics.checkNotNullParameter((Object)addend, (String)"addend");
        if (this.sign == 1) {
            this.add(addend);
        } else {
            this.sign *= this.subtract(addend);
        }
    }

    public final void signedSubtract(@NotNull SignedMutableBigInteger addend) {
        Intrinsics.checkNotNullParameter((Object)addend, (String)"addend");
        if (this.sign == addend.sign) {
            this.sign *= this.subtract(addend);
        } else {
            this.add(addend);
        }
    }

    public final void signedSubtract(@NotNull MutableBigInteger addend) {
        Intrinsics.checkNotNullParameter((Object)addend, (String)"addend");
        if (this.sign == 1) {
            this.sign *= this.subtract(addend);
        } else {
            this.add(addend);
        }
        if (this.getIntLen() == 0) {
            this.sign = 1;
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.toBigInteger(this.sign).toString();
    }
}

