/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.scale;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/macrofocus/common/scale/Probit;", "", "<init>", "()V", "LOW", "", "HIGH", "A0", "A1", "A2", "A3", "A4", "A5", "B0", "B1", "B2", "B3", "B4", "C0", "C1", "C2", "C3", "C4", "C5", "D0", "D1", "D2", "D3", "probit", "d", "macrofocus-common"})
public final class Probit {
    @NotNull
    public static final Probit INSTANCE = new Probit();
    private static final double LOW = 0.02425;
    private static final double HIGH = 0.97575;
    private static final double A0 = -39.69683028665376;
    private static final double A1 = 220.9460984245205;
    private static final double A2 = -275.9285104469687;
    private static final double A3 = 138.357751867269;
    private static final double A4 = -30.66479806614716;
    private static final double A5 = 2.506628277459239;
    private static final double B0 = -54.47609879822406;
    private static final double B1 = 161.5858368580409;
    private static final double B2 = -155.6989798598866;
    private static final double B3 = 66.80131188771972;
    private static final double B4 = -13.28068155288572;
    private static final double C0 = -0.007784894002430293;
    private static final double C1 = -0.3223964580411365;
    private static final double C2 = -2.400758277161838;
    private static final double C3 = -2.549732539343734;
    private static final double C4 = 4.374664141464968;
    private static final double C5 = 2.938163982698783;
    private static final double D0 = 0.007784695709041462;
    private static final double D1 = 0.3224671290700398;
    private static final double D2 = 2.445134137142996;
    private static final double D3 = 3.754408661907416;

    private Probit() {
    }

    public final double probit(double d) {
        if (d <= 0.0 || d >= 1.0) {
            return (d - 0.5) / 0.0;
        }
        if (d < 0.02425) {
            double q = Math.sqrt((double)-2 * Math.log(d));
            return (((((-0.007784894002430293 * q + -0.3223964580411365) * q + -2.400758277161838) * q + -2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1.0);
        }
        if (0.97575 < d) {
            double q = Math.sqrt((double)-2 * Math.log(1.0 - d));
            return -(((((-0.007784894002430293 * q + -0.3223964580411365) * q + -2.400758277161838) * q + -2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1.0);
        }
        double q = d - 0.5;
        double r = q * q;
        return (((((-39.69683028665376 * r + 220.9460984245205) * r + -275.9285104469687) * r + 138.357751867269) * r + -30.66479806614716) * r + 2.506628277459239) * q / (((((-54.47609879822406 * r + 161.5858368580409) * r + -155.6989798598866) * r + 66.80131188771972) * r + -13.28068155288572) * r + 1.0);
    }
}

