/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSelectionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0004R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/common/selection/AbstractSelection;", "E", "Lcom/macrofocus/common/selection/Selection;", "<init>", "()V", "enabled", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "listeners", "", "Lcom/macrofocus/common/selection/SelectionListener;", "addSelectionListener", "", "listener", "addWeakSelectionListener", "removeSelectionListener", "removeSelectionListeners", "notifySelectedChanged", "event", "Lcom/macrofocus/common/selection/SelectionEvent;", "WeakSelectionListener", "macrofocus-common"})
public abstract class AbstractSelection<E>
implements Selection<E> {
    private boolean isEnabled = true;
    @NotNull
    private final List<SelectionListener<E>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.isEnabled = enabled;
            Set changes = SetsKt.emptySet();
            this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
        }
    }

    @Override
    public void addSelectionListener(@NotNull SelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakSelectionListener(@NotNull SelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        WeakSelectionListener weakListener = new WeakSelectionListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeSelectionListener(@NotNull SelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakSelectionListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            SelectionListener<E> toRemove = null;
            for (SelectionListener<E> selectionListener : this.listeners) {
                SelectionListener<E> comparable = null;
                comparable = selectionListener instanceof WeakSelectionListener ? ((WeakSelectionListener)selectionListener).getReference() : selectionListener;
                if (!listener2.equals(comparable)) continue;
                toRemove = selectionListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeSelectionListeners() {
        this.listeners.clear();
    }

    protected final void notifySelectedChanged(@NotNull SelectionEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (SelectionListener<E> listener2 : this.listeners) {
            listener2.selectionChanged(event);
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/macrofocus/common/selection/AbstractSelection$WeakSelectionListener;", "Lcom/macrofocus/common/selection/SelectionListener;", "listener", "<init>", "(Lcom/macrofocus/common/selection/AbstractSelection;Lcom/macrofocus/common/selection/SelectionListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "selectionChanged", "", "event", "Lcom/macrofocus/common/selection/SelectionEvent;", "reference", "getReference", "()Lcom/macrofocus/common/selection/SelectionListener;", "toString", "", "macrofocus-common"})
    private final class WeakSelectionListener
    implements SelectionListener<E> {
        @NotNull
        private final WeakReference<SelectionListener<E>> l_ref;

        public WeakSelectionListener(SelectionListener<E> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }

        @Override
        public void selectionChanged(@NotNull SelectionEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            SelectionListener l = this.getReference();
            if (l != null) {
                l.selectionChanged(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.common.selection.SelectionListener<E of com.macrofocus.common.selection.AbstractSelection>");
                AbstractSelection.this.removeSelectionListener(this);
            }
        }

        @Nullable
        public final SelectionListener<E> getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            SelectionListener l = this.getReference();
            return l != null ? "Weak[" + l + "]" : String.valueOf(this.getReference());
        }
    }
}

