/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.timer;

import com.macrofocus.common.timer.AbstractTimer;
import com.macrofocus.common.timer.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\n\u0010 \u001a\u00020!H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/macrofocus/common/timer/CoalescingTimer;", "Lcom/macrofocus/common/timer/AbstractTimer;", "Ljava/lang/Runnable;", "delay", "", "postponing", "", "<init>", "(IZ)V", "listener", "Lcom/macrofocus/common/timer/Timer$TimerListener;", "(ILcom/macrofocus/common/timer/Timer$TimerListener;)V", "isLocked", "isAborted", "value", "isScheduled", "()Z", "isMutexed", "mutex", "Ljava/lang/Object;", "lockMutex", "timerMutex", "stopped", "run", "", "restart", "queue", "postpone", "lock", "unLock", "trigger", "stop", "toString", "", "macrofocus-common"})
public final class CoalescingTimer
extends AbstractTimer
implements Runnable {
    private final int delay;
    private final boolean postponing;
    private boolean isLocked;
    private boolean isAborted;
    private boolean isScheduled;
    private boolean isMutexed;
    @NotNull
    private final Object mutex;
    @NotNull
    private final Object lockMutex;
    @NotNull
    private final Object timerMutex;
    private boolean stopped;

    @JvmOverloads
    public CoalescingTimer(int delay, boolean postponing) {
        this.delay = delay;
        this.postponing = postponing;
        this.isLocked = true;
        this.stopped = true;
        this.mutex = new Object();
        this.lockMutex = new Object();
        this.timerMutex = new Object();
    }

    public /* synthetic */ CoalescingTimer(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(n, bl);
    }

    @Override
    public boolean isScheduled() {
        return this.isScheduled;
    }

    public CoalescingTimer(int delay, @Nullable Timer.TimerListener listener2) {
        this(delay, true);
        Timer.TimerListener timerListener = listener2;
        Intrinsics.checkNotNull((Object)timerListener);
        this.addActionListener(timerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.stopped = false;
        while (!this.stopped) {
            this.lock();
            this.queue();
            try {
                Object object = this.mutex;
                synchronized (object) {
                    boolean bl = false;
                    while (this.isMutexed) {
                        this.mutex.wait();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (this.stopped) continue;
                this.trigger();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void restart() {
        if (this.postponing) {
            if (this.isScheduled()) {
                this.postpone();
            } else {
                this.unLock();
            }
        } else if (!this.isScheduled()) {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void queue() {
        try {
            Object object = this.timerMutex;
            synchronized (object) {
                boolean bl = false;
                this.isScheduled = true;
                while (this.isScheduled()) {
                    this.timerMutex.wait(this.delay);
                    if (!this.isAborted) {
                        Object object2 = this.mutex;
                        synchronized (object2) {
                            boolean bl2 = false;
                            this.isMutexed = false;
                            this.mutex.notifyAll();
                            this.isScheduled = false;
                            Unit unit = Unit.INSTANCE;
                            continue;
                        }
                    }
                    this.isAborted = false;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postpone() {
        Object object = this.timerMutex;
        synchronized (object) {
            boolean bl = false;
            this.isAborted = true;
            this.timerMutex.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lock() {
        Object object = this.lockMutex;
        synchronized (object) {
            boolean bl = false;
            while (this.isLocked) {
                try {
                    this.lockMutex.wait();
                }
                catch (Exception exception) {}
            }
            this.isLocked = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unLock() {
        Object object = this.lockMutex;
        synchronized (object) {
            boolean bl = false;
            this.isLocked = false;
            this.lockMutex.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void trigger() {
        this.fireTimerTriggered();
    }

    @Override
    public void stop() {
        this.stopped = true;
        if (this.isScheduled()) {
            this.postpone();
        } else {
            this.unLock();
        }
    }

    @NotNull
    public String toString() {
        return "CoalescingTimer{postponing=" + this.postponing + ", delay=" + this.delay + ", isLocked=" + this.isLocked + ", isAborted=" + this.isAborted + ", isScheduled=" + this.isScheduled() + ", isMutexed=" + this.isMutexed + ", stopped=" + this.stopped + "}";
    }

    @JvmOverloads
    public CoalescingTimer(int delay) {
        this(delay, false, 2, null);
    }
}

