/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.svg.attributes;

import com.macrofocus.svg.logging.LogKt;
import com.macrofocus.svg.logging.LogLevel;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/svg/attributes/AttributeType;", "", "<init>", "(Ljava/lang/String;I)V", "None", "Length", "LengthOrPercentage", "NumberList", "IdName", "Relative", "Path", "CssClass", "verify", "", "value", "", "Companion", "macrofocus-common"})
public class AttributeType
extends Enum<AttributeType> {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private static final Regex number;
    @NotNull
    private static final Regex separator;
    @NotNull
    private static final String lengthUnits = "em|ex|px|in|cm|mm|pt|pc";
    @NotNull
    private static final Regex length;
    @NotNull
    private static final Regex lengthPercent;
    @NotNull
    private static final Regex numberList;
    @NotNull
    private static final Regex idName;
    @NotNull
    private static final Regex relative;
    @NotNull
    private static final Regex path;
    public static final /* enum */ AttributeType None;
    public static final /* enum */ AttributeType Length;
    public static final /* enum */ AttributeType LengthOrPercentage;
    public static final /* enum */ AttributeType NumberList;
    public static final /* enum */ AttributeType IdName;
    public static final /* enum */ AttributeType Relative;
    public static final /* enum */ AttributeType Path;
    public static final /* enum */ AttributeType CssClass;
    private static final /* synthetic */ AttributeType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private AttributeType() {
    }

    public void verify(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    public static AttributeType[] values() {
        return (AttributeType[])$VALUES.clone();
    }

    public static AttributeType valueOf(String value) {
        return Enum.valueOf(AttributeType.class, value);
    }

    @NotNull
    public static EnumEntries<AttributeType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ AttributeType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        None = new AttributeType();
        Length = new Length("Length", 1);
        LengthOrPercentage = new LengthOrPercentage("LengthOrPercentage", 2);
        NumberList = new NumberList("NumberList", 3);
        IdName = new IdName("IdName", 4);
        Relative = new Relative("Relative", 5);
        Path = new AttributeType();
        CssClass = new CssClass("CssClass", 7);
        $VALUES = attributeTypeArray = new AttributeType[]{AttributeType.None, AttributeType.Length, AttributeType.LengthOrPercentage, AttributeType.NumberList, AttributeType.IdName, AttributeType.Relative, AttributeType.Path, AttributeType.CssClass};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        number = new Regex("[+-]?[0-9]*.?[0-9]+");
        separator = new Regex("\\s*,?\\s+");
        length = new Regex(number + "(em|ex|px|in|cm|mm|pt|pc)?");
        lengthPercent = new Regex(number + "(em|ex|px|in|cm|mm|pt|pc|%)?");
        numberList = new Regex("(" + number + "(" + separator + ")?)+");
        idName = new Regex("[^\\s]+");
        relative = new Regex("#" + idName);
        path = new Regex("((" + number + ")|[\\smMlLhHvVcCsSqQtTaAzZ])+");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/svg/attributes/AttributeType$Companion;", "", "<init>", "()V", "number", "Lkotlin/text/Regex;", "separator", "lengthUnits", "", "length", "lengthPercent", "numberList", "idName", "relative", "path", "macrofocus-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/macrofocus/svg/attributes/AttributeType.CssClass", "Lcom/macrofocus/svg/attributes/AttributeType;", "verify", "", "value", "", "macrofocus-common"})
    static final class CssClass
    extends AttributeType {
        /*
         * WARNING - void declaration
         */
        CssClass() {
            void var1_1;
        }

        @Override
        public void verify(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            LogKt.log(LogLevel.WARN, "CSS support is incomplete in some browsers, know issues in IE and Firefox.");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/macrofocus/svg/attributes/AttributeType.IdName", "Lcom/macrofocus/svg/attributes/AttributeType;", "verify", "", "value", "", "macrofocus-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeType.kt\ncom/macrofocus/svg/attributes/AttributeType$IdName\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    static final class IdName
    extends AttributeType {
        /*
         * WARNING - void declaration
         */
        IdName() {
            void var1_1;
        }

        @Override
        public void verify(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            if (!idName.matches(charSequence)) {
                boolean bl = false;
                String string = "Value (" + value + ") is not a valid id: " + idName;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/macrofocus/svg/attributes/AttributeType.Length", "Lcom/macrofocus/svg/attributes/AttributeType;", "verify", "", "value", "", "macrofocus-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeType.kt\ncom/macrofocus/svg/attributes/AttributeType$Length\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    static final class Length
    extends AttributeType {
        /*
         * WARNING - void declaration
         */
        Length() {
            void var1_1;
        }

        @Override
        public void verify(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            if (!length.matches(charSequence)) {
                boolean bl = false;
                String string = "Value (" + value + ") is not a valid length or percentage: " + length;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/macrofocus/svg/attributes/AttributeType.LengthOrPercentage", "Lcom/macrofocus/svg/attributes/AttributeType;", "verify", "", "value", "", "macrofocus-common"})
    static final class LengthOrPercentage
    extends AttributeType {
        /*
         * WARNING - void declaration
         */
        LengthOrPercentage() {
            void var1_1;
        }

        @Override
        public void verify(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            if (!lengthPercent.matches(charSequence)) {
                boolean bl = false;
                String string = "Value (" + value + ") is not a valid length or percentage: " + lengthPercent;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/macrofocus/svg/attributes/AttributeType.NumberList", "Lcom/macrofocus/svg/attributes/AttributeType;", "verify", "", "value", "", "macrofocus-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeType.kt\ncom/macrofocus/svg/attributes/AttributeType$NumberList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    static final class NumberList
    extends AttributeType {
        /*
         * WARNING - void declaration
         */
        NumberList() {
            void var1_1;
        }

        @Override
        public void verify(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            if (!numberList.matches(charSequence)) {
                boolean bl = false;
                String string = "Value (" + value + ") is not a valid number list: " + number;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/macrofocus/svg/attributes/AttributeType.Relative", "Lcom/macrofocus/svg/attributes/AttributeType;", "verify", "", "value", "", "macrofocus-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeType.kt\ncom/macrofocus/svg/attributes/AttributeType$Relative\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    static final class Relative
    extends AttributeType {
        /*
         * WARNING - void declaration
         */
        Relative() {
            void var1_1;
        }

        @Override
        public void verify(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            if (!relative.matches(charSequence)) {
                boolean bl = false;
                String string = "Value (" + value + ") is not a valid id: " + relative;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }
}

