/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.scale;

import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.OpenInterval;
import com.macrofocus.common.scale.Probit;
import com.macrofocus.common.scale.Transform;
import java.util.function.UnaryOperator;

public final class NumericTransform
extends Enum<NumericTransform>
implements Transform {
    public static final /* enum */ NumericTransform ASN;
    public static final /* enum */ NumericTransform ATANH;
    public static final /* enum */ NumericTransform ASINH;
    public static final /* enum */ NumericTransform EXP;
    public static final /* enum */ NumericTransform EXP2;
    public static final /* enum */ NumericTransform EXP10;
    public static final /* enum */ NumericTransform EXP1P;
    public static final /* enum */ NumericTransform IDENTITY;
    public static final /* enum */ NumericTransform LOG;
    public static final /* enum */ NumericTransform LOG2;
    public static final /* enum */ NumericTransform LOG10;
    public static final /* enum */ NumericTransform LOG1P;
    public static final /* enum */ NumericTransform PSEUDO_LOG;
    public static final /* enum */ NumericTransform PSEUDO_LOG2;
    public static final /* enum */ NumericTransform PSEUDO_LOG10;
    public static final /* enum */ NumericTransform LOGIT;
    public static final /* enum */ NumericTransform PROBIT;
    public static final /* enum */ NumericTransform RECIPROCAL;
    public static final /* enum */ NumericTransform REVERSE;
    public static final /* enum */ NumericTransform SQRT;
    private String a;
    private UnaryOperator<Double> b;
    private UnaryOperator<Double> c;
    private UnaryOperator<Double> d;
    private UnaryOperator<Double> e;
    private Interval f;
    private static final /* synthetic */ NumericTransform[] g;

    public static NumericTransform[] values() {
        return (NumericTransform[])g.clone();
    }

    public static NumericTransform valueOf(String name) {
        String string;
        return Enum.valueOf(NumericTransform.class, string);
    }

    /*
     * WARNING - void declaration
     */
    private NumericTransform(String shortName, UnaryOperator<Double> transform, UnaryOperator<Double> inverse, UnaryOperator<Double> dtransform, Interval domain) {
        void var3_3;
        this.a = var3_3;
        this.b = transform;
        this.c = inverse;
        this.d = dtransform;
        this.e = inverse;
        this.f = domain;
    }

    @Override
    public final String getShortName() {
        return this.a;
    }

    @Override
    public final UnaryOperator<Double> getTransform() {
        return this.b;
    }

    @Override
    public final UnaryOperator<Double> getInverse() {
        return this.c;
    }

    @Override
    public final UnaryOperator<Double> getDTransform() {
        return this.d;
    }

    @Override
    public final UnaryOperator<Double> getDInverse() {
        return this.e;
    }

    @Override
    public final Interval getDomain() {
        return this.f;
    }

    private static double a(double d2, double d3, double d4) {
        return NumericTransform.asinh(d2 / 2.0) / Math.log(d4);
    }

    public static double asinh(double a2) {
        double d2;
        boolean bl = false;
        if (a2 < 0.0) {
            bl = true;
            a2 = -a2;
        }
        if (a2 > 0.167) {
            double d3 = a2;
            d2 = Math.log(Math.sqrt(d3 * d3 + 1.0) + a2);
        } else {
            double d4;
            double d5 = a2;
            double d6 = d5 * d5;
            d2 = a2 > 0.097 ? a2 * (1.0 - d6 * (0.3333333333333333 - d6 * (0.2 - d6 * (0.14285714285714285 - d6 * (0.1111111111111111 - d6 * (0.09090909090909091 - d6 * (0.07692307692307693 - d6 * (0.06666666666666667 - d6 * 0.058823529411764705 * 0.9375) * 0.9285714285714286) * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (a2 > 0.036 ? a2 * (1.0 - d6 * (0.3333333333333333 - d6 * (0.2 - d6 * (0.14285714285714285 - d6 * (0.1111111111111111 - d6 * (0.09090909090909091 - d6 * 0.07692307692307693 * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (a2 > 0.0036 ? a2 * (1.0 - d6 * (0.3333333333333333 - d6 * (0.2 - d6 * (0.14285714285714285 - d6 * 0.1111111111111111 * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : d4 * (1.0 - d6 * (0.3333333333333333 - d6 * 0.2 * 0.75) * 0.5)));
        }
        if (bl) {
            return -d2;
        }
        return d2;
    }

    static {
        UnaryOperator cfr_ignored_0 = d2 -> Math.sin(d2) / 2.0;
        ASN = new NumericTransform("ASN", 0, "asn", d2 -> 2.0 * Math.asin(Math.sqrt(d2)), d2 -> 1.0 / Math.sqrt(d2 - Math.pow(d2, 2.0)), d2 -> 1.0 / Math.sqrt(d2 - Math.pow(d2, 2.0)), new OpenInterval(0.0, 1.0));
        ATANH = new NumericTransform("ATANH", 1, "atanh", d2 -> 1.0 / (1.0 - Math.pow(d2, 2.0)), d2 -> 1.0 / Math.pow(Math.cosh(d2), 2.0), null, new OpenInterval(-1.0, 2.0));
        UnaryOperator cfr_ignored_1 = Math::cosh;
        ASINH = new NumericTransform("ASINH", 2, "asinh", d2 -> NumericTransform.asinh(d2), Math::sinh, d2 -> 1.0 / Math.sqrt(Math.pow(d2, 2.0) + 1.0), new OpenInterval(-1.0, 2.0));
        UnaryOperator cfr_ignored_2 = d2 -> 1.0 / d2 / Math.log(Math.E);
        EXP = new NumericTransform("EXP", 3, "exp", d2 -> Math.exp(d2), Math::log, d2 -> Math.pow(d2, Math.E) * Math.log(Math.E), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_3 = d2 -> 1.0 / d2 / Math.log(2.0);
        EXP2 = new NumericTransform("EXP2", 4, "exp2", d2 -> Math.pow(d2, 2.0), d2 -> Math.log(d2) / Math.log(2.0), d2 -> Math.pow(d2, 2.0) * Math.log(2.0), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_4 = d2 -> 1.0 / d2 / Math.log(10.0);
        EXP10 = new NumericTransform("EXP10", 5, "exp10", d2 -> Math.pow(d2, 10.0), Math::log10, d2 -> Math.pow(d2, 10.0) * Math.log(10.0), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_5 = d2 -> 1.0 / (1.0 + d2);
        EXP1P = new NumericTransform("EXP1P", 6, "expm1", Math::expm1, Math::log1p, Math::exp, new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        IDENTITY = new NumericTransform("IDENTITY", 7, "identity", d2 -> d2, d2 -> d2, null, new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_6 = d2 -> Math.pow(d2, Math.E) * Math.log(Math.E);
        LOG = new NumericTransform("LOG", 8, "log", Math::log, Math::exp, d2 -> 1.0 / d2 / Math.log(Math.E), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_7 = d2 -> Math.pow(d2, 2.0) * Math.log(2.0);
        LOG2 = new NumericTransform("LOG2", 9, "log2", d2 -> Math.log(d2) / Math.log(2.0), d2 -> Math.pow(d2, 2.0), d2 -> 1.0 / d2 / Math.log(2.0), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_8 = d2 -> Math.pow(d2, 10.0) * Math.log(10.0);
        LOG10 = new NumericTransform("LOG10", 10, "log10", Math::log10, d2 -> Math.pow(d2, 10.0), d2 -> 1.0 / d2 / Math.log(10.0), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_9 = Math::exp;
        LOG1P = new NumericTransform("LOG1P", 11, "log1p", Math::log1p, Math::expm1, d2 -> 1.0 / (1.0 + d2), new OpenInterval(1.0, Double.POSITIVE_INFINITY));
        UnaryOperator cfr_ignored_10 = d2 -> 2.0 * Math.cosh(d2 * Math.log(Math.exp(1.0))) * Math.log(Math.exp(1.0));
        PSEUDO_LOG = new NumericTransform("PSEUDO_LOG", 12, "pseudo_log", d2 -> NumericTransform.a(d2, 1.0, Math.exp(1.0)), d2 -> NumericTransform.a(d2, 1.0, Math.exp(1.0)), d2 -> 1.0 / (Math.sqrt(4.0 + Math.pow(d2, 2.0) / Math.pow(1.0, 2.0)) * Math.log(Math.exp(1.0))), null);
        PSEUDO_LOG2 = new NumericTransform("PSEUDO_LOG2", 13, "pseudo_log2", d2 -> NumericTransform.a(d2, 1.0, 2.0), d2 -> NumericTransform.a(d2, 1.0, 2.0), null, null);
        PSEUDO_LOG10 = new NumericTransform("PSEUDO_LOG10", 14, "pseudo_log10", d2 -> NumericTransform.a(d2, 1.0, Math.exp(10.0)), d2 -> NumericTransform.a(d2, 1.0, Math.exp(10.0)), null, null);
        LOGIT = new NumericTransform("LOGIT", 15, "logit", d2 -> Math.log(d2 / (1.0 - d2)), d2 -> 1.0 / (1.0 + Math.exp(d2)), null, null);
        PROBIT = new NumericTransform("PROBIT", 16, "probit", Probit::probit, null, null, null);
        UnaryOperator cfr_ignored_11 = d2 -> -1.0 / Math.pow(d2, 2.0);
        RECIPROCAL = new NumericTransform("RECIPROCAL", 17, "reciprocal", d2 -> 1.0 / d2, d2 -> 1.0 / d2, d2 -> -1.0 / Math.pow(d2, 2.0), null);
        REVERSE = new NumericTransform("REVERSE", 18, "reverse", d2 -> -d2.doubleValue(), d2 -> -d2.doubleValue(), null, null);
        UnaryOperator cfr_ignored_12 = d2 -> 2.0 * d2;
        SQRT = new NumericTransform("SQRT", 19, "sqrt", Math::sqrt, d2 -> Math.pow(d2, 2.0), d2 -> 0.5 / Math.sqrt(d2), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
        g = new NumericTransform[]{ASN, ATANH, ASINH, EXP, EXP2, EXP10, EXP1P, IDENTITY, LOG, LOG2, LOG10, LOG1P, PSEUDO_LOG, PSEUDO_LOG2, PSEUDO_LOG10, LOGIT, PROBIT, RECIPROCAL, REVERSE, SQRT};
    }
}

