/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.hierarchy;

import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.hierarchy.BreadthFirstIterator;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.hierarchy.HierarchyEvent;
import com.macrofocus.hierarchy.HierarchyListener;
import com.macrofocus.hierarchy.LeavesEnumeration;
import com.macrofocus.hierarchy.PostorderEnumeration;
import com.macrofocus.hierarchy.PreorderEnumeration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractHierarchy<T>
implements Hierarchy<T> {
    private transient List<HierarchyListener<T>> a;
    private boolean b = true;

    /*
     * WARNING - void declaration
     */
    @Override
    public void addHierarchyListener(HierarchyListener<T> listener) {
        void var1_1;
        if (this.a == null) {
            this.a = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();
        }
        this.a.add((HierarchyListener<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addWeakHierarchyListener(HierarchyListener<T> listener) {
        void var1_1;
        if (this.a == null) {
            this.a = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();
        }
        new a<T>(this, listener);
        this.a.add((HierarchyListener<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeHierarchyListener(HierarchyListener<T> hierarchyListener) {
        if (this.a != null) {
            void var1_1;
            this.a.remove(var1_1);
            if (this.a.isEmpty()) {
                this.a = null;
            }
        }
    }

    @Override
    public void removeHierarchyListeners() {
        if (this.a != null) {
            this.a.clear();
            if (this.a.isEmpty()) {
                this.a = null;
            }
        }
    }

    @Override
    public Iterable<HierarchyListener<T>> getListeners() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNotifyListeners(boolean enable) {
        this.b = enable;
        if (this.b) {
            void var1_1;
            this.b = enable;
            if (var1_1 != false) {
                this.notifyHierarchyStructureChanged();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isRoot(T node) {
        void var1_1;
        return this.getRoot() == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public T getNextSibling(T parent, T child) {
        void var2_2;
        Object object;
        object = parent == null ? null : this.getChildAfter(object, var2_2);
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNodeSibling(T aNode, T anotherNode) {
        void var2_3;
        void var1_1;
        if (anotherNode == null) return false;
        if (anotherNode == this) {
            return true;
        }
        if ((var1_1 = this.getParent(var1_1)) == null) return false;
        if (var1_1 != this.getParent(var2_3)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public T getPreviousSibling(T parent, T node) {
        void var2_2;
        Object object;
        object = parent == null ? null : this.getChildBefore(object, var2_2);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public T getChildAfter(T parent, T child) {
        void var2_2;
        if (child == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getIndexOfChild(parent, var2_2);
        if (n == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (n < this.getChildCount(parent) - 1) {
            void var1_1;
            return this.getChild(var1_1, n + 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public T getChildBefore(T parent, T child) {
        void var2_2;
        if (child == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getIndexOfChild(parent, var2_2);
        if (n == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (n > 0) {
            void var1_1;
            return this.getChild(var1_1, n - 1);
        }
        return null;
    }

    @Override
    public int getDepth() {
        T t = null;
        Object object = this.breadthFirstIterator();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            t = (T)e2;
            t = (T)e2;
        }
        if (t == null) {
            throw new Error("nodes should be null");
        }
        AbstractHierarchy abstractHierarchy = this;
        return this.getLevel(t) - abstractHierarchy.getLevel(abstractHierarchy.getRoot());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getLevel(T node) {
        void var1_1;
        int n = 0;
        while ((var1_1 = this.getParent(var1_1)) != null) {
            ++n;
        }
        return n;
    }

    @Override
    public List<T> getPath(T node) {
        Object[] objectArray;
        if ((objectArray = this.getPathToRoot(objectArray, 0)) != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                arrayList.add(object);
            }
            return arrayList;
        }
        return null;
    }

    public boolean isAncestor(T ancestor, T descendant) {
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = this.getParent(descendant);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void notifyHierarchyNodeInserted(T child, T parent, int index, boolean isAdjusting) {
        if (this.a != null && this.b) {
            void var3_3;
            Iterator<HierarchyListener<T>> iterator;
            HierarchyEvent<void> hierarchyEvent;
            hierarchyEvent = new HierarchyEvent<void>(this, HierarchyEvent.Type.Inserted, (void)hierarchyEvent, (void)iterator, (int)var3_3, isAdjusting);
            for (HierarchyListener<void> hierarchyListener : this.a) {
                hierarchyListener.hierarchyNodeInserted(hierarchyEvent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void notifyHierarchyNodeChanged(T child, T parent, int index, boolean isAdjusting) {
        if (this.a != null && this.b) {
            void var3_3;
            Iterator<HierarchyListener<T>> iterator;
            HierarchyEvent<void> hierarchyEvent;
            hierarchyEvent = new HierarchyEvent<void>(this, HierarchyEvent.Type.Changed, (void)hierarchyEvent, (void)iterator, (int)var3_3, isAdjusting);
            for (HierarchyListener<void> hierarchyListener : this.a) {
                hierarchyListener.hierarchyNodeChanged(hierarchyEvent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void notifyHierarchyNodeRemoved(T child, T parent, int index, boolean isAdjusting) {
        if (this.a != null && this.b) {
            void var3_3;
            Iterator<HierarchyListener<T>> iterator;
            HierarchyEvent<void> hierarchyEvent;
            hierarchyEvent = new HierarchyEvent<void>(this, HierarchyEvent.Type.Removed, (void)hierarchyEvent, (void)iterator, (int)var3_3, isAdjusting);
            for (HierarchyListener<void> hierarchyListener : this.a) {
                hierarchyListener.hierarchyNodeRemoved(hierarchyEvent);
            }
        }
    }

    protected void notifyHierarchyStructureChanged() {
        if (this.a != null && this.b) {
            HierarchyEvent<Object> hierarchyEvent = new HierarchyEvent<Object>(this, HierarchyEvent.Type.StructureChanged, null, null, -1, false);
            for (HierarchyListener<Object> hierarchyListener : this.a) {
                hierarchyListener.hierarchyStructureChanged(hierarchyEvent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<T> preorderIterator(T parent) {
        void var1_1;
        return new Iterable<T>(){
            private /* synthetic */ Object a;
            private /* synthetic */ AbstractHierarchy b;
            {
                this.b = abstractHierarchy;
                this.a = object;
            }

            @Override
            public final Iterator<T> iterator() {
                return new PreorderEnumeration<Object>(this.b, this.a);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<T> breadthFirstIterator(T parent) {
        void var1_1;
        return new Iterable<T>(){
            private /* synthetic */ Object a;
            private /* synthetic */ AbstractHierarchy b;
            {
                this.b = abstractHierarchy;
                this.a = object;
            }

            @Override
            public final Iterator<T> iterator() {
                return new BreadthFirstIterator<Object>(this.b, this.a);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<T> depthFirstIterator(T parent) {
        void var1_1;
        return new Iterable<T>(){
            private /* synthetic */ Object a;
            private /* synthetic */ AbstractHierarchy b;
            {
                this.b = abstractHierarchy;
                this.a = object;
            }

            @Override
            public final Iterator<T> iterator() {
                return new PostorderEnumeration<Object>(this.b, this.a);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<T> leavesIterator(T parent) {
        void var1_1;
        return new Iterable<T>(){
            private /* synthetic */ Object a;
            private /* synthetic */ AbstractHierarchy b;
            {
                this.b = abstractHierarchy;
                this.a = object;
            }

            @Override
            public final Iterator<T> iterator() {
                return new LeavesEnumeration<Object>(this.b, this.a);
            }
        };
    }

    @Override
    public Iterable<T> preorderIterator() {
        AbstractHierarchy abstractHierarchy = this;
        return abstractHierarchy.preorderIterator(abstractHierarchy.getRoot());
    }

    @Override
    public Iterable<T> breadthFirstIterator() {
        AbstractHierarchy abstractHierarchy = this;
        return abstractHierarchy.breadthFirstIterator(abstractHierarchy.getRoot());
    }

    @Override
    public Iterable<T> depthFirstIterator() {
        AbstractHierarchy abstractHierarchy = this;
        return abstractHierarchy.depthFirstIterator(abstractHierarchy.getRoot());
    }

    @Override
    public Iterable<T> leavesIterator() {
        AbstractHierarchy abstractHierarchy = this;
        return abstractHierarchy.leavesIterator(abstractHierarchy.getRoot());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] getPathToRoot(T aNode) {
        void var1_1;
        return this.getPathToRoot(var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNodeChild(T parent, T aNode) {
        void var1_1;
        void var2_3;
        boolean bl = aNode != null && this.getChildCount(parent) != 0 && this.getParent(var2_3) == var1_1;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public T getFirstChild(T node) {
        void var1_1;
        if (this.getChildCount(node) == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChild(var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public T getLastChild(T node) {
        void var1_1;
        if (this.getChildCount(node) == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChild(node, this.getChildCount(var1_1) - 1);
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] getPathToRoot(T aNode, int depth) {
        Object[] objectArray;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            objectArray = new Object[depth];
        } else {
            void var1_1;
            ++depth;
            if (aNode == this.getRoot()) {
                objectArray = new Object[depth];
            } else {
                AbstractHierarchy abstractHierarchy = this;
                objectArray = abstractHierarchy.getPathToRoot(abstractHierarchy.getParent(aNode), depth);
            }
            objectArray[objectArray.length - var2_2] = var1_1;
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isLeaf(T node) {
        void var1_1;
        return this.getChildCount(var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T getFirstLeaf(T node) {
        void var1_1;
        while (!this.isLeaf(node)) {
            node = this.getFirstChild(node);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T getLastLeaf(T node) {
        void var1_1;
        while (!this.isLeaf(node)) {
            node = this.getLastChild(node);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T getNextLeaf(T node) {
        void var1_1;
        T t = this.getParent(node);
        if (t == null) {
            return null;
        }
        if ((var1_1 = this.getNextSibling(t, var1_1)) != null) {
            return this.getFirstLeaf(var1_1);
        }
        return this.getNextLeaf(t);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T getPreviousLeaf(T node) {
        void var1_1;
        T t = this.getParent(node);
        if (t == null) {
            return null;
        }
        if ((var1_1 = this.getPreviousSibling(t, var1_1)) != null) {
            return this.getLastLeaf(var1_1);
        }
        return this.getPreviousLeaf(t);
    }

    @Override
    public int getLeafCount(T node) {
        Object object;
        int n = 0;
        object = this.breadthFirstIterator(object);
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (!this.isLeaf(e2)) continue;
            ++n;
        }
        if (n <= 0) {
            throw new Error("hierarchy has zero leaves");
        }
        return n;
    }

    public String toString() {
        int n = this.a != null ? this.a.size() : 0;
        return this.getClass().getName() + "[listeners=" + n + "]";
    }

    private final class a<E>
    implements HierarchyListener<E> {
        private final WeakReference<HierarchyListener<E>> a;
        private /* synthetic */ AbstractHierarchy b;

        public a(AbstractHierarchy abstractHierarchy, HierarchyListener<E> hierarchyListener) {
            this.b = abstractHierarchy;
            this.a = new WeakReference<HierarchyListener<E>>(hierarchyListener);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void hierarchyNodeInserted(HierarchyEvent<E> event) {
            HierarchyListener<E> hierarchyListener = this.a();
            if (hierarchyListener != null) {
                void var1_1;
                hierarchyListener.hierarchyNodeInserted((HierarchyEvent<E>)var1_1);
                return;
            }
            this.b.removeHierarchyListener(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void hierarchyNodeChanged(HierarchyEvent<E> event) {
            HierarchyListener<E> hierarchyListener = this.a();
            if (hierarchyListener != null) {
                void var1_1;
                hierarchyListener.hierarchyNodeChanged((HierarchyEvent<E>)var1_1);
                return;
            }
            this.b.removeHierarchyListener(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void hierarchyNodeRemoved(HierarchyEvent<E> event) {
            HierarchyListener<E> hierarchyListener = this.a();
            if (hierarchyListener != null) {
                void var1_1;
                hierarchyListener.hierarchyNodeRemoved((HierarchyEvent<E>)var1_1);
                return;
            }
            this.b.removeHierarchyListener(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void hierarchyStructureChanged(HierarchyEvent<E> event) {
            HierarchyListener<E> hierarchyListener = this.a();
            if (hierarchyListener != null) {
                void var1_1;
                hierarchyListener.hierarchyStructureChanged((HierarchyEvent<E>)var1_1);
                return;
            }
            this.b.removeHierarchyListener(this);
        }

        private HierarchyListener<E> a() {
            return (HierarchyListener)this.a.get();
        }

        public final String toString() {
            HierarchyListener<E> hierarchyListener = this.a();
            if (hierarchyListener != null) {
                return "Weak[" + String.valueOf(hierarchyListener) + "]";
            }
            return super.toString();
        }
    }
}

