/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.TableModelDataFrame;
import com.treemap.AbstractTreeMap;
import com.treemap.DefaultTreeMapModel;
import com.treemap.TreeMapController;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.swing.SwingTreeMapController;
import com.treemap.swing.SwingTreeMapView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SwingTreeMap<N, Row, Column>
extends AbstractTreeMap<JComponent, N, Row, Column, Color, Font> {
    private static final boolean USE_NATIVE_CONTROLLER = false;
    private final JComponent nativeComponent = new JComponent(){};

    public SwingTreeMap() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.nativeComponent.add((Component)this.view.getNativeComponent());
        this.nativeComponent.validate();
    }

    public SwingTreeMap(TreeMapModel<N, Row, Column, Color, Font> model) {
        this();
        this.setModel(model);
    }

    public SwingTreeMap(TableModel tableModel) {
        this();
        this.load((DataFrame<Row, Column, ?>)new TableModelDataFrame(tableModel));
    }

    public SwingTreeMap(DataFrame<Row, Column, ?> dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.TREEMAP_API, username, key);
    }

    void load(DataFrame<Row, Column, ?> dataFrame) {
        this.setModel(this.createTreeMapModel(dataFrame));
    }

    protected TreeMapModel<N, Row, Column, Color, Font> createTreeMapModel(DataFrame<Row, Column, ?> dataFrame) {
        return new DefaultTreeMapModel(dataFrame, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
    }

    protected TreeMapView<JComponent, N, Row, Column, Color, Font> createView() {
        SwingTreeMapView view = new SwingTreeMapView();
        return view;
    }

    protected TreeMapController<JComponent, N, Row, Column, Color, Font> createController(TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        return new SwingTreeMapController<N, Row, Column>(view);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        Object[][] data = new Object[][]{{"Hello", 12, 3.0}, {"from", 11, 4.0}, {"the", 9, 5.0}, {"TreeMap", 8, 6.0}, {"World!", 7, 7.0}};
        Object[] columnNames = new Object[]{"Name", "Value", "Strength"};
        final Class[] columnTypes = new Class[]{String.class, Integer.class, Double.class};
        DefaultTableModel tableModel = new DefaultTableModel(data, columnNames){
            private static final long serialVersionUID = -3806309739697751603L;

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnTypes[columnIndex];
            }
        };
        SwingTreeMap treeMap = new SwingTreeMap(tableModel);
        treeMap.setSizeByName("Value");
        treeMap.setColor(2);
        treeMap.setBackgroundByName("Name");
        treeMap.setLabels(new int[0]);
        ApplicationModel applicationModel = ApplicationModelFactory.TREEMAP_API;
        JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)treeMap.getNativeComponent());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

