/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPHelper;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.utils.TypeUtils;
import com.treemap.AbstractTreeMapNode;
import com.treemap.DefaultTreeMapModel;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.swing.AbstractTreeMapFieldComboBoxModel;
import com.treemap.swing.BackgroundComboBoxModel;
import com.treemap.swing.ColorComboBoxModel;
import com.treemap.swing.GroupByComboBoxModel;
import com.treemap.swing.HeightComboBoxModel;
import com.treemap.swing.SizeComboBoxModel;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ComboBoxModel;

public class SwingTreeMapModel<N extends AbstractTreeMapNode<N, Row, Column, Color, Font>, Row, Column>
extends DefaultTreeMapModel<N, Row, Column, Color, Font> {
    private ComboBoxModel groupByComboBoxModel;
    private ComboBoxModel labelComboBoxModel;
    private ComboBoxModel<TreeMapField> backgroundComboBoxModel;
    private ComboBoxModel<TreeMapField> sizeComboBoxModel;
    private ComboBoxModel<TreeMapField> heightComboBoxModel;
    private ComboBoxModel<TreeMapField> colorComboBoxModel;

    public SwingTreeMapModel(DataFrame<Row, Column, ?> dataFrame) {
        super(dataFrame, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
    }

    public ComboBoxModel getGroupByModel() {
        if (this.groupByComboBoxModel == null) {
            this.groupByComboBoxModel = this.createGroupByComboBoxModel();
        }
        return this.groupByComboBoxModel;
    }

    protected GroupByComboBoxModel createGroupByComboBoxModel() {
        return new GroupByComboBoxModel(this);
    }

    public ComboBoxModel getLabelModel() {
        if (this.labelComboBoxModel == null) {
            this.labelComboBoxModel = this.createLabelComboBoxModel();
        }
        return this.labelComboBoxModel;
    }

    protected LabelComboBoxModel createLabelComboBoxModel() {
        return new LabelComboBoxModel(this);
    }

    public ComboBoxModel<TreeMapField> getBackgroundModel() {
        if (this.backgroundComboBoxModel == null) {
            this.backgroundComboBoxModel = this.createBackgroundComboBoxModel();
        }
        return this.backgroundComboBoxModel;
    }

    protected ComboBoxModel<TreeMapField> createBackgroundComboBoxModel() {
        return new BackgroundComboBoxModel(this, (CPHelper)SwingFactory.getInstance());
    }

    public ComboBoxModel<TreeMapField> getSizeModel() {
        if (this.sizeComboBoxModel == null) {
            this.sizeComboBoxModel = this.createSizeComboBoxModel();
        }
        return this.sizeComboBoxModel;
    }

    protected ComboBoxModel<TreeMapField> createSizeComboBoxModel() {
        return new SizeComboBoxModel(this);
    }

    public ComboBoxModel<TreeMapField> getHeightModel() {
        if (this.heightComboBoxModel == null) {
            this.heightComboBoxModel = this.createHeightComboBoxModel();
        }
        return this.heightComboBoxModel;
    }

    protected ComboBoxModel<TreeMapField> createHeightComboBoxModel() {
        return new HeightComboBoxModel(this);
    }

    public ComboBoxModel<TreeMapField> getColorModel() {
        if (this.colorComboBoxModel == null) {
            this.colorComboBoxModel = this.createColorComboBoxModel();
        }
        return this.colorComboBoxModel;
    }

    protected ComboBoxModel<TreeMapField> createColorComboBoxModel() {
        return new ColorComboBoxModel(this);
    }

    public static class LabelComboBoxModel<N extends MutableTreeMapNode>
    extends AbstractTreeMapFieldComboBoxModel {
        public LabelComboBoxModel(TreeMapModel<N, ?, ?, ?, ?> treeMapModel) {
            super(treeMapModel, "labelsField", true);
        }

        @Override
        protected void updateComboBox() {
            TreeMapField[] selectedItems = this.treeMapModel.getSettings().getLabelTreeMapFields();
            if (selectedItems == null || selectedItems.length == 0) {
                this.setSelectedItem(this.none);
            } else if (selectedItems.length == 1) {
                this.setSelectedItem(selectedItems[0]);
            } else {
                this.setSelectedItem(selectedItems);
            }
        }

        @Override
        protected void updateTreeMap() {
            Object selectedItem = this.getSelectedItem();
            if (selectedItem instanceof Object[]) {
                Object[] selectedItems = (Object[])selectedItem;
                TreeMapField[] array = new TreeMapField[selectedItems.length];
                for (int i = 0; i < selectedItems.length; ++i) {
                    Object item = selectedItems[i];
                    array[i] = (TreeMapField)item;
                }
                this.treeMapModel.getSettings().setLabelTreeMapFields(array);
            } else {
                TreeMapField[] array = new TreeMapField[]{(TreeMapField)selectedItem};
                this.treeMapModel.getSettings().setLabelTreeMapFields(array);
            }
        }

        @Override
        protected boolean accept(TreeMapField field) {
            return !TypeUtils.isVisualType((Class)field.getType());
        }
    }
}

