/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.RoundRectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.Insets;
import com.macrofocus.igraphics.swing.SwingColor;
import com.treemap.AbstractTreeMapToolTip;
import com.treemap.TreeMapPopup;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import com.treemap.swing.JideTreeMapPopup;
import com.treemap.swing.SwingTreeMapPopup;
import com.treemap.swing.crossplatform.SwingTGraphics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;

public class SwingTreeMapToolTip<N, Row, Column>
extends AbstractTreeMapToolTip<N, Row, Column, JComponent, Color, Font> {
    private JComponent nativeComponent;
    private LineBorder border;
    private java.awt.Point mousePosition;
    private TreeMapToolTip.ToolTipType type = TreeMapToolTip.ToolTipType.Painted;
    private boolean redispatchMouseEvent = false;
    private transient MouseRedispatcher redispatcher = new MouseRedispatcher();

    public SwingTreeMapToolTip(final TreeMapView<JComponent, N, Row, Column, Color, Font> view) {
        super(view);
        this.nativeComponent = new JComponent(){

            @Override
            public synchronized void paintComponent(Graphics g) {
                SwingTGraphics g2 = new SwingTGraphics((Graphics2D)g);
                SwingTreeMapToolTip.this.paintBackground((TGraphics<Color, Font>)g2);
                super.paintComponent(g);
                SwingTreeMapToolTip.this.paintText((TGraphics)g2);
            }

            @Override
            public java.awt.Insets getInsets() {
                Insets insets = SwingTreeMapToolTip.this.getInsets();
                return new java.awt.Insets(insets.top, insets.left, insets.bottom, insets.right);
            }

            @Override
            public Border getBorder() {
                CPColor borderColor;
                Border superBorder = super.getBorder();
                if ((superBorder == null || superBorder instanceof BorderUIResource || superBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder")) && (borderColor = view.getModel().getSettings().getDefaultFieldSettings().getBorderColor()) != null) {
                    if (SwingTreeMapToolTip.this.border == null || SwingTreeMapToolTip.this.border.getLineColor() != borderColor) {
                        SwingTreeMapToolTip.this.border = new LineBorder((Color)borderColor.getNativeColor(), 1);
                    }
                    return SwingTreeMapToolTip.this.border;
                }
                return superBorder;
            }
        };
        this.nativeComponent.setOpaque(true);
        this.setRedispatchMouseEvent(true);
        this.nativeComponent.setBorder(BorderFactory.createEmptyBorder());
    }

    public void setRedispatchMouseEvent(boolean redispatchMouseEvent) {
        if (this.redispatchMouseEvent != redispatchMouseEvent) {
            this.redispatchMouseEvent = redispatchMouseEvent;
            if (redispatchMouseEvent) {
                this.nativeComponent.addMouseListener(this.redispatcher);
                this.nativeComponent.addMouseMotionListener(this.redispatcher);
                this.nativeComponent.addMouseWheelListener(this.redispatcher);
            } else {
                this.nativeComponent.removeMouseListener(this.redispatcher);
                this.nativeComponent.removeMouseMotionListener(this.redispatcher);
                this.nativeComponent.removeMouseWheelListener(this.redispatcher);
            }
        }
    }

    public void setBorder(Border border) {
        this.nativeComponent.setBorder(border);
    }

    public void setVisible(boolean visible) {
        this.nativeComponent.setVisible(visible);
    }

    public void setSize(Dimension d) {
        this.nativeComponent.setSize(d.width, d.height);
    }

    public int getWidth() {
        return this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return this.nativeComponent.getHeight();
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public void paintBackground(TGraphics<Color, Font> g) {
        Object background;
        if (this.nativeComponent.isOpaque() && (background = this.nativeComponent.getBackground() == null || this.nativeComponent.getBackground() instanceof UIResource ? this.view.getModel().getSettings().getTooltipBackground() : new SwingColor(this.nativeComponent.getBackground())) != null) {
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            Color endColor = new Color(background.getRed(), background.getGreen(), background.getBlue(), Math.max(0, background.getAlpha() - 50));
            g.setPaint((Paint)new GradientPaint(x, y, (Color)background.getNativeColor(), 0.0f, height, endColor));
            g.fill((Shape)new RoundRectangle2D.Double((double)x, (double)y, (double)width, (double)height, 10.0, 10.0));
            CPColor borderColor = this.getBorderColor();
            if (borderColor != null) {
                g.setStroke(borderColor);
                float borderThickness = insets.left;
                g.setLineWidth((double)borderThickness);
                g.strokeRoundRect((double)(borderThickness / 2.0f), (double)(borderThickness / 2.0f), (double)((float)this.getWidth() - borderThickness), (double)((float)this.getHeight() - borderThickness), 10.0, 10.0);
            }
        }
    }

    public Point getPreferredLocation() {
        return this.getPreferredLocation(this.mousePosition != null ? new Point(this.mousePosition.x, this.mousePosition.y) : null);
    }

    public TreeMapToolTip.ToolTipType getType() {
        return this.type;
    }

    public void setType(TreeMapToolTip.ToolTipType type) {
        if (this.type != type) {
            this.type = type;
            this.popup = null;
        }
    }

    public synchronized void showNode(N node) {
        if (this.node != node) {
            this.setNode(node);
            if (node != null) {
                TreeMapView view = this.getView();
                try {
                    this.mousePosition = ((JComponent)view.getNativeComponent()).getMousePosition();
                }
                catch (ClassCastException e) {
                    this.mousePosition = null;
                }
                catch (HeadlessException e) {
                    this.mousePosition = null;
                }
                catch (RuntimeException e) {
                    this.mousePosition = null;
                }
                Point tooltipPosition = this.getPreferredLocation();
                Dimension tooltipDimension = this.getPreferredSize(null);
                if (tooltipPosition != null && tooltipDimension != null && ((JComponent)view.getNativeComponent()).isShowing()) {
                    java.awt.Point p = ((JComponent)view.getNativeComponent()).getLocationOnScreen();
                    TreeMapPopup popup = this.getPopup();
                    if (popup != null) {
                        this.showPopup(p.x + tooltipPosition.x, p.y + tooltipPosition.y);
                    }
                }
            } else {
                this.hidePopup();
            }
            if (this.popup != null) {
                this.popup.repaint();
            }
        }
    }

    protected TreeMapPopup createPopup() {
        switch (this.type) {
            case Heavyweight: {
                JideTreeMapPopup popup = new JideTreeMapPopup();
                popup.putClientProperty("windowOpaque", Boolean.FALSE);
                popup.setPopupType(2);
                popup.setOpaque(false);
                popup.setFocusable(false);
                popup.setTransient(false);
                popup.setKeepPreviousSize(false);
                popup.setDefaultMoveOperation(1);
                popup.setPopupBorder(BorderFactory.createEmptyBorder());
                popup.getContentPane().setLayout(new BorderLayout());
                popup.getContentPane().add(this.nativeComponent);
                return popup;
            }
            case Lightweight: {
                JideTreeMapPopup popup = new JideTreeMapPopup();
                popup.putClientProperty("windowOpaque", Boolean.FALSE);
                popup.setPopupType(0);
                popup.setOpaque(false);
                popup.setFocusable(false);
                popup.setKeepPreviousSize(false);
                popup.setDefaultMoveOperation(-1);
                popup.setPopupBorder(BorderFactory.createEmptyBorder());
                popup.getContentPane().setLayout(new BorderLayout());
                popup.getContentPane().add(this.nativeComponent);
                return popup;
            }
            case Painted: {
                SwingTreeMapPopup popup = new SwingTreeMapPopup();
                return popup;
            }
        }
        throw new IllegalArgumentException();
    }

    protected class MouseRedispatcher
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        protected MouseRedispatcher() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        private void dispatchMouseEvent(MouseEvent evt) {
            ((JComponent)SwingTreeMapToolTip.this.getView().getNativeComponent()).dispatchEvent(SwingUtilities.convertMouseEvent(evt.getComponent(), evt, (Component)SwingTreeMapToolTip.this.getView().getNativeComponent()));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.dispatchMouseEvent(e);
        }
    }
}

