/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.crossplatform;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Polygon;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPImage;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.swing.SwingIGraphics;
import com.macrofocus.labeling.EnhancedJLabelRenderer;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.crossplatform.AbstractTGraphics;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.swing.crossplatform.AffineTransformHelper;
import com.treemap.swing.crossplatform.EnhancedJLabelPreferredSize;
import com.treemap.swing.crossplatform.ShapeShape;
import com.treemap.swing.crossplatform.SwingPreferredSize;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.swing.CellRendererPane;

public class SwingTGraphics
extends AbstractTGraphics<Color, Font> {
    private static final Clipping clipping = Clipping.Auto;
    private CPColor<Color> fill;
    private CPColor<Color> stroke;
    private final Stack<Graphics2D> stack = new Stack();
    private final EnhancedJLabelRenderer component = new EnhancedJLabelRenderer();
    private final SwingPreferredSize preferredSize = new SwingPreferredSize((Component)this.component);
    private static CellRendererPane cellRendererPane = new CellRendererPane();
    public Graphics2D gc;
    private boolean paintingForPrint = false;

    public SwingTGraphics(Graphics2D gc) {
        this.gc = gc;
    }

    public CPColorFactory<Color> getColorFactory() {
        return SwingFactory.getInstance();
    }

    public void paintLabel(EnhancedLabel<Color, Font> l, int x, int y, int w, int h) {
        this.component.setData(l);
        cellRendererPane.paintComponent(this.gc, (Component)this.component, null, x, y, w, h);
    }

    public PreferredSize sizeLabel(EnhancedLabel<Color, Font> l, int w, int h) {
        this.component.setData(l);
        return new EnhancedJLabelPreferredSize(this.gc, this.component);
    }

    public void save() {
        this.stack.push(this.gc);
        this.gc = (Graphics2D)this.gc.create();
    }

    public void restore() {
        this.gc.dispose();
        this.gc = this.stack.pop();
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.gc.draw3DRect(x, y, width, height, raised);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.gc.fill3DRect(x, y, width, height, raised);
    }

    public void stroke(Shape s) {
        if (s instanceof Rectangle) {
            Rectangle r = (Rectangle)s;
            this.gc.drawRect(r.x, r.y, r.width, r.height);
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.strokeRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D r = (Ellipse2D)s;
            this.gc.draw(new Ellipse2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else {
            this.gc.draw(new ShapeShape(s));
        }
    }

    public void fillText(String str, int x, int y) {
        this.gc.drawString(str, x, y);
    }

    public void fillText(String str, float x, float y) {
        this.gc.drawString(str, x, y);
    }

    public void fill(Shape s) {
        if (s instanceof Rectangle) {
            Rectangle r = (Rectangle)s;
            this.gc.fillRect(r.x, r.y, r.width, r.height);
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D r = (Ellipse2D)s;
            this.gc.fill(new Ellipse2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else {
            this.gc.fill(new ShapeShape(s));
        }
    }

    public void setPaint(Paint paint) {
        this.gc.setPaint(paint);
    }

    public void setLineWidth(double lw) {
        this.gc.setStroke(new BasicStroke((float)lw));
    }

    public void setLineDash(double[] dashPattern) {
        BasicStroke viewportStroke = new BasicStroke(1.0f, 0, 0, 10.0f, SwingTGraphics.floatToDoubleArray(dashPattern), 0.0f);
        this.gc.setStroke(viewportStroke);
    }

    private static float[] floatToDoubleArray(double[] f) {
        if (f == null) {
            return null;
        }
        float[] d = new float[f.length];
        for (int i = 0; i < f.length; ++i) {
            d[i] = (float)f[i];
        }
        return d;
    }

    public boolean isInterpolationBilinear() {
        return this.gc.getRenderingHint(RenderingHints.KEY_INTERPOLATION) == RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    }

    public void setInterpolationBilinear(boolean bilinear) {
        this.gc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public boolean isAntialias() {
        return this.gc.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public void setAntialias(boolean antialias) {
        this.gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public boolean isTextAntialias() {
        return this.gc.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public void setTextAntialias(boolean antialias) {
        this.gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void translate(int x, int y) {
        this.gc.translate(x, y);
    }

    public void translate(double tx, double ty) {
        this.gc.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.gc.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.gc.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.gc.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.gc.shear(shx, shy);
    }

    public void transform(AffineTransform Tx) {
        this.gc.transform(AffineTransformHelper.from(Tx));
    }

    public void setTransform(AffineTransform Tx) {
        this.gc.setTransform(AffineTransformHelper.from(Tx));
    }

    public AffineTransform getTransform() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setGlobalAlpha(double alpha) {
        this.gc.setComposite(AlphaComposite.getInstance(3, (float)alpha));
    }

    public void setBackground(CPColor<Color> color) {
        this.gc.setBackground((Color)color.getNativeColor());
    }

    public Color getBackground() {
        return this.gc.getBackground();
    }

    public void clip(Shape s) {
        if (s instanceof Rectangle) {
            Rectangle r = (Rectangle)s;
            this.gc.clip(new java.awt.Rectangle(r.x, r.y, r.width, r.height));
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.clip(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else {
            this.gc.clip(new ShapeShape(s));
        }
    }

    public void setFill(CPColor<Color> c) {
        this.fill = c;
        this.gc.setColor((Color)c.getNativeColor());
    }

    public void setStroke(CPColor<Color> c) {
        this.stroke = c;
        this.gc.setColor((Color)c.getNativeColor());
    }

    public void setColor(CPColor<Color> c) {
        this.gc.setColor((Color)c.getNativeColor());
    }

    public void setRadialGradient() {
    }

    public boolean isPaintingForPrint() {
        return this.paintingForPrint || "org.apache.batik.svggen.SVGGraphics2D".equals(this.gc.getClass().getCanonicalName());
    }

    public void setPaintingForPrint(boolean paintingForPrint) {
        this.paintingForPrint = paintingForPrint;
    }

    public Object getNativeGraphics() {
        return this.gc;
    }

    public IGraphics<Color, Font> getIGraphics() {
        return new SwingIGraphics(this.gc);
    }

    public Font getFont() {
        return this.gc.getFont();
    }

    public void setFont(Font font) {
        this.gc.setFont(font);
    }

    public double getStringWidth(String text) {
        if (text != null) {
            return this.gc.getFontMetrics().getStringBounds(text, this.gc).getWidth();
        }
        return 0.0;
    }

    public void strokeLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.gc.fillRect(x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.gc.drawRect(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.gc.clearRect(x, y, width, height);
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.gc.draw(new Rectangle2D.Double(x, y, width, height));
    }

    public void fillRect(double x, double y, double width, double height) {
        this.gc.fill(new Rectangle2D.Double(x, y, width, height));
    }

    public void strokeRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.gc.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.gc.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(Polygon p) {
        this.gc.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.gc.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(Polygon p) {
        this.gc.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public BufferedImage createImage(int width, int height) {
        GraphicsConfiguration gc = this.gc.getDeviceConfiguration();
        BufferedImage img = gc != null ? gc.createCompatibleImage(width, height, 3) : new BufferedImage(width, height, 2);
        return img;
    }

    public boolean drawNativeImage(Image img, int x, int y) {
        return this.gc.drawImage(img, x, y, null);
    }

    public boolean drawImage(CPImage img, int x, int y) {
        return this.gc.drawImage((Image)img.getNativeImage(), x, y, null);
    }

    public boolean drawImage(CPImage img, int x, int y, int width, int height) {
        if (img.getWidth() == width && img.getHeight() == height) {
            return this.drawImage(img, x, y);
        }
        return this.gc.drawImage((Image)img.getNativeImage(), x, y, width, height, null);
    }

    public void finalize() {
        this.gc.finalize();
    }

    public String toString() {
        return this.gc.toString();
    }

    @Deprecated
    public Rectangle getClipRect() {
        java.awt.Rectangle clipRect = this.gc.getClipRect();
        return new Rectangle(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.gc.hitClip(x, y, width, height);
    }

    public Rectangle getClipBounds(Rectangle r) {
        java.awt.Rectangle clipBounds = this.gc.getClipBounds();
        return new Rectangle(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
    }

    public boolean drawClippedImage(CPImage img, int x, int y, int w, int h, int width, int height, Rectangle bounds, Shape shape) {
        boolean hardClipping;
        switch (clipping.ordinal()) {
            case 0: {
                hardClipping = true;
                break;
            }
            case 1: {
                hardClipping = false;
                break;
            }
            default: {
                boolean bl = hardClipping = this.gc.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_OFF;
            }
        }
        if (hardClipping) {
            return super.drawClippedImage(img, x, y, w, h, width, height, bounds, shape);
        }
        BufferedImage image = this.createImage(width, height);
        Graphics2D ig = image.createGraphics();
        ig.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ig.setComposite(AlphaComposite.Clear);
        ig.fillRect(0, 0, width, height);
        ig.setComposite(AlphaComposite.Src);
        ig.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ig.setColor(Color.white);
        AffineTransform instance = AffineTransform.getTranslateInstance((double)(-shape.getBounds2D().getX()), (double)(-shape.getBounds2D().getY()));
        Shape translatedShape = instance.createTransformedShape(shape);
        AffineTransform scale = AffineTransform.getScaleInstance((double)((double)width / bounds.getWidth()), (double)((double)height / bounds.getHeight()));
        ig.fill(new ShapeShape(scale.createTransformedShape(translatedShape)));
        ig.setComposite(AlphaComposite.SrcAtop);
        ig.drawImage((Image)img.getNativeImage(), 0, 0, width, height, null);
        ig.dispose();
        return this.gc.drawImage(image, x, y, width, height, null);
    }

    public void softClip(Shape shape) {
        this.clip(shape);
    }

    public boolean hitClip(Rectangle bounds) {
        return this.gc.hitClip(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private static enum Clipping {
        Hard,
        Soft,
        Auto;

    }
}

