/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi;

import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.swing.fastvoronoi.OriginalVoronoiDiagram;
import com.treemap.swing.fastvoronoi.Site;
import com.treemap.swing.fastvoronoi.VoronoiDiagram;
import com.treemap.swing.fastvoronoi.convexhull.ConflictList;
import com.treemap.swing.fastvoronoi.convexhull.ConvexHull;
import com.treemap.swing.fastvoronoi.convexhull.Edge;
import com.treemap.swing.fastvoronoi.convexhull.Facet;
import com.treemap.swing.fastvoronoi.convexhull.Vertex;
import com.treemap.swing.fastvoronoi.polygon.PolygonSimple;
import java.util.ArrayList;

public class SimpleVoronoiDiagram
implements VoronoiDiagram {
    private Shape[] clippedPolygons;
    private Shape[] polygons;
    public ConvexHull hull;

    public SimpleVoronoiDiagram(Shape shape, Site[] sites, double[] weights) {
        PolygonSimple rootPolygon;
        if (!(shape instanceof PolygonSimple)) {
            rootPolygon = new PolygonSimple();
            double x = shape.getBounds2D().getX();
            double y = shape.getBounds2D().getY();
            double width = shape.getBounds2D().getWidth();
            double height = shape.getBounds2D().getHeight();
            rootPolygon.add(x, y);
            rootPolygon.add(width, y);
            rootPolygon.add(width, height);
            rootPolygon.add(y, height);
        } else {
            rootPolygon = (PolygonSimple)shape;
        }
        this.hull = new ConvexHull();
        for (int i = 0; i < sites.length; ++i) {
            Site site = sites[i];
            Vertex v = this.createVertex(site.getPosition().getX(), site.getPosition().getY(), weights[i]);
            v.site = site;
            this.hull.addVertex(v);
            v.setData(new ConflictList(false));
        }
        Rectangle2D bb = shape.getBounds2D();
        double minX = bb.getMinX();
        double minY = bb.getMinY();
        double width = bb.getWidth();
        double height = bb.getHeight();
        Vertex v1 = this.createVertex(minX - width, minY - height, 1.0E-10);
        this.hull.addVertex(v1);
        Vertex v2 = this.createVertex(minX + 2.0 * width, minY - height, 1.0E-10);
        this.hull.addVertex(v2);
        Vertex v3 = this.createVertex(minX + 2.0 * width, minY + 2.0 * height, 1.0E-10);
        this.hull.addVertex(v3);
        Vertex v4 = this.createVertex(minX - width, minY + 2.0 * height, 1.0E-10);
        this.hull.addVertex(v4);
        v1.setData(new ConflictList(false));
        v2.setData(new ConflictList(false));
        v3.setData(new ConflictList(false));
        v4.setData(new ConflictList(false));
        this.hull.compute();
        this.polygons = new Shape[sites.length];
        this.clippedPolygons = new Shape[sites.length];
        int vertexCount = this.hull.getVertexCount();
        boolean[] verticesVisited = new boolean[vertexCount];
        for (int i = 0; i < this.hull.getFacetCount(); ++i) {
            Facet facet = this.hull.getFacet(i);
            if (!this.isVisibleFromBelow(facet)) continue;
            for (int e = 0; e < 3; ++e) {
                Edge edge = facet.getEdge(e);
                Vertex destVertex = edge.getDest();
                if (verticesVisited[destVertex.getIndex()]) continue;
                verticesVisited[destVertex.getIndex()] = true;
                if (destVertex.site == null) continue;
                ArrayList<Facet> faces = this.getFacesOfDestVertex(edge);
                PolygonSimple poly = new PolygonSimple();
                for (Facet face : faces) {
                    Point2D point = this.getDual(face);
                    double x1 = point.getX();
                    double y1 = point.getY();
                    poly.add(x1, y1);
                }
                if (destVertex.site == null) continue;
                this.polygons[destVertex.getIndex()] = poly;
                this.clippedPolygons[destVertex.getIndex()] = rootPolygon.convexClip(poly);
            }
        }
    }

    private Vertex createVertex(double x, double y, double weight) {
        double z = x * x + y * y - weight;
        return new Vertex(x, y, z);
    }

    @Override
    public Shape getPolygon(int i) {
        return this.polygons[i];
    }

    @Override
    public Shape getClippedPolygon(int i) {
        return this.clippedPolygons[i];
    }

    private ArrayList<Facet> getFacesOfDestVertex(Edge edge) {
        ArrayList<Facet> faces = new ArrayList<Facet>();
        Edge previous = edge;
        do {
            Facet iFace;
            if (!this.isVisibleFromBelow(iFace = (previous = previous.getTwin().getPrev()).getFacet())) continue;
            faces.add(iFace);
        } while (previous != edge);
        return faces;
    }

    public boolean isVisibleFromBelow(Facet face) {
        return face.getNormal().z < -1.4259414393190911E-9;
    }

    public Point2D getDual(Facet facet) {
        Vertex p1 = facet.getVertex(0);
        Vertex p2 = facet.getVertex(1);
        Vertex p3 = facet.getVertex(2);
        double a = p1.y * (p2.z - p3.z) + p2.y * (p3.z - p1.z) + p3.y * (p1.z - p2.z);
        double b = p1.z * (p2.x - p3.x) + p2.z * (p3.x - p1.x) + p3.z * (p1.x - p2.x);
        double c = p1.x * (p2.y - p3.y) + p2.x * (p3.y - p1.y) + p3.x * (p1.y - p2.y);
        double d = -1.0 * (p1.x * (p2.y * p3.z - p3.y * p2.z) + p2.x * (p3.y * p1.z - p1.y * p3.z) + p3.x * (p1.y * p2.z - p2.y * p1.z));
        double[] res = new double[]{-1.0 * (a / c), -1.0 * (b / c), -1.0 * (d / c)};
        Point2D.Double dualPoint = new Point2D.Double(res[0] / 2.0, res[1] / 2.0);
        return dualPoint;
    }

    public static void main(String[] args) {
        Site site;
        int i;
        System.err.println("Original");
        Site[] sites = SimpleVoronoiDiagram.createSites();
        VoronoiDiagram pd = new OriginalVoronoiDiagram((Shape)new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0), sites, SimpleVoronoiDiagram.createWeights());
        for (i = 0; i < ((OriginalVoronoiDiagram)pd).diagram.hull.getVertexCount(); ++i) {
            System.err.println("Vertex " + i + ": " + String.valueOf(((OriginalVoronoiDiagram)pd).diagram.hull.getVertex(i)));
        }
        for (i = 0; i < sites.length; ++i) {
            site = sites[i];
            System.err.println("Polygon " + i + ": " + String.valueOf(((OriginalVoronoiDiagram)pd).getPolygon(i)));
        }
        for (i = 0; i < ((OriginalVoronoiDiagram)pd).diagram.hull.getFacetCount(); ++i) {
            System.err.println("Facet " + i + ": " + String.valueOf(((OriginalVoronoiDiagram)pd).diagram.hull.getFacet(i)));
        }
        System.err.println("Reimplementation");
        sites = SimpleVoronoiDiagram.createSites();
        pd = new SimpleVoronoiDiagram((Shape)new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0), sites, SimpleVoronoiDiagram.createWeights());
        for (i = 0; i < ((SimpleVoronoiDiagram)pd).hull.getVertexCount(); ++i) {
            System.err.println("Vertex " + i + ": " + String.valueOf(((SimpleVoronoiDiagram)pd).hull.getVertex(i)));
        }
        for (i = 0; i < sites.length; ++i) {
            site = sites[i];
            System.err.println(i + ": " + String.valueOf(((SimpleVoronoiDiagram)pd).getPolygon(i)));
        }
        for (i = 0; i < ((SimpleVoronoiDiagram)pd).hull.getFacetCount(); ++i) {
            System.err.println("Facet " + i + ": " + String.valueOf(((SimpleVoronoiDiagram)pd).hull.getFacet(i)));
        }
    }

    public static Site[] createSites() {
        return new Site[]{new Site((Point2D)new Point2D.Double(100.0, 100.0)), new Site((Point2D)new Point2D.Double(200.0, 200.0)), new Site((Point2D)new Point2D.Double(300.0, 300.0)), new Site((Point2D)new Point2D.Double(400.0, 400.0))};
    }

    public static double[] createWeights() {
        return new double[]{50.0, 100.0, 200.0, 400.0};
    }
}

