/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.convexhull;

import com.treemap.swing.fastvoronoi.Site;
import com.treemap.swing.fastvoronoi.convexhull.Face;
import com.treemap.swing.fastvoronoi.convexhull.Vector;

public class Vertex
extends Face {
    public double x;
    public double y;
    public double z;
    public Site site;
    private static final double epsilon = 1.0E-10;

    public Vertex() {
        this(0.0, 0.0, 0.0);
    }

    public Vertex(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Vector subtract(Vertex a, Vertex b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public boolean linearDependent(Vertex v) {
        if (this.x == 0.0 && v.x == 0.0) {
            if (this.y == 0.0 && v.y == 0.0) {
                if (this.z == 0.0 && v.z == 0.0) {
                    return true;
                }
                return this.z != 0.0 && v.y != 0.0;
            }
            if (this.y == 0.0 || v.y == 0.0) {
                return false;
            }
            return this.z / this.y >= v.z / v.y - 1.0E-10 && this.z / this.y <= v.z / v.y + 1.0E-10;
        }
        if (this.x == 0.0 || v.x == 0.0) {
            return false;
        }
        return this.y / this.x <= v.y / v.x + 1.0E-10 && this.y / this.x >= v.y / v.x - 1.0E-10 && this.z / this.x >= v.y / v.x - 1.0E-10 && this.z / this.x <= v.z / v.x + 1.0E-10;
    }

    public String toString() {
        return "Vertex{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

