/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.j2d;

public class Point2D {
    public double x;
    public double y;

    public Point2D() {
    }

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    public double distance(double px, double py) {
        return Math.sqrt((px -= this.x) * px + (py -= this.y) * py);
    }

    public double distance(Point2D point) {
        return this.distance(point.x, point.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public final void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public final double dot(Point2D vector2d) {
        return this.x * vector2d.x + this.y * vector2d.y;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final void normalize(Point2D vector2d) {
        double d = 1.0 / Math.sqrt(vector2d.x * vector2d.x + vector2d.y * vector2d.y);
        this.x = vector2d.x * d;
        this.y = vector2d.y * d;
    }

    public final void normalize() {
        double d = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x *= d;
        this.y *= d;
    }

    public final double angle(Point2D vector2d) {
        double d = this.dot(vector2d) / (this.length() * vector2d.length());
        if (d < -1.0) {
            d = -1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return Math.acos(d);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }
}

