/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.j3d;

import com.treemap.swing.originalfastvoronoi.convexHull.JFace;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j3d.Point3d;

public class Plane3D {
    public final double a;
    public final double b;
    public final double c;
    public final double d;

    public Plane3D(Point3d p1, Point3d p2, Point3d p3) {
        this.a = p1.y * (p2.z - p3.z) + p2.y * (p3.z - p1.z) + p3.y * (p1.z - p2.z);
        this.b = p1.z * (p2.x - p3.x) + p2.z * (p3.x - p1.x) + p3.z * (p1.x - p2.x);
        this.c = p1.x * (p2.y - p3.y) + p2.x * (p3.y - p1.y) + p3.x * (p1.y - p2.y);
        this.d = -1.0 * (p1.x * (p2.y * p3.z - p3.y * p2.z) + p2.x * (p3.y * p1.z - p1.y * p3.z) + p3.x * (p1.y * p2.z - p2.y * p1.z));
    }

    public Plane3D(JFace jFace) {
        this(jFace.getVertex(0).toPoint3D(), jFace.getVertex(1).toPoint3D(), jFace.getVertex(2).toPoint3D());
    }

    protected double[] getNormZPlane() {
        double[] res = new double[]{-1.0 * (this.a / this.c), -1.0 * (this.b / this.c), -1.0 * (this.d / this.c)};
        return res;
    }

    public Point2D getDualPointMappedToPlane() {
        double[] nPlane = this.getNormZPlane();
        Point2D dualPoint = new Point2D(nPlane[0] / 2.0, nPlane[1] / 2.0);
        return dualPoint;
    }
}

