/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.plaf.basic;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.TreeMapToolTip;
import com.treemap.crossplatform.TGraphics;
import com.treemap.swing.crossplatform.SwingTGraphics;
import com.treemap.swing.plaf.TreePlotUI;
import com.treemap.swing.plaf.basic.ComponentPainter;
import com.treemap.swing.treeplot.SwingTreePlotToolTip;
import com.treemap.swing.treeplot.SwingTreePlotView;
import com.treemap.treeplot.TreePlotRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;

public class BasicTreePlotUI
extends TreePlotUI {
    private final boolean progressive = false;
    private boolean needsProgressive = true;
    private final ExecutorService _executor = SwingFactory.getInstance().newFixedThreadPool(this.getSelf().getClass().getSimpleName(), 0, 1);
    private FutureTask workerProgress;
    private BufferedImage img;

    @Override
    public void paint(Graphics g, JComponent c) {
        com.macrofocus.common.geom.Dimension tooltipDimension;
        Point tooltipPosition;
        SwingTreePlotView.NativeComponent nativeComponent = (SwingTreePlotView.NativeComponent)c;
        SwingTreePlotView view = nativeComponent.getTreeMapView();
        long current = System.currentTimeMillis();
        Graphics2D g2 = (Graphics2D)g;
        if (view.getRenderingHints() != null) {
            g2.setRenderingHints(view.getRenderingHints());
        }
        SwingTGraphics tg = new SwingTGraphics(g2);
        tg.setPaintingForPrint(c.isPaintingForPrint());
        Dimension d = nativeComponent.getSize();
        boolean paintingForPrint = false;
        try {
            paintingForPrint = nativeComponent.isPaintingForPrint();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        for (TreePlotRenderer renderer : view.getProgressiveRenderers()) {
            renderer.paint((TGraphics)tg, view, null);
        }
        for (TreePlotRenderer renderer : view.getRenderers()) {
            renderer.paint((TGraphics)tg, view, null);
        }
        SwingTreePlotToolTip toolTip = (SwingTreePlotToolTip)view.getToolTip();
        if (toolTip != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
            tooltipPosition = toolTip.getPopupLocation();
            tooltipDimension = toolTip.getPreferredSize((TGraphics<Color, Font>)tg);
            if (tooltipPosition != null && tooltipDimension != null) {
                ComponentPainter.getInstance().paintComponent(tg, toolTip.getNativeComponent(), nativeComponent, tooltipPosition.x, tooltipPosition.y, tooltipDimension.width, tooltipDimension.height);
            }
        }
        if ((toolTip = (SwingTreePlotToolTip)view.getSelectionToolTip()) != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
            tooltipPosition = toolTip.getPreferredLocation();
            tooltipDimension = toolTip.getPreferredSize((TGraphics<Color, Font>)tg);
            if (tooltipPosition != null && tooltipDimension != null) {
                ComponentPainter.getInstance().paintComponent(tg, toolTip.getNativeComponent(), nativeComponent, tooltipPosition.x, tooltipPosition.y, tooltipDimension.width, tooltipDimension.height);
            }
        }
        if (view.getRubberBand().getRubberBand().isActive()) {
            tg.save();
            tg.setStroke(SwingFactory.getInstance().getBlack());
            double[] dashPattern = new double[]{10.0, 2.0, 2.0, 2.0};
            tg.setLineWidth(1.0);
            tg.setLineDash(dashPattern);
            Rectangle2D rect = view.getRubberBand().getRubberBandScreen();
            tg.stroke((Shape)rect);
            tg.restore();
        }
        if (view.isShowTiming()) {
            tg.setFill(SwingFactory.getInstance().getRed());
            tg.fillText(System.currentTimeMillis() - current + " milliseconds", 5, nativeComponent.getSize().height - 5);
        }
    }

    private BasicTreePlotUI getSelf() {
        return this;
    }
}

