/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.macrofocus.geom.Polygon;
import com.macrofocus.geom.Shape;
import com.treemap.MutableTreeMapNode;
import com.treemap.swing.voronoi.MarchingSquares;
import com.treemap.swing.voronoi.Path;
import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.Point2i;
import com.treemap.swing.voronoi.VoronoiAlgorithm;
import com.treemap.swing.voronoi.VoronoiCell;
import com.treemap.swing.voronoi.VoronoiOutputRaster;
import com.treemap.swing.voronoi.smoothing.Direction;
import com.treemap.swing.voronoi.smoothing.DoubleSpline;
import com.treemap.swing.voronoi.smoothing.LineSegment;
import com.treemap.swing.voronoi.smoothing.LineSegmentContainer;
import com.treemap.swing.voronoi.smoothing.LinearSegment;
import com.treemap.swing.voronoi.smoothing.SegmentDirection;
import com.treemap.swing.voronoi.smoothing.SegmentLocation;
import com.treemap.swing.voronoi.smoothing.SmoothVoronoiCellShape;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.Smoother;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShapeConverter {
    private static final Point2i polygonPoint = new Point2i();

    public static void getShapeByMarchingSquares(VoronoiCell[] cells, VoronoiOutputRaster outputRaster, List<Vertex> vertexes, Shape parent) {
        LineSegmentContainer segmentContainer = new LineSegmentContainer();
        if (vertexes == null) {
            for (VoronoiCell cell : cells) {
                MarchingSquares marchingSquares = new MarchingSquares(outputRaster.getWidth(), outputRaster.getHeight(), cell, outputRaster);
                Path path = marchingSquares.identifyPerimeter();
                if (path != null) {
                    Polygon polygon = new Polygon();
                    int x = path.getOriginX();
                    int y = path.getOriginY();
                    polygon.addPoint(x, y);
                    for (Direction direction : path.getDirections()) {
                        polygon.addPoint(x += direction.screenX, y += direction.screenY);
                    }
                    cell.getChild().setShape((Shape)polygon);
                    continue;
                }
                cell.getChild().setShape(null);
            }
        } else {
            for (VoronoiCell cell : cells) {
                LinkedHashMap<LineSegment, SegmentDirection> lineSegmentDirectionMap = new LinkedHashMap<LineSegment, SegmentDirection>();
                MarchingSquares marchingSquares = new MarchingSquares(outputRaster.getWidth(), outputRaster.getHeight(), cell, outputRaster);
                Path path = marchingSquares.identifyPerimeter();
                if (path != null) {
                    LineSegment lineSegment;
                    Polygon polygon = new Polygon();
                    int x = path.getOriginX();
                    int y = path.getOriginY();
                    polygon.addPoint(x, y);
                    for (Direction direction : path.getDirections()) {
                        polygon.addPoint(x += direction.screenX, y += direction.screenY);
                    }
                    HashMap<Point2i, Vertex> pointVertexMap = new HashMap<Point2i, Vertex>(vertexes.size());
                    for (Vertex vertex : vertexes) {
                        double minDistSquared = Double.MAX_VALUE;
                        Point2i nearestPoint = new Point2i();
                        Point2i point = new Point2i();
                        Point2d point2d = new Point2d();
                        for (int nPolygonPoint = 0; nPolygonPoint < polygon.npoints; ++nPolygonPoint) {
                            point.set(polygon.xpoints[nPolygonPoint], polygon.ypoints[nPolygonPoint]);
                            point2d.set(point.x, point.y);
                            double distanceSquared = vertex.getLocation().distanceSquared(point2d);
                            if (!(distanceSquared < minDistSquared)) continue;
                            nearestPoint.set(point);
                            minDistSquared = distanceSquared;
                        }
                        if (!(minDistSquared < 4.0)) continue;
                        pointVertexMap.put(nearestPoint, vertex);
                    }
                    LineSegment currentSegment = lineSegment = new LineSegment();
                    Vertex vertexLocation = ShapeConverter.getVertexByMap(x, y, pointVertexMap);
                    if (vertexLocation != null) {
                        currentSegment.setStartVertex(vertexLocation);
                    }
                    Enum prevDirection = null;
                    int dirChanges = 0;
                    for (Direction direction : path.getDirections()) {
                        x += direction.screenX;
                        y += direction.screenY;
                        if (prevDirection != null && !prevDirection.equals((Object)direction)) {
                            ++dirChanges;
                        }
                        if ((vertexLocation = ShapeConverter.getVertexByMap(x, y, pointVertexMap)) != null && !vertexLocation.equals(currentSegment.getStartVertex())) {
                            currentSegment.setEndVertex(vertexLocation);
                            boolean straight = ShapeConverter.isStraight(dirChanges);
                            currentSegment.setStraight(straight);
                            if (currentSegment.getStartVertex() != null) {
                                ShapeConverter.addToContainerAndMap(currentSegment, segmentContainer, lineSegmentDirectionMap);
                            }
                            currentSegment = new LineSegment();
                            currentSegment.setStartVertex(vertexLocation);
                            dirChanges = 0;
                        } else {
                            currentSegment.addPoint(x, y);
                        }
                        prevDirection = direction;
                    }
                    if (lineSegment.getStartVertex() == null) {
                        lineSegment.setStartVertex(currentSegment.getStartVertex());
                        lineSegment.insertPointsAtStart(currentSegment.getPoints());
                        lineSegment.setStraight(ShapeConverter.isStraight(dirChanges));
                        ShapeConverter.addToContainerAndMap(lineSegment, segmentContainer, lineSegmentDirectionMap);
                    }
                    ArrayList<Vertex> cornersOfChild = new ArrayList<Vertex>(vertexes.size());
                    int nSegements = lineSegmentDirectionMap.size();
                    ArrayList<SmoothedSegment> smoothedSegments = new ArrayList<SmoothedSegment>(nSegements){

                        @Override
                        public boolean add(SmoothedSegment smoothedSegment) {
                            boolean b = super.add(smoothedSegment);
                            if (smoothedSegment == null) {
                                // empty if block
                            }
                            return b;
                        }
                    };
                    for (Map.Entry lineSegmentDirMapEntry : lineSegmentDirectionMap.entrySet()) {
                        LineSegment currentLineSegment = (LineSegment)lineSegmentDirMapEntry.getKey();
                        Vertex startVertex = currentLineSegment.getStartVertex();
                        Vertex endVertex = currentLineSegment.getEndVertex();
                        if (!cornersOfChild.contains(startVertex)) {
                            cornersOfChild.add(startVertex);
                        }
                        if (!cornersOfChild.contains(endVertex)) {
                            cornersOfChild.add(endVertex);
                        }
                        if (startVertex != null && endVertex != null && !currentLineSegment.isStraight() && startVertex.isTouchingParentSpline() && endVertex.isTouchingParentSpline() && parent instanceof SmoothVoronoiCellShape) {
                            SmoothedSegment nearestSegment;
                            SegmentLocation nearestCurveLocationStart = null;
                            SegmentLocation nearestCurveLocationEnd = null;
                            SmoothVoronoiCellShape parentShape = (SmoothVoronoiCellShape)parent;
                            if (startVertex.isVertexOfParentSegment() && endVertex.isVertexOfParentSegment()) {
                                SmoothedSegment smoothedSegment = parentShape.getSegment(startVertex, endVertex);
                                if (smoothedSegment != null) {
                                    smoothedSegments.add(smoothedSegment);
                                    continue;
                                }
                            } else if (startVertex.isVertexOfParentSegment()) {
                                nearestCurveLocationEnd = ShapeConverter.getNearestSegmentLocation(endVertex, parentShape);
                                if (nearestCurveLocationEnd != null) {
                                    nearestSegment = nearestCurveLocationEnd.getLineSegment();
                                    if (ShapeConverter.getConnectingSegments(startVertex, parentShape).contains(nearestSegment)) {
                                        nearestCurveLocationStart = nearestSegment.getNearestSegmentLocation(startVertex);
                                    }
                                }
                            } else if (endVertex.isVertexOfParentSegment() && (nearestCurveLocationStart = ShapeConverter.getNearestSegmentLocation(startVertex, parentShape)) != null) {
                                nearestSegment = nearestCurveLocationStart.getLineSegment();
                                if (ShapeConverter.getConnectingSegments(endVertex, parentShape).contains(nearestSegment)) {
                                    nearestCurveLocationEnd = nearestSegment.getNearestSegmentLocation(endVertex);
                                }
                            }
                            if (nearestCurveLocationStart == null) {
                                nearestCurveLocationStart = ShapeConverter.getNearestSegmentLocation(startVertex, parentShape);
                            }
                            if (nearestCurveLocationEnd == null) {
                                nearestCurveLocationEnd = ShapeConverter.getNearestSegmentLocation(endVertex, parentShape);
                            }
                            if (nearestCurveLocationStart != null && nearestCurveLocationEnd != null && nearestCurveLocationStart.getLineSegment() == nearestCurveLocationEnd.getLineSegment()) {
                                SmoothedSegment commonSegment = nearestCurveLocationStart.getLineSegment();
                                SmoothedSegment smoothedSegment = commonSegment.getSubSegment(nearestCurveLocationStart, nearestCurveLocationEnd);
                                if (smoothedSegment == null) {
                                    // empty if block
                                }
                                smoothedSegments.add(smoothedSegment);
                                continue;
                            }
                        }
                        List<Point2d> points = currentLineSegment.getPoints();
                        int nPoints = points.size();
                        SegmentDirection direction = (SegmentDirection)((Object)lineSegmentDirectionMap.get(currentLineSegment));
                        if (currentLineSegment.getStartVertex() != null && !currentLineSegment.isStraight() && nPoints >= 5) {
                            DoubleSpline doubleSpline = new DoubleSpline(currentLineSegment, direction);
                            smoothedSegments.add(doubleSpline);
                            continue;
                        }
                        LinearSegment linearSegment = new LinearSegment(currentLineSegment, direction);
                        smoothedSegments.add(linearSegment);
                    }
                    MutableTreeMapNode child = cell.getChild();
                    GeneralPath generalPath = Smoother.createGeneralPath((List<SmoothedSegment>)smoothedSegments);
                    child.setShape((Shape)new SmoothVoronoiCellShape(generalPath, VoronoiAlgorithm.calculatePolygonArea(polygon), cornersOfChild, (List<SmoothedSegment>)smoothedSegments));
                    cell.setPolygon(polygon);
                    continue;
                }
                cell.getChild().setShape(null);
            }
        }
    }

    private static List<SmoothedSegment> getConnectingSegments(Vertex vertex, SmoothVoronoiCellShape parentShape) {
        ArrayList<SmoothedSegment> lineSegments = new ArrayList<SmoothedSegment>();
        List<SmoothedSegment> parentLineSegments = parentShape.getSmoothedSegments();
        for (SmoothedSegment parentLineSegment : parentLineSegments) {
            if (!parentLineSegment.getStartVertex().equals(vertex) && !parentLineSegment.getEndVertex().equals(vertex)) continue;
            lineSegments.add(parentLineSegment);
        }
        return lineSegments;
    }

    private static SegmentLocation getNearestSegmentLocation(Vertex vertex, SmoothVoronoiCellShape parent) {
        List<SmoothedSegment> lineSegments = parent.getSmoothedSegments();
        if (lineSegments.isEmpty()) {
            return null;
        }
        Iterator segmentIterator = lineSegments.iterator();
        SmoothedSegment firstSegment = (SmoothedSegment)segmentIterator.next();
        SegmentLocation firstLocation = firstSegment.getNearestSegmentLocation(vertex);
        if (lineSegments.size() < 2) {
            return firstLocation;
        }
        SegmentLocation nearestLocation = firstLocation;
        double minDistanceSq = firstLocation.getMinSquaredDistance();
        while (segmentIterator.hasNext()) {
            double distanceSq;
            SmoothedSegment lineSegment = (SmoothedSegment)segmentIterator.next();
            SegmentLocation nearestLocationInSegment = lineSegment.getNearestSegmentLocation(vertex);
            if (nearestLocationInSegment == null) {
                // empty if block
            }
            if (!((distanceSq = nearestLocationInSegment.getMinSquaredDistance()) < minDistanceSq)) continue;
            nearestLocation = nearestLocationInSegment;
            minDistanceSq = distanceSq;
        }
        return nearestLocation;
    }

    private static void addToContainerAndMap(LineSegment currentSegment, LineSegmentContainer segmentContainer, Map<LineSegment, SegmentDirection> lineSegmentDirectionMap) {
        SegmentDirection segmentDirection = segmentContainer.addIfNotContained(currentSegment);
        lineSegmentDirectionMap.put(segmentContainer.getReference(currentSegment), segmentDirection);
    }

    private static boolean isStraight(int dirChanges) {
        return dirChanges <= 1;
    }

    private static LineSegment getParentLineSegment(Vertex vertex, SmoothVoronoiCellShape parent) {
        List<SmoothedSegment> lineSegments = parent.getSmoothedSegments();
        for (SmoothedSegment smoothedSegment : lineSegments) {
            for (Point2d point : smoothedSegment.getLineSegment().getPoints()) {
                if (!vertex.isPixelNextToCorner(point)) continue;
                return smoothedSegment.getLineSegment();
            }
        }
        return null;
    }

    private static Vertex getVertexByNextTo(int x, int y, List<Vertex> vertexes) {
        for (Vertex vertex : vertexes) {
            if (!vertex.isPixelNextToCorner(x, y)) continue;
            return vertex;
        }
        return null;
    }

    private static Vertex getVertexByMap(int x, int y, Map<Point2i, Vertex> pointVertexMap) {
        for (Map.Entry<Point2i, Vertex> pointVertexMapEntry : pointVertexMap.entrySet()) {
            Point2i point = pointVertexMapEntry.getKey();
            if (point.x != x || point.y != y) continue;
            return pointVertexMapEntry.getValue();
        }
        return null;
    }
}

