/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.debug;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.treemap.MutableTreeMapNode;
import com.treemap.swing.voronoi.VoronoiAlgorithm;
import com.treemap.swing.voronoi.debug.Debugger;
import com.treemap.swing.voronoi.debug.MyMutableTreeMapNode;
import java.util.LinkedHashMap;

public class DeterministicVoronoiCaller {
    public DeterministicVoronoiCaller() {
        VoronoiAlgorithm voronoi = new VoronoiAlgorithm(0.005, -0.4844, 1, 40, 11, 20, VoronoiAlgorithm.WeightType.AW);
        MyMutableTreeMapNode parent = new MyMutableTreeMapNode("root", 30);
        MutableTreeMapNode[] rootChildren = new MyMutableTreeMapNode[]{new MyMutableTreeMapNode("Upper 1", 90), new MyMutableTreeMapNode("Upper 2", 30)};
        double sumSizes = this.getSumSizes((MyMutableTreeMapNode[])rootChildren);
        voronoi.breadthFirstLayout((Shape)new Rectangle(0, 0, 400, 400), parent, rootChildren, sumSizes, 4, 3, null);
        LinkedHashMap<MutableTreeMapNode, MyMutableTreeMapNode[]> parentChildrenMap = new LinkedHashMap<MutableTreeMapNode, MyMutableTreeMapNode[]>(rootChildren.length);
        MyMutableTreeMapNode[] subChildren1 = new MyMutableTreeMapNode[]{new MyMutableTreeMapNode("Lower 1 1", 90), new MyMutableTreeMapNode("Lower 1 2", 30), new MyMutableTreeMapNode("Lower 1 3", 70), new MyMutableTreeMapNode("Lower 1 4", 40), new MyMutableTreeMapNode("Lower 1 5", 10)};
        Debugger.instance().setInterrestingChild(subChildren1[4]);
        MyMutableTreeMapNode[] subChildren2 = new MyMutableTreeMapNode[]{new MyMutableTreeMapNode("Lower 2 1", 90), new MyMutableTreeMapNode("Lower 2 2", 30), new MyMutableTreeMapNode("Lower 2 3", 70), new MyMutableTreeMapNode("Lower 2 4", 40), new MyMutableTreeMapNode("Lower 2 5", 10)};
        parentChildrenMap.put(rootChildren[0], subChildren1);
        parentChildrenMap.put(rootChildren[1], subChildren2);
        for (MutableTreeMapNode rootChild : rootChildren) {
            voronoi.breadthFirstLayout(rootChild.getShape(), rootChild, (MutableTreeMapNode[])parentChildrenMap.get(rootChild), sumSizes, 4, 3, null);
        }
    }

    private double getSumSizes(MyMutableTreeMapNode[] rootChildren) {
        double sumSizes = 0.0;
        for (MyMutableTreeMapNode rootChild : rootChildren) {
            sumSizes += rootChild.getSize();
        }
        return sumSizes;
    }

    public static void main(String[] args) {
        new DeterministicVoronoiCaller();
    }
}

