/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.smoothing.LineSegment;
import com.treemap.swing.voronoi.smoothing.SegmentDirection;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.Vertex;

public abstract class AbstractSmoothedSegment
implements SmoothedSegment {
    private final Vertex startVertex;
    private final Vertex endVertex;
    private final LineSegment lineSegment;

    public AbstractSmoothedSegment(LineSegment lineSegment, SegmentDirection direction) {
        this.startVertex = lineSegment.getStartVertex(direction);
        this.endVertex = lineSegment.getEndVertex(direction);
        this.lineSegment = lineSegment;
    }

    public AbstractSmoothedSegment(Vertex startVertex, Vertex endVertex, LineSegment lineSegment) {
        this.startVertex = startVertex;
        this.endVertex = endVertex;
        this.lineSegment = lineSegment;
    }

    @Override
    public LineSegment getLineSegment() {
        return this.lineSegment;
    }

    @Override
    public Vertex getStartVertex() {
        return this.startVertex;
    }

    @Override
    public Vertex getEndVertex() {
        return this.endVertex;
    }
}

