/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.macrofocus.geom.Path2D;
import com.treemap.swing.tagcloud.SwingShape;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.Shape;
import java.util.Collections;
import java.util.List;

public class SmoothVoronoiCellShape
extends Path2D.Double {
    private final Shape shape;
    private final double area;
    private final List<Vertex> vertexes;
    private final List<SmoothedSegment> smoothedSegments;

    public SmoothVoronoiCellShape(Shape shape, double area, List<Vertex> vertexes, List<SmoothedSegment> smoothedSegments) {
        super(new SwingShape(shape).getPathIterator());
        this.shape = shape;
        this.area = area;
        this.vertexes = vertexes;
        this.smoothedSegments = smoothedSegments;
    }

    public double getArea() {
        return this.area;
    }

    public List<Vertex> getVertexes() {
        return this.vertexes;
    }

    public List<SmoothedSegment> getSmoothedSegments() {
        return Collections.unmodifiableList(this.smoothedSegments);
    }

    public SmoothedSegment getSegment(Vertex startVertex, Vertex endVertex) {
        for (SmoothedSegment smoothedSegment : this.smoothedSegments) {
            if (smoothedSegment.getStartVertex().equals(startVertex) && smoothedSegment.getEndVertex().equals(endVertex)) {
                return smoothedSegment;
            }
            if (!smoothedSegment.getStartVertex().equals(endVertex) || !smoothedSegment.getEndVertex().equals(startVertex)) continue;
            return smoothedSegment.reversed();
        }
        return null;
    }

    public String toString() {
        return "A=" + this.area;
    }
}

