/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.smoothing.CurveLocation;
import com.treemap.swing.voronoi.smoothing.SegmentLocation;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Smoother {
    private static final Point2d p0 = new Point2d();
    private static final Point2d p1 = new Point2d();
    private static final Point2d p2 = new Point2d();
    private static final Point2d p3 = new Point2d();
    private static final Point2d q0 = new Point2d();
    private static final Point2d q1 = new Point2d();
    private static final Point2d q2 = new Point2d();
    private static final Point2d r0 = new Point2d();
    private static final Point2d r1 = new Point2d();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmoothedSegment createSmoothedSegment(SmoothedSegment commonSegment, SegmentLocation start, SegmentLocation end, Vertex startVertex, Vertex endVertex) {
        try {
            if (start instanceof CurveLocation && !(end instanceof CurveLocation)) return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static CurveLocation getNearestCurveLocation(Vertex vertex, CubicCurve2D curve, Map<Double, Point2d> samples, SmoothedSegment smoothedSegment) {
        if (samples == null || vertex == null || vertex.getLocation() == null || samples.isEmpty()) {
            return null;
        }
        Point2d location = vertex.getLocation();
        Map.Entry<Double, Point2d> firstEntry = samples.entrySet().iterator().next();
        if (samples.size() == 1) {
            return new CurveLocation(firstEntry, curve, firstEntry.getValue().distanceSquared(location), smoothedSegment, vertex);
        }
        Point2d firstSample = firstEntry.getValue();
        double minSquaredDistance = firstSample.distanceSquared(location);
        Map.Entry<Double, Point2d> nearestEntry = firstEntry;
        for (Map.Entry<Double, Point2d> entry : samples.entrySet()) {
            Point2d sample;
            double distanceSq;
            if (entry.equals(firstEntry) || !((distanceSq = (sample = entry.getValue()).distanceSquared(location)) < minSquaredDistance)) continue;
            minSquaredDistance = distanceSq;
            nearestEntry = entry;
        }
        return new CurveLocation(nearestEntry, curve, minSquaredDistance, smoothedSegment, vertex);
    }

    public static Map<Double, Point2d> createSamples(CubicCurve2D curve) {
        double estimatedMaxLength = Smoother.getDiagonalLength(curve.getBounds()) * 2.0;
        int nSamples = (int)Math.ceil(estimatedMaxLength);
        return Smoother.sample(curve, nSamples);
    }

    public static double getDiagonalLength(Rectangle bounds) {
        return Math.sqrt(bounds.width * bounds.width + bounds.height * bounds.height);
    }

    public static Map<Double, Point2d> sample(CubicCurve2D curve, int nSamples) {
        LinkedHashMap<Double, Point2d> tValueSampleMap = new LinkedHashMap<Double, Point2d>(nSamples);
        Point2d sampleLocation = new Point2d();
        for (int nSample = 0; nSample < nSamples; ++nSample) {
            double t = (double)nSample / (double)(nSamples - 1);
            Smoother.getBezierLocation(curve, t, sampleLocation);
            tValueSampleMap.put(t, new Point2d(sampleLocation));
        }
        return tValueSampleMap;
    }

    public static void getBezierLocation(CubicCurve2D curve, double t, Point2d sampleLocation) {
        p0.set(curve.getX1(), curve.getY1());
        p1.set(curve.getCtrlX1(), curve.getCtrlY1());
        p2.set(curve.getCtrlX2(), curve.getCtrlY2());
        p3.set(curve.getX2(), curve.getY2());
        Smoother.lerp(t, p0, p1, q0);
        Smoother.lerp(t, p1, p2, q1);
        Smoother.lerp(t, p2, p3, q2);
        Smoother.lerp(t, q0, q1, r0);
        Smoother.lerp(t, q1, q2, r1);
        Smoother.lerp(t, r0, r1, sampleLocation);
    }

    public static void reverse(CubicCurve2D curve) {
        curve.setCurve(curve.getX2(), curve.getY2(), curve.getCtrlX2(), curve.getCtrlY2(), curve.getCtrlX1(), curve.getCtrlY1(), curve.getX1(), curve.getY1());
    }

    public static CurveLocation getTheOneCloserToP1(CurveLocation l1, CurveLocation l2, CubicCurve2D curve) {
        Point2d location1 = l1.getNearestSample().getValue();
        Point2d location2 = l2.getNearestSample().getValue();
        Point2D p1 = curve.getP1();
        if (p1.distanceSq(location1.x, location1.y) < p1.distanceSq(location2.x, location2.y)) {
            return l1;
        }
        return l2;
    }

    public static SegmentLocation getTheOneCloserToP2(CurveLocation l1, CurveLocation l2, CubicCurve2D curve) {
        Point2d location1 = l1.getNearestSample().getValue();
        Point2d location2 = l2.getNearestSample().getValue();
        Point2D p2 = curve.getP2();
        if (p2.distanceSq(location1.x, location1.y) < p2.distanceSq(location2.x, location2.y)) {
            return l1;
        }
        return l2;
    }

    public static CubicCurve2D getSubCruveFromP1(CurveLocation curveLocation, CubicCurve2D curve) {
        CubicCurve2D subCurve = Smoother.newCubicCurve2D(curve.getClass());
        Map.Entry<Double, Point2d> nearestSample = curveLocation.getNearestSample();
        Point2d to = nearestSample.getValue();
        double t = nearestSample.getKey();
        p0.set(curve.getX1(), curve.getY1());
        p1.set(curve.getCtrlX1(), curve.getCtrlY1());
        p2.set(curve.getCtrlX2(), curve.getCtrlY2());
        Smoother.lerp(t, p0, p1, q0);
        Smoother.lerp(t, p1, p2, q1);
        Smoother.lerp(t, q0, q1, r0);
        subCurve.setCurve(Smoother.p0.x, Smoother.p0.y, Smoother.q0.x, Smoother.q0.y, Smoother.r0.x, Smoother.r0.y, to.x, to.y);
        return subCurve;
    }

    public static CubicCurve2D getSubCruveToP2(CurveLocation curveLocation, CubicCurve2D curve) {
        CubicCurve2D subCurve = Smoother.newCubicCurve2D(curve.getClass());
        Map.Entry<Double, Point2d> nearestSample = curveLocation.getNearestSample();
        Point2d from = nearestSample.getValue();
        double t = nearestSample.getKey();
        p1.set(curve.getCtrlX1(), curve.getCtrlY1());
        p2.set(curve.getCtrlX2(), curve.getCtrlY2());
        p3.set(curve.getX2(), curve.getY2());
        Smoother.lerp(t, p1, p2, q1);
        Smoother.lerp(t, p2, p3, q2);
        Smoother.lerp(t, q1, q2, r1);
        subCurve.setCurve(from.x, from.y, Smoother.r1.x, Smoother.r1.y, Smoother.q2.x, Smoother.q2.y, Smoother.p3.x, Smoother.p3.y);
        return subCurve;
    }

    private static void lerp(double t, Point2d p1, Point2d p2, Point2d result) {
        result.set(p2);
        result.sub(p1);
        result.scale(t);
        result.add(p1);
    }

    public static CubicCurve2D newCubicCurve2D(Class<? extends CubicCurve2D> curveType) {
        if (curveType.equals(CubicCurve2D.Double.class)) {
            return new CubicCurve2D.Double();
        }
        if (curveType.equals(CubicCurve2D.Float.class)) {
            return new CubicCurve2D.Float();
        }
        return null;
    }

    public static GeneralPath createGeneralPath(List<SmoothedSegment> smoothedSegments) {
        GeneralPath generalPath = new GeneralPath();
        Iterator<SmoothedSegment> segmentIterator = smoothedSegments.iterator();
        if (segmentIterator.hasNext()) {
            SmoothedSegment firstSegment = segmentIterator.next();
            if (generalPath.getCurrentPoint() == null && firstSegment.getStartVertex() != null) {
                Point2d startPoint = firstSegment.getStartVertex().getLocation();
                generalPath.moveTo(startPoint.x, startPoint.y);
            }
            firstSegment.addToGeneralPath(generalPath);
            while (segmentIterator.hasNext()) {
                SmoothedSegment smoothedSegment = segmentIterator.next();
                if (smoothedSegment == null) {
                    // empty if block
                }
                smoothedSegment.addToGeneralPath(generalPath);
            }
        }
        return generalPath;
    }
}

