/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.ncdm.venn.display;

import edu.uic.ncdm.venn.VennDiagram;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class VennCanvas
extends JPanel {
    private BufferedImage bi = new BufferedImage(this.size, this.size, 2);
    public double[][] centers;
    public double[] diameters;
    public double[] colors;
    public String[] labels;
    private int size = 700;
    private double mins;
    private double maxs;
    private FontRenderContext frc = this.bi.createGraphics().getFontRenderContext();

    public VennCanvas(VennDiagram venn) {
        this.size = (int)((double)this.size * 0.8);
        this.centers = venn.centers;
        this.diameters = venn.diameters;
        this.colors = venn.colors;
        this.labels = venn.circleLabels;
        this.mins = Double.POSITIVE_INFINITY;
        this.maxs = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.centers.length; ++i) {
            double margin = this.diameters[i] / 2.0;
            this.mins = Math.min(this.centers[i][0] - margin, this.mins);
            this.mins = Math.min(this.centers[i][1] - margin, this.mins);
            this.maxs = Math.max(this.centers[i][0] + margin, this.maxs);
            this.maxs = Math.max(this.centers[i][1] + margin, this.maxs);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)this.bi.getGraphics();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, this.bi.getHeight(), this.bi.getWidth());
        for (int i = 0; i < this.centers.length; ++i) {
            double xi = (this.centers[i][0] - this.mins) / (this.maxs - this.mins);
            double yi = (this.centers[i][1] - this.mins) / (this.maxs - this.mins);
            double pi = this.diameters[i] / (this.maxs - this.mins);
            int pointSize = (int)(pi * (double)this.size);
            int x = 50 + (int)(xi * (double)this.size);
            int y = 50 + (int)((double)this.size - yi * (double)this.size);
            Color color = VennCanvas.rainbow(this.colors[i], 0.4f);
            g2D.setColor(color);
            g2D.fillOval(x - pointSize / 2, y - pointSize / 2, pointSize, pointSize);
            g2D.setColor(Color.BLACK);
            double[] wh = this.getWidthAndHeight(this.labels[i], g2D);
            g2D.drawString(this.labels[i], x - (int)wh[0] / 2, y + (int)wh[1] / 2);
        }
        Graphics2D gg = (Graphics2D)g;
        gg.drawImage((Image)this.bi, 2, 2, this);
    }

    private static Color rainbow(double value, float transparency) {
        float v = (float)value * 255.0f;
        float vmin = 0.0f;
        float vmax = 255.0f;
        float range = vmax - vmin;
        if (v < vmin + 0.25f * range) {
            return new Color(0.0f, 4.0f * (v - vmin) / range, 1.0f, transparency);
        }
        if ((double)v < (double)vmin + 0.5 * (double)range) {
            return new Color(0.0f, 1.0f, 1.0f + 4.0f * (vmin + 0.25f * range - v) / range, transparency);
        }
        if ((double)v < (double)vmin + 0.75 * (double)range) {
            return new Color(4.0f * (v - vmin - 0.5f * range) / range, 1.0f, 0.0f, transparency);
        }
        return new Color(1.0f, 1.0f + 4.0f * (vmin + 0.75f * range - v) / range, 0.0f, transparency);
    }

    public double[] getWidthAndHeight(String s, Graphics2D g2D) {
        Font font = g2D.getFont();
        Rectangle2D bounds = font.getStringBounds(s, this.frc);
        double[] wh = new double[]{bounds.getWidth(), 0.7 * bounds.getHeight()};
        return wh;
    }
}

