/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.AbstractLabeling;
import com.treemap.Algorithm;
import com.treemap.RectangularTransform;
import com.treemap.Rendering;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import com.treemap.tagcloud.TextShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

public abstract class AbstractRendering<C, N, Row, Column, Color, Font>
implements Rendering<C, N, Row, Column, Color, Font> {
    protected static final float COLOR_SIMILARITY_THRESHOLD = 0.5f;

    @Override
    public int getPasses(TreeMapModel<N, Row, Column, Color, Font> model) {
        TreeMapField<N, Column> treeMapField = model.getSettings().getHeightTreeMapField();
        if (treeMapField.isValid() && (model.isNumericType(treeMapField) || model.isTemporalType(treeMapField))) {
            return 2;
        }
        return 1;
    }

    @Override
    public Iterable<N> getParentOrder(TreeMapView<C, N, Row, Column, Color, Font> view, N root, int pass) {
        switch (pass) {
            case 0: {
                return view.getModel().parentPreorderEnumeration(root);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<N> getOrder(final TreeMapView<C, N, Row, Column, Color, Font> view, N root, int pass) {
        switch (pass) {
            case 0: {
                return view.getModel().preorderEnumeration(root);
            }
        }
        ArrayList<N> arrayList = new ArrayList<N>();
        for (N n2 : view.getModel().preorderEnumeration(root)) {
            if (!view.getModel().hasNoChildren(n2)) continue;
            arrayList.add(n2);
        }
        Collections.sort(arrayList, new Comparator<N>(){

            @Override
            public int compare(N o1, N o2) {
                Shape shape = view.worldToScreen(o1);
                Shape shape2 = view.worldToScreen(o2);
                if (shape != null) {
                    if (shape2 != null) {
                        Dimension dimension = view.getModel().getSettings().getDimension();
                        if (dimension != null) {
                            double d2 = dimension.getWidth();
                            double d3 = dimension.getHeight();
                            double d4 = shape.getBounds2D().getCenterX() / d2;
                            double d5 = shape.getBounds2D().getCenterY() / d3;
                            double d6 = shape2.getBounds2D().getCenterX() / d2;
                            double d7 = shape2.getBounds2D().getCenterY() / d3;
                            return Double.compare(d4 + d5, d6 + d7);
                        }
                        return Double.compare(shape.getBounds2D().getCenterX() + shape.getBounds2D().getCenterY(), shape2.getBounds2D().getCenterX() + shape2.getBounds2D().getCenterY());
                    }
                    return 1;
                }
                if (shape2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    @Override
    public void paintParent(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int pass, Rectangle bounds, Shape shape) {
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = view.getModel();
        if (pass == 0 && !treeMapModel.hasNoChildren(node)) {
            int n2 = treeMapModel.getLevel(node) - treeMapModel.getLevel(treeMapModel.getCurrentRoot());
            Algorithm algorithm = treeMapModel.getSettings().getFieldSettings(treeMapModel.getGroupByField(node)).getAlgorithm();
            if (treeMapModel.getSettings().getDepth().display(n2 + 1) && algorithm.isCompatible(treeMapModel.getShape(node)) && !algorithm.isColorParent()) {
                CPColor<Color> cPColor = this.getNestingBackground(node, treeMapModel);
                if (cPColor != null) {
                    g2.setFill(cPColor);
                } else {
                    g2.setFill(view.getBackground());
                }
                g2.fill(shape);
            } else if (treeMapModel.getCurrentRoot() != node) {
                this.paintNode(g2, view, node, pass, bounds, shape);
            }
        }
    }

    @Override
    public Shape getRenderedShape(TreeMapView<C, N, Row, Column, Color, Font> view, TreeMapModel<N, Row, Column, Color, Font> model, N node, Shape shape) {
        TreeMapField<N, Column> treeMapField;
        if (node != null && model.hasNoChildren(node) && (treeMapField = model.getSettings().getHeightTreeMapField()).isValid() && (model.isNumericType(treeMapField) || model.isTemporalType(treeMapField))) {
            Double d2 = model.getNumericMin(treeMapField);
            Double d3 = model.getNumericMax(treeMapField);
            Object object = model.getValueAt(node, treeMapField.getIndex());
            if (object != null && d3 != null && d2 != null) {
                double d4 = object instanceof Number ? ((Number)object).doubleValue() : (object instanceof Date ? (double)((Date)object).getTime() : 0.0);
                double d5 = d3 - d2;
                double d6 = Math.abs((d4 - d2) / d5);
                if (shape instanceof Rectangle2D) {
                    Rectangle2D rectangle2D = (Rectangle2D)shape;
                    double d7 = (double)view.getZoomFactor() * -view.getModel().getSettings().getMaximumHeight() * Math.min(model.getSettings().getDimension().getWidth(), model.getSettings().getDimension().getHeight());
                    int n2 = (int)(d7 * d6);
                    RectangularTransform rectangularTransform = new RectangularTransform();
                    rectangularTransform.translate(n2, n2);
                    Rectangle2D rectangle2D2 = rectangularTransform.transform(rectangle2D);
                    return rectangle2D2;
                }
            }
        }
        return shape;
    }

    @Override
    public void paintBackground(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int pass, int passes, Rectangle b2, Shape shape) {
        if (pass == passes - 1) {
            TreeMapModel<N, Row, Column, Color, Font> treeMapModel = view.getModel();
            shape = this.getRenderedShape(view, treeMapModel, node, shape);
            Rectangle rectangle = this.a(shape);
            g2.save();
            g2.clip(shape);
            TreeMapField<N, Column> treeMapField = treeMapModel.getSettings().getBackgroundTreeMapField();
            if (treeMapField.isValid() && rectangle.width > 1 && rectangle.height > 1) {
                TreeMapFieldSettings<Color, Font> treeMapFieldSettings = view.getModel().getSettings().getFieldSettings(treeMapField);
                CPFont<Font> cPFont = treeMapFieldSettings.getLabelingFont();
                if (rectangle.width > 5 && (double)rectangle.height >= cPFont.getSize2D()) {
                    double d2;
                    EnhancedLabel<Color, Font> enhancedLabel = view.getLabelRenderer().getTreeMapLabelRendererComponent(view, treeMapField, treeMapFieldSettings, node, new Dimension(rectangle.width, rectangle.height));
                    PreferredSize preferredSize = g2.sizeLabel(enhancedLabel, rectangle.width, rectangle.height);
                    int n2 = rectangle.width - enhancedLabel.getInsetRight() - enhancedLabel.getInsetLeft();
                    int n3 = rectangle.height - enhancedLabel.getInsetTop() - enhancedLabel.getInsetBottom();
                    CPColor<Color> cPColor = treeMapModel.getSettings().getFieldSettings(treeMapField).getLabelingEffectColor();
                    CPColor cPColor2 = treeMapModel.getSettings().getFieldSettings(treeMapField).getLabelingForeground();
                    CPColor<Color> cPColor3 = treeMapModel.getColor(node);
                    if (cPColor2 != null && cPColor == null && cPColor3 != null) {
                        cPColor2 = treeMapModel.getSettings().getFieldSettings(treeMapField).getLabelingContrastEnhancement().adjustLabelColor(cPColor2, cPColor3);
                    }
                    enhancedLabel.setFont(cPFont);
                    enhancedLabel.setForeground(cPColor2);
                    enhancedLabel.setBackground(cPColor);
                    Dimension dimension = preferredSize.getPreferredSize();
                    if (treeMapFieldSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap) {
                        float f2 = (float)n2 / (float)(dimension.getWidth() - (double)enhancedLabel.getInsetRight().intValue() - (double)enhancedLabel.getInsetLeft().intValue());
                        float f3 = (float)n3 / (float)(dimension.getHeight() - (double)enhancedLabel.getInsetTop().intValue() - (double)enhancedLabel.getInsetBottom().intValue());
                        float f4 = Math.min(f2, f3);
                        d2 = Math.max(cPFont.getSize2D(), cPFont.getSize2D() * (double)f4 * 1.0);
                    } else {
                        d2 = Math.max(cPFont.getSize2D(), g2.fitTextInsideRectangle(enhancedLabel, preferredSize, cPFont, (Rectangle2D)new Rectangle(0, 0, n2, n3), 0.9, true));
                    }
                    if (d2 >= cPFont.getSize2D() / 4.0) {
                        CPFont<Font> cPFont2 = cPFont.deriveFontSize(d2);
                        enhancedLabel.setFont((CPFont)cPFont2);
                        if (treeMapFieldSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap) {
                            cPFont2 = AbstractRendering.scaleFontToFit(rectangle, cPFont, enhancedLabel, preferredSize, d2, false, true);
                            enhancedLabel.setFont(cPFont2);
                        }
                        dimension = preferredSize.getPreferredSize();
                        int n4 = 0;
                        switch (treeMapModel.getSettings().getFieldSettings(treeMapField).getLabelingVerticalAlignment()) {
                            case 1: {
                                n4 = rectangle.y;
                                break;
                            }
                            case 0: {
                                if (rectangle.height > dimension.height) {
                                    n4 = rectangle.y + (rectangle.height - dimension.height) / 2;
                                    break;
                                }
                                n4 = rectangle.y;
                                break;
                            }
                            case 3: {
                                n4 = rectangle.height > dimension.height ? rectangle.y + (rectangle.height - dimension.height) : rectangle.y;
                            }
                        }
                        Rectangle rectangle2 = AbstractLabeling.findEnclosedRectangle(shape, n4, dimension.height);
                        g2.paintLabel(enhancedLabel, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                }
            }
            g2.restore();
        }
    }

    @Override
    public CPColor<Color> getNestingBackground(N node, TreeMapModel<N, Row, Column, Color, Font> model) {
        return model.getSettings().getFieldSettings(model.getGroupByField(node)).getNestingBackground();
    }

    private Rectangle a(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            return new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        int n2 = (int)(rectangle2D.getWidth() / Math.sqrt(2.0));
        int n3 = (int)(rectangle2D.getHeight() / Math.sqrt(2.0));
        return new Rectangle((int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n2) / 2.0), (int)(rectangle2D.getY() + (rectangle2D.getHeight() - (double)n3) / 2.0), n2, n3);
    }

    public static <Color, Font> CPFont<Font> scaleFontToFit(Rectangle bounds, CPFont<Font> font, EnhancedLabel<Color, Font> elabel, PreferredSize pf, double fontSize, boolean shrink, boolean expand) {
        elabel.setFont(font.deriveFontSize(fontSize));
        Dimension dimension = pf.getPreferredSize();
        double d2 = dimension.getWidth() - (double)elabel.getInsetLeft().intValue() - (double)(-elabel.getInsetRight().intValue());
        double d3 = dimension.getHeight() - (double)elabel.getInsetTop().intValue() - (double)(-elabel.getInsetBottom().intValue());
        float f2 = bounds.width;
        float f3 = bounds.height;
        double d4 = Math.min((double)f2 * fontSize / (double)((float)d2), (double)f3 * fontSize / (double)((float)d3)) * (double)0.9f;
        if (!shrink) {
            d4 = Math.max(fontSize, d4);
        }
        if (!expand) {
            d4 = Math.min(fontSize, d4);
        }
        CPFont cPFont = font.deriveFontSize(d4);
        return cPFont;
    }

    @Override
    public void paintLabel(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int pass, int passes, Rectangle bounds, Shape shape) {
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel;
        N n2;
        if (pass == passes - 1 && (n2 = (treeMapModel = view.getModel()).getParent(node)) != null) {
            TreeMapFieldSettings<Color, Font> treeMapFieldSettings;
            TreeMapField<N, Column> treeMapField = treeMapModel.getGroupByField(n2);
            Algorithm algorithm = treeMapField != null ? ((treeMapFieldSettings = treeMapModel.getSettings().getFieldSettings(treeMapField)) != null ? treeMapFieldSettings.getAlgorithm() : null) : treeMapModel.getSettings().getDefaultFieldSettings().getAlgorithm();
            if (algorithm == null || algorithm.isRenderingLeafLabelsSupported()) {
                shape = this.getRenderedShape(view, treeMapModel, node, shape);
                g2.save();
                g2.clip(shape);
                bounds = this.a(shape);
                treeMapModel.getSettings().getFieldSettings(treeMapModel.getGroupByField(node)).getLabeling().paintLeaf(g2, shape, bounds, node, view);
                g2.restore();
            }
        }
    }

    @Override
    public void paintParentBorder(TGraphics<Color, Font> g2, N node, Rectangle bounds, Shape shape, TreeMapModel<N, Row, Column, Color, Font> model) {
        float f2;
        if (!(bounds.width <= 1 || bounds.height <= 1 || model.isRoot(node) || model.hasNoChildren(node) || model.getFilter().isFiltered(node) || model.getSearch().isFiltered(node) || !((f2 = (float)model.getSettings().getFieldSettings(model.getGroupByField(node)).getBorderThickness()) > 0.0f) || shape instanceof TextShape)) {
            g2.save();
            g2.setLineWidth(f2);
            g2.setStroke(model.getSettings().getFieldSettings(model.getGroupByField(node)).getBorderColor());
            g2.stroke(shape);
            g2.restore();
        }
    }

    @Override
    public void paintParentHighlight(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int pass, Rectangle bounds, Shape shape) {
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = view.getModel();
        if (!treeMapModel.isRoot(node) && !treeMapModel.getFilter().isFiltered(node) && !treeMapModel.getSearch().isFiltered(node) && treeMapModel.getHighlighting().isActive() && treeMapModel.getHighlighting().isSelected(node)) {
            g2.save();
            g2.setLineWidth(2.0);
            g2.setStroke(treeMapModel.getSettings().getProbingColor());
            g2.stroke(shape);
            g2.restore();
        }
    }
}

