/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.colormap.ColorMapEvent;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.ColorMapListener;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.common.collection.DoubleIterable;
import com.macrofocus.common.collection.DoubleIterables;
import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPHelper;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.filter.SimpleFilter;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.ColorProvider;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.treemap.AbstractTreeMapNode;
import com.treemap.Aggregation;
import com.treemap.AggregationFactory;
import com.treemap.BreadthFirstIterator;
import com.treemap.DefaultTreeMapSettings;
import com.treemap.I;
import com.treemap.J;
import com.treemap.K;
import com.treemap.Labeling;
import com.treemap.MutableTreeMapNode;
import com.treemap.NoTreeMapField;
import com.treemap.Ordering;
import com.treemap.ParentTreeMapNode;
import com.treemap.Scale;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapSettingsEvent;
import com.treemap.TreeMapSettingsListener;
import com.treemap.TreeMapWorker;
import com.treemap.tagcloud.TextShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import jsinterop.annotations.JsMethod;

public abstract class AbstractTreeMapModel<N extends MutableTreeMapNode<N, Column, Color, Font>, Row, Column, Color, Font>
implements TreeMapModel<N, Row, Column, Color, Font> {
    private final MutableProperties<String> b = new SimpleProperties();
    protected final Map<Row, N> rowNode = new HashMap<Row, N>();
    protected final Map<TreeMapField, ParentTreeMapNode> rootNodes = new HashMap<TreeMapField, ParentTreeMapNode>();
    protected final TreeMapSettings _settings;
    private final MutableSingleSelection<N> c = new SimpleSingleSelection();
    private final MutableSelection<N> d = new SimpleSelection();
    private final MutableSelection<N> e = new SimpleSelection();
    private final MutableFilter<N> f = new SimpleFilter();
    private final MutableFilter<N> g = new SimpleFilter();
    private final List<TreeMapListener> h;
    private final CPTimer i;
    private final boolean j = true;
    private final boolean k = true;
    private final boolean l = true;
    private final ExecutorService m;
    private final Map<a, Object> n = PluggableCollectionFactory.getInstance().concurrentHashMap();
    private final ColorMapListener o = new ColorMapListener(){

        public void colorMapChanged(ColorMapEvent event) {
            AbstractTreeMapModel.this.scheduleUpdateColors();
        }
    };
    private N p;
    private MutableProperty<N> q = this.b.createProperty((Object)"currentRoot", null);
    private Worker r;
    private Future<Void> s;
    private boolean t = true;
    private boolean u = true;
    private boolean v = true;
    private boolean w = false;
    private boolean x = false;
    private boolean y = false;
    private double z;
    private double A;
    private double B;
    private final MutableProperty<Integer> C = this.b.createProperty((Object)"progress", (Object)0);
    private double D = 0.0;
    protected final CPHelper cpHelper;
    protected final CPColorFactory<Color> colorFactory;
    protected final CPFontFactory<Font> fontFactory;
    protected final ColorMapFactory<Color> colorMapFactory;
    protected final FormatFactory formatFactory;
    protected final CPImageFactory imageFactory;
    private ColorProvider<N, Color> E = new ColorProvider<N, Color>(){

        public CPColor<Color> a(N n2) {
            return n2.getColor();
        }

        public /* synthetic */ CPColor getColor(Object object) {
            return this.a((MutableTreeMapNode)object);
        }
    };
    private final Map<TreeMapField, MutableColorMap> F = new HashMap<TreeMapField, MutableColorMap>();
    private final Map<TreeMapField, MutableColorMap> G = new HashMap<TreeMapField, MutableColorMap>();
    private final Map<TreeMapField, MutableColorMap> H = new HashMap<TreeMapField, MutableColorMap>();

    public AbstractTreeMapModel(CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        this.cpHelper = cpFactory;
        this.colorFactory = cpFactory;
        this.fontFactory = cpFactory;
        this.colorMapFactory = colorMapFactory;
        this.imageFactory = imageFactory;
        this.formatFactory = cpFactory.getFormatFactory();
        this._settings = this.createSettings();
        this.h = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();
        this.m = cpFactory.newFixedThreadPool(this.d().getClass().getSimpleName(), 0, 1);
        this.i = this.cpHelper.createTimer("TreeMapModelUpdater", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                AbstractTreeMapModel.this.a();
            }
        });
        this.getSettings().addTreeMapSettingsListener(new TreeMapSettingsListener(){

            @Override
            public void settingsChanged(TreeMapSettingsEvent event) {
                if (event.isUpdateGroupBy()) {
                    AbstractTreeMapModel.this.scheduleUpdateGroupBy();
                } else if (event.isUpdateLayout()) {
                    AbstractTreeMapModel.this.scheduleUpdateLayout();
                } else if (event.isUpdateColors()) {
                    AbstractTreeMapModel.this.scheduleUpdateColors();
                } else {
                    AbstractTreeMapModel.this.a(new TreeMapEvent(false, false, false));
                }
            }
        });
        this.b();
        this.getProbing().addSingleSelectionListener(new SingleSelectionListener<N>(){

            public void selectionChanged(SingleSelectionEvent<N> event) {
                MutableTreeMapNode mutableTreeMapNode = (MutableTreeMapNode)event.getCurrentSelection();
                if (mutableTreeMapNode != null) {
                    ArrayList<MutableTreeMapNode> arrayList = new ArrayList<MutableTreeMapNode>();
                    do {
                        arrayList.add(mutableTreeMapNode);
                    } while ((mutableTreeMapNode = AbstractTreeMapModel.this.getParent(mutableTreeMapNode)) != null);
                    AbstractTreeMapModel.this.getHighlighting().setSelectedIterable(arrayList);
                } else {
                    AbstractTreeMapModel.this.getHighlighting().clearSelection();
                }
            }
        });
        this.getSettings().getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("aggregation".equals(name)) {
                    AbstractTreeMapModel.this.clearAggregationCache();
                }
            }
        });
        this.f.addFilterListener(new FilterListener<N>(){

            public void filterChanged(FilterEvent event) {
                AbstractTreeMapModel.this.scheduleUpdateLayout();
            }
        });
        this.g.addFilterListener(new FilterListener<N>(){

            public void filterChanged(FilterEvent event) {
                AbstractTreeMapModel.this.scheduleUpdateLayout();
            }
        });
        this.q.addPropertyListener(new PropertyListener<N>(){

            public void propertyChanged(PropertyEvent<N> event) {
                AbstractTreeMapModel.this.getSelection().clearSelection();
                AbstractTreeMapModel.this.scheduleUpdateLayout();
            }
        });
    }

    @Override
    public MutableProperties<String> getProperties() {
        return this.b;
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getGroupByTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(true), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return treeMapField instanceof NoTreeMapField || !treeMapField.isEveryValueUnique() || treeMapField.getType().isArray();
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getSizeTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(true), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return treeMapField instanceof NoTreeMapField || AbstractTreeMapModel.this.isNumericType(treeMapField) || AbstractTreeMapModel.this.isTemporalType(treeMapField);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getColorTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(true), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return treeMapField instanceof NoTreeMapField || treeMapField.getType() == null || !treeMapField.getType().isArray();
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getHeightTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(true), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return treeMapField instanceof NoTreeMapField || AbstractTreeMapModel.this.isNumericType(treeMapField) || AbstractTreeMapModel.this.isTemporalType(treeMapField);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getLabelsTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(false), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return !AbstractTreeMapModel.this.isVisualType(treeMapField);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getTooltipTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(false), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return !AbstractTreeMapModel.this.isVisualType(treeMapField);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    protected Iterable<TreeMapField<N, Column>> getTreeMapFields(boolean includeNone) {
        ArrayList<TreeMapField<N, Column>> arrayList = new ArrayList<TreeMapField<N, Column>>();
        if (includeNone) {
            arrayList.add(new NoTreeMapField());
        }
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            arrayList.add(this.getTreeMapField(i2));
        }
        return arrayList;
    }

    @Override
    public boolean isNumericType(TreeMapField<N, Column> field) {
        Class clazz = field.getType();
        return clazz != null && this.cpHelper.isNumericType(clazz);
    }

    @Override
    public boolean isTemporalType(TreeMapField<N, Column> field) {
        Class clazz = field.getType();
        return clazz != null && this.cpHelper.isTemporalType(clazz);
    }

    @Override
    public boolean isVisualType(TreeMapField<N, Column> field) {
        Class clazz = field.getType();
        return clazz != null && this.cpHelper.isVisualType(clazz);
    }

    protected void initDefaults() {
        TreeMapField treeMapField;
        int n2;
        NoTreeMapField noTreeMapField;
        TreeMapField treeMapField2;
        int n3;
        NoTreeMapField noTreeMapField2 = null;
        NoTreeMapField noTreeMapField3 = null;
        NoTreeMapField noTreeMapField4 = null;
        for (n3 = 0; n3 < this.getColumnCount(); ++n3) {
            treeMapField2 = this.getTreeMapField(n3);
            if (treeMapField2.getType() != String.class) continue;
            if (noTreeMapField3 == null) {
                noTreeMapField3 = treeMapField2;
                continue;
            }
            if (treeMapField2.isEveryValueUnique()) break;
            noTreeMapField4 = treeMapField2;
            break;
        }
        for (n3 = 0; n3 < this.getColumnCount(); ++n3) {
            treeMapField2 = this.getTreeMapField(n3);
            if (!treeMapField2.getType().isArray()) continue;
            noTreeMapField4 = treeMapField2;
            break;
        }
        NoTreeMapField noTreeMapField5 = noTreeMapField3;
        NoTreeMapField noTreeMapField6 = noTreeMapField4;
        NoTreeMapField noTreeMapField7 = null;
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            noTreeMapField = this.getTreeMapField(i2);
            if (!this.isVisualType(noTreeMapField) || this.cpHelper.isAssignableFrom(CPColor.class, noTreeMapField.getType()) || noTreeMapField7 != null) continue;
            noTreeMapField7 = noTreeMapField;
            break;
        }
        NoTreeMapField noTreeMapField8 = noTreeMapField7;
        NoTreeMapField noTreeMapField9 = null;
        noTreeMapField = null;
        for (int i3 = 0; i3 < this.getColumnCount(); ++i3) {
            NoTreeMapField noTreeMapField10 = this.getTreeMapField(i3);
            if (!this.cpHelper.isAssignableFrom(Number.class, noTreeMapField10.getType())) continue;
            if (noTreeMapField9 == null) {
                noTreeMapField9 = noTreeMapField10;
                continue;
            }
            noTreeMapField = noTreeMapField10;
            break;
        }
        NoTreeMapField noTreeMapField11 = null;
        for (int i4 = 0; i4 < this.getColumnCount(); ++i4) {
            TreeMapField treeMapField3 = this.getTreeMapField(i4);
            if (!this.cpHelper.isAssignableFrom(CPColor.class, treeMapField3.getType())) continue;
            noTreeMapField11 = treeMapField3;
            break;
        }
        NoTreeMapField noTreeMapField12 = noTreeMapField9;
        NoTreeMapField noTreeMapField13 = noTreeMapField11 != null ? noTreeMapField11 : (noTreeMapField != null ? noTreeMapField : noTreeMapField9);
        if (noTreeMapField5 == null) {
            noTreeMapField5 = new NoTreeMapField();
        }
        if (noTreeMapField12 == null) {
            noTreeMapField12 = new NoTreeMapField();
        }
        if (noTreeMapField2 == null) {
            noTreeMapField2 = new NoTreeMapField();
        }
        if (noTreeMapField13 == null) {
            noTreeMapField13 = new NoTreeMapField();
        }
        if (noTreeMapField8 == null) {
            noTreeMapField8 = new NoTreeMapField();
        }
        if (noTreeMapField6 != null) {
            TreeMapField[] treeMapFieldArray = new TreeMapField[]{noTreeMapField6};
            this._settings.setGroupByTreeMapFields(treeMapFieldArray);
        } else {
            this.scheduleUpdateGroupBy();
        }
        TreeMapField[] treeMapFieldArray = new TreeMapField[]{noTreeMapField5};
        this._settings.setLabelTreeMapFields(treeMapFieldArray);
        this._settings.setSizeTreeMapField(noTreeMapField12);
        this._settings.setHeightTreeMapField(noTreeMapField2);
        this._settings.setColorTreeMapField(noTreeMapField13);
        this._settings.setBackgroundTreeMapField(noTreeMapField8);
        int n4 = 0;
        for (n2 = 0; n2 < this.getColumnCount() && n4 < 5; ++n2) {
            treeMapField = this.getTreeMapField(n2);
            if (!this.cpHelper.isAssignableFrom(String.class, treeMapField.getType()) && !this.isNumericType(treeMapField)) continue;
            this.getSettings().setShowPopup(this.getTreeMapField(n2), true);
            ++n4;
        }
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            treeMapField = this.getTreeMapField(n2);
            if (!this.isNumericType(treeMapField)) continue;
            this.getSettings().getFieldSettings(treeMapField).setShowLabel(true);
        }
    }

    protected void scheduleUpdateGroupBy() {
        this.c();
        this.t = true;
        this.i.restart();
    }

    void a() {
        Dimension dimension = this.getSettings().getDimension();
        if (dimension != null && dimension.width > 0 && dimension.height > 0) {
            if (this.s != null && this.s.isDone()) {
                try {
                    this.s.get();
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.c();
            this.r = new Worker();
            if (this.m != null) {
                try {
                    this.s = this.m.submit(this.r);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                try {
                    this.r.call();
                    this.r = null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void c() {
        if (this.r != null) {
            this.r.cancel();
        }
        if (this.s != null) {
            this.s.cancel(true);
        }
    }

    protected TreeMapSettings createSettings() {
        return new DefaultTreeMapSettings(this, this.colorFactory, this.fontFactory, this.colorMapFactory);
    }

    private DoubleIterable a(N n2, final TreeMapField<?, Column> treeMapField) {
        final MutableFilter<N> mutableFilter = this.getFilter();
        return DoubleIterables.conditional(this.preorderEnumeration(n2), (Iterables.Condition)new Iterables.Condition<N>(){

            public boolean a(N n2) {
                return AbstractTreeMapModel.this.hasNoChildren(n2) && !mutableFilter.isFiltered(n2);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((MutableTreeMapNode)object);
            }
        }, (DoubleIterables.DoubleConverter)new DoubleIterables.DoubleConverter<N>(){

            public double a(N n2) {
                Number number = (Number)AbstractTreeMapModel.this.getValueAt(n2, treeMapField.getIndex());
                if (number != null) {
                    return number.doubleValue();
                }
                return Double.NaN;
            }

            public /* synthetic */ double convert(Object object) {
                return this.a((MutableTreeMapNode)object);
            }
        });
    }

    private DoubleIterable b(N n2, final TreeMapField<?, Column> treeMapField) {
        final double d2 = this.getSumSize(n2);
        final MutableFilter<N> mutableFilter = this.getFilter();
        return DoubleIterables.conditional(this.preorderEnumeration(n2), (Iterables.Condition)new Iterables.Condition<N>(){

            public boolean a(N n2) {
                return AbstractTreeMapModel.this.hasNoChildren(n2) && !mutableFilter.isFiltered(n2);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((MutableTreeMapNode)object);
            }
        }, (DoubleIterables.DoubleConverter)new DoubleIterables.DoubleConverter<N>(){

            public double a(N n2) {
                Number number = (Number)AbstractTreeMapModel.this.getValueAt(n2, treeMapField.getIndex());
                if (number != null) {
                    return number.doubleValue() * n2.getSize() / d2;
                }
                return Double.NaN;
            }

            public /* synthetic */ double convert(Object object) {
                return this.a((MutableTreeMapNode)object);
            }
        });
    }

    protected void clearAggregationCache() {
        this.n.clear();
    }

    protected abstract AbstractTreeMapNode createRootNode(TreeMapField<N, Column> var1);

    protected void scheduleUpdateColors() {
        this.c();
        this.v = true;
        this.i.restart();
    }

    void b() {
        double d2 = this._settings.getLightSourceX();
        double d3 = this._settings.getLightSourceY();
        double d4 = this._settings.getLightSourceZ();
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        this.z = d2 / d5;
        this.A = d3 / d5;
        this.B = d4 / d5;
    }

    protected void fireTableModelChanged() {
        for (TreeMapListener treeMapListener : this.h) {
            treeMapListener.tableModelChanged();
        }
    }

    void a(TreeMapEvent treeMapEvent) {
        for (TreeMapListener treeMapListener : this.h) {
            treeMapListener.treeMapChanged(treeMapEvent);
        }
    }

    protected TreeMapField[] getTreeMapFields(int ... columns) {
        TreeMapField[] treeMapFieldArray = new TreeMapField[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            treeMapFieldArray[i2] = this.getTreeMapField(columns[i2]);
        }
        return treeMapFieldArray;
    }

    protected TreeMapField[] getTreeMapFields(Column ... columns) {
        TreeMapField[] treeMapFieldArray = new TreeMapField[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            Column Column = columns[i2];
            treeMapFieldArray[i2] = this.getTreeMapField(Column);
        }
        return treeMapFieldArray;
    }

    protected TreeMapField[] getTreeMapFields(String ... columnNames) {
        TreeMapField[] treeMapFieldArray = new TreeMapField[columnNames.length];
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            String string = columnNames[i2];
            treeMapFieldArray[i2] = this.getTreeMapFieldByName(string);
        }
        return treeMapFieldArray;
    }

    protected abstract boolean doGroupBy(N var1, TreeMapWorker var2);

    protected boolean doLayout(N parent, TreeMapWorker worker) {
        this.D = 0.0;
        this.computeSize(parent, worker);
        this.clearAggregationCache();
        Dimension dimension = this.getSettings().getDimension();
        if (dimension != null) {
            Rectangle2D rectangle2D = this.getViewport();
            this.setShape(parent, (Shape)rectangle2D);
            boolean bl = this.doLayoutChildren(parent, worker);
            return bl;
        }
        return false;
    }

    protected Rectangle2D getViewport() {
        Dimension dimension = this.getSettings().getDimension();
        TreeMapField treeMapField = this.getSettings().getHeightTreeMapField();
        double d2 = this.getSettings().getDefaultFieldSettings().getBorderThickness();
        double d3 = d2 / 2.0;
        if (treeMapField.isValid() && (this.isNumericType(treeMapField) || this.isTemporalType(treeMapField))) {
            int n2 = (int)(-this.getSettings().getMaximumHeight() * (double)Math.min(dimension.width, dimension.height));
            Labeling labeling = this.getSettings().getDefaultFieldSettings().getLabeling();
            int n3 = this.getSettings().getGroupByTreeMapFields().length;
            double d4 = -((double)n2 + (double)n3 * labeling.getLeftSpace(this));
            double d5 = -Math.min(0.0, (double)n2 + (double)n3 * labeling.getTopSpace(this));
            return new Rectangle2D.Double(d4 + d3, d5 + d3, (double)dimension.width - d4 - d2, (double)dimension.height - d5 - d2);
        }
        return new Rectangle2D.Double(0.0 + d3, 0.0 + d3, (double)dimension.width - d2, (double)dimension.height - d2);
    }

    protected void computeSize(N node, TreeMapWorker worker) {
        this.computeSizeLeafs(node, worker);
        this.computeSizeParents(node, worker);
        this.computeSumSize(node, worker);
    }

    protected void computeSizeLeafs(N root, TreeMapWorker worker) {
        TreeMapSettings treeMapSettings = this.getSettings();
        TreeMapField treeMapField = treeMapSettings.getSizeTreeMapField();
        Double d2 = this.getNumericMin(treeMapField);
        Double d3 = this.getNumericMax(treeMapField);
        if (d2 == null || d3 == null) {
            d2 = 0.0;
            d3 = 1.0;
        }
        Scale scale = treeMapSettings.getFieldSettings(treeMapField).getScale();
        Boolean bl = treeMapSettings.isHideFilterResults();
        Boolean bl2 = treeMapSettings.isHideSearchResults();
        for (MutableTreeMapNode mutableTreeMapNode : this.rowNode.values()) {
            double d4;
            if (bl.booleanValue() && this.getFilter().isFiltered((Object)mutableTreeMapNode)) {
                d4 = 0.0;
            } else if (bl2.booleanValue() && this.getSearch().isFiltered((Object)mutableTreeMapNode)) {
                d4 = 0.0;
            } else if (this.hasNoChildren((N)mutableTreeMapNode)) {
                if (treeMapField == null || !treeMapField.isValid() || this.isRoot(mutableTreeMapNode)) {
                    d4 = 1.0;
                } else {
                    Object object = this.getValueAt(mutableTreeMapNode, treeMapField.getIndex());
                    if (object != null) {
                        Serializable serializable;
                        if (object instanceof Number) {
                            serializable = (Number)object;
                            d4 = scale.transform(((Number)serializable).doubleValue(), d2, d3);
                        } else if (object instanceof Date) {
                            serializable = (Date)object;
                            d4 = scale.transform(((Date)serializable).getTime(), d2, d3);
                        } else {
                            d4 = 0.0;
                        }
                    } else {
                        d4 = 0.0;
                    }
                }
            } else {
                d4 = 0.0;
            }
            if (Double.isInfinite(d4) || Double.isNaN(d4)) {
                mutableTreeMapNode.setSize(0.0);
                continue;
            }
            mutableTreeMapNode.setSize(Math.max(0.0, d4));
            if (!mutableTreeMapNode.hasNoChildren()) continue;
            this.D = Math.max(this.D, d4);
        }
    }

    protected void computeSizeParents(N node, final TreeMapWorker worker) {
        if (!(node.isLeaf() || worker != null && worker.isCancelled())) {
            double d2;
            TreeMapField treeMapField = this.getSettings().getSizeTreeMapField();
            Aggregation aggregation = this.getSettings().getFieldSettings(treeMapField).getAggregation();
            if (treeMapField == null || !treeMapField.isValid() || aggregation == AggregationFactory.SUM_AGGREGATION) {
                DoubleIterable doubleIterable = DoubleIterables.conditional(this.getChildren(node), (Iterables.Condition)new Iterables.Condition<N>(){

                    public boolean a(N n2) {
                        AbstractTreeMapModel.this.computeSizeParents(n2, worker);
                        return true;
                    }

                    public /* synthetic */ boolean apply(Object object) {
                        return this.a((MutableTreeMapNode)object);
                    }
                }, (DoubleIterables.DoubleConverter)new DoubleIterables.DoubleConverter<N>(){

                    public double a(N n2) {
                        return n2.getSize();
                    }

                    public /* synthetic */ double convert(Object object) {
                        return this.a((MutableTreeMapNode)object);
                    }
                });
                Double d3 = AggregationFactory.SUM_AGGREGATION.aggregate(doubleIterable);
                d2 = d3 != null ? d3 : 0.0;
            } else {
                final MutableFilter<N> mutableFilter = this.getFilter();
                DoubleIterable doubleIterable = DoubleIterables.conditional(this.getChildren(node), (Iterables.Condition)new Iterables.Condition<N>(){

                    public boolean a(N n2) {
                        AbstractTreeMapModel.this.computeSumSize(n2, worker);
                        return AbstractTreeMapModel.this.isLeaf(n2) && !mutableFilter.isFiltered(n2);
                    }

                    public /* synthetic */ boolean apply(Object object) {
                        return this.a((MutableTreeMapNode)object);
                    }
                }, (DoubleIterables.DoubleConverter)new DoubleIterables.DoubleConverter<N>(){

                    public double a(N n2) {
                        return n2.getSize();
                    }

                    public /* synthetic */ double convert(Object object) {
                        return this.a((MutableTreeMapNode)object);
                    }
                });
                Double d4 = aggregation.aggregate(doubleIterable);
                d2 = d4 != null ? d4.doubleValue() : AggregationFactory.COUNT_AGGREGATION.aggregate(doubleIterable).doubleValue();
            }
            if (!Double.isFinite(d2)) {
                node.setSize(0.0);
            } else {
                node.setSize(Math.max(0.0, d2));
                if (node.hasNoChildren()) {
                    this.D = Math.max(this.D, d2);
                }
            }
        }
    }

    protected void computeSumSize(N node, final TreeMapWorker worker) {
        if (!(node.isLeaf() || worker != null && worker.isCancelled())) {
            DoubleIterable doubleIterable = DoubleIterables.conditional(this.getChildren(node), (Iterables.Condition)new Iterables.Condition<N>(){

                public boolean a(N n2) {
                    AbstractTreeMapModel.this.computeSumSize(n2, worker);
                    return true;
                }

                public /* synthetic */ boolean apply(Object object) {
                    return this.a((MutableTreeMapNode)object);
                }
            }, (DoubleIterables.DoubleConverter)new DoubleIterables.DoubleConverter<N>(){

                public double a(N n2) {
                    return n2.getSize();
                }

                public /* synthetic */ double convert(Object object) {
                    return this.a((MutableTreeMapNode)object);
                }
            });
            double d2 = AggregationFactory.SUM_AGGREGATION.aggregate(doubleIterable);
            node.setSumSize(d2);
        }
    }

    protected boolean doLayoutChildren(N currentRoot, TreeMapWorker worker) {
        Integer n2;
        Object object;
        Object object2;
        MutableTreeMapNode[] mutableTreeMapNodeArray;
        TreeMapFieldSettings treeMapFieldSettings;
        Object object3;
        Object object4;
        if (!worker.isCancelled()) {
            object4 = this.getSettings().getFieldSettings(this.getGroupByField(currentRoot)).getAlgorithm();
            object4.startLayout(this.getShape(currentRoot).getBounds2D(), this, currentRoot, worker);
        }
        if (!worker.isCancelled()) {
            object4 = this.depthFirstIterator(currentRoot);
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (MutableTreeMapNode)iterator.next();
                if (!worker.isCancelled()) {
                    if (this.hasNoChildren((N)object3)) continue;
                    treeMapFieldSettings = this.getSettings().getFieldSettings(this.getGroupByField((N)object3));
                    mutableTreeMapNodeArray = treeMapFieldSettings.getOrderingDirection() != null ? treeMapFieldSettings.getOrderingDirection() : Ordering.SortOrder.Descending;
                    MutableTreeMapNode[] mutableTreeMapNodeArray2 = new MutableTreeMapNode[this.getChildCount(object3)];
                    int n3 = 0;
                    object2 = this.getChildren(object3).iterator();
                    while (object2.hasNext()) {
                        object = (MutableTreeMapNode)object2.next();
                        mutableTreeMapNodeArray2[n3] = object;
                        ++n3;
                    }
                    mutableTreeMapNodeArray2 = treeMapFieldSettings.getOrdering().sort(this, mutableTreeMapNodeArray2, (Ordering.SortOrder)mutableTreeMapNodeArray);
                    if (mutableTreeMapNodeArray2.length <= 0) continue;
                    object2 = treeMapFieldSettings.getAlgorithm();
                    object = treeMapFieldSettings.getOrderingHorizontalVanishingPoint();
                    n2 = treeMapFieldSettings.getOrderingVerticalVanishingPoint();
                    object2.depthFirstLayout(currentRoot == object3 ? this.getShape((N)object3) : null, (MutableTreeMapNode)object3, mutableTreeMapNodeArray2, this.getSumSize((N)object3), object != null ? (Integer)object : 4, n2 != null ? n2 : 3, worker);
                    continue;
                }
                return true;
            }
        } else {
            return true;
        }
        if (!worker.isCancelled()) {
            object4 = this.breadthFirstIterator(currentRoot);
            int n4 = 0;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                treeMapFieldSettings = (MutableTreeMapNode)object3.next();
                if (!worker.isCancelled()) {
                    if (this.hasNoChildren((N)treeMapFieldSettings)) continue;
                    if (currentRoot == this.getParent(treeMapFieldSettings)) {
                        this.setProgress(n4 * 99 / this.getChildCount(currentRoot));
                        ++n4;
                    }
                    mutableTreeMapNodeArray = new MutableTreeMapNode[this.getChildCount(treeMapFieldSettings)];
                    int n5 = 0;
                    TreeMapFieldSettings treeMapFieldSettings2 = this.getChildren(treeMapFieldSettings).iterator();
                    while (treeMapFieldSettings2.hasNext()) {
                        mutableTreeMapNodeArray[n5] = object2 = (MutableTreeMapNode)treeMapFieldSettings2.next();
                        ++n5;
                    }
                    treeMapFieldSettings2 = this.getSettings().getFieldSettings(this.getGroupByField((N)treeMapFieldSettings));
                    Object object5 = object2 = treeMapFieldSettings2.getOrderingDirection() != null ? treeMapFieldSettings2.getOrderingDirection() : Ordering.SortOrder.Descending;
                    mutableTreeMapNodeArray = treeMapFieldSettings2.getOrdering().sort(this, mutableTreeMapNodeArray, (Ordering.SortOrder)((Object)object2));
                    if (mutableTreeMapNodeArray.length <= 0) continue;
                    object = treeMapFieldSettings2.getAlgorithm();
                    if (object.isCompatible((Shape)(n2 = this.getShape((N)treeMapFieldSettings)))) {
                        n2 = treeMapFieldSettings2.getNesting().getNested(this, currentRoot, treeMapFieldSettings, (Shape)n2);
                        treeMapFieldSettings.setNestedShape((Shape)n2);
                        Integer n6 = treeMapFieldSettings2.getOrderingHorizontalVanishingPoint();
                        Integer n7 = treeMapFieldSettings2.getOrderingVerticalVanishingPoint();
                        object.breadthFirstLayout((Shape)n2, (MutableTreeMapNode)((Object)treeMapFieldSettings), mutableTreeMapNodeArray, this.getSumSize((N)treeMapFieldSettings), n6 != null ? n6 : 4, n7 != null ? n7 : 3, worker);
                        continue;
                    }
                    for (MutableTreeMapNode mutableTreeMapNode : mutableTreeMapNodeArray) {
                        mutableTreeMapNode.setShape(null);
                    }
                    continue;
                }
                return true;
            }
        } else {
            return true;
        }
        if (!worker.isCancelled()) {
            object4 = this.getSettings().getFieldSettings(this.getChildrenGroupByField(currentRoot)).getAlgorithm();
            object4.finishLayout((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, (double)this.getSettings().getDimension().width, (double)this.getSettings().getDimension().height), this, currentRoot);
            return false;
        }
        return true;
    }

    @Override
    public double getSumSize(N node) {
        return node.getSumSize();
    }

    protected boolean doColors(N parent, TreeMapWorker worker) {
        TreeMapField treeMapField = this.getSettings().getColorTreeMapField();
        if (treeMapField != null) {
            MutableColorMap mutableColorMap = this.getColorMap();
            for (MutableTreeMapNode mutableTreeMapNode : this.preorderEnumeration(parent)) {
                if (worker == null || !worker.isCancelled()) {
                    CPColor cPColor;
                    Object object;
                    if (this.hasNoChildren((N)mutableTreeMapNode)) {
                        Object object2 = object = treeMapField.isValid() ? this.getValueAt(mutableTreeMapNode, treeMapField.getIndex()) : null;
                        if (mutableColorMap != null) {
                            cPColor = mutableColorMap.getColor(object);
                            assert (cPColor != null) : "ColorMap " + String.valueOf(mutableColorMap) + " returned null";
                            this.setColor((N)mutableTreeMapNode, (CPColor<Color>)cPColor);
                            continue;
                        }
                        if (object != null && object instanceof CPColor) {
                            this.setColor((N)mutableTreeMapNode, (CPColor<Color>)((CPColor)object));
                            continue;
                        }
                        this.setColor((N)mutableTreeMapNode, (CPColor<Color>)this.colorFactory.getLightGray());
                        continue;
                    }
                    if (treeMapField.isValid()) {
                        if (this.cpHelper.isAssignableFrom(Number.class, this.getColumnClass(treeMapField.getIndex()))) {
                            cPColor = this.b(mutableTreeMapNode, treeMapField);
                            object = AggregationFactory.SIZE_WEIGHTED_AGGREGATION.aggregate((DoubleIterable)cPColor);
                        } else {
                            object = this.getAggregateValue(mutableTreeMapNode, treeMapField);
                        }
                    } else {
                        object = null;
                    }
                    if (mutableColorMap != null) {
                        cPColor = mutableColorMap.getColor(object);
                        this.setColor((N)mutableTreeMapNode, (CPColor<Color>)cPColor);
                        continue;
                    }
                    if (object != null && object instanceof CPColor) {
                        this.setColor((N)mutableTreeMapNode, (CPColor<Color>)((CPColor)object));
                        continue;
                    }
                    this.setColor((N)mutableTreeMapNode, (CPColor<Color>)this.colorFactory.getLightGray());
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    protected MutableColorMap getColorMap() {
        TreeMapField treeMapField = this.getSettings().getColorTreeMapField();
        return this.getColorMap(treeMapField);
    }

    @Override
    public MutableColorMap<Color> getColorMap(TreeMapField<N, Column> field) {
        if (field.isValid()) {
            TreeMapFieldSettings treeMapFieldSettings = this.getSettings().getFieldSettings(field);
            MutableColorMap mutableColorMap = treeMapFieldSettings.getColorMap();
            if (mutableColorMap == null) {
                mutableColorMap = this.createDefaultColorMap(field);
                treeMapFieldSettings.setColorMap(mutableColorMap);
            }
            return mutableColorMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableColorMap<Color> getCategoricalColorMap(Column columnIndex) {
        Map<TreeMapField, MutableColorMap> map = this.F;
        synchronized (map) {
            TreeMapField treeMapField = this.getTreeMapField(columnIndex);
            MutableColorMap<Color> mutableColorMap = this.F.get(treeMapField);
            if (mutableColorMap == null) {
                mutableColorMap = this.createCategoricalColorMap(treeMapField);
                this.F.put(treeMapField, mutableColorMap);
            }
            return mutableColorMap;
        }
    }

    protected abstract MutableColorMap<Color> createCategoricalColorMap(TreeMapField<N, Column> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableColorMap<Color> getPredefinedColorMap(Column columnIndex) {
        Map<TreeMapField, MutableColorMap> map = this.G;
        synchronized (map) {
            TreeMapField treeMapField = this.getTreeMapField(columnIndex);
            MutableColorMap mutableColorMap = this.G.get(treeMapField);
            if (mutableColorMap == null) {
                mutableColorMap = this.colorMapFactory.createAutoContinuousColorMap((Number)this.getNumericMin(treeMapField), (Number)this.getNumericMax(treeMapField));
                this.G.put(treeMapField, mutableColorMap);
            }
            return mutableColorMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableColorMap<Color> getCustomColorMap(Column columnIndex) {
        Map<TreeMapField, MutableColorMap> map = this.H;
        synchronized (map) {
            TreeMapField treeMapField = this.getTreeMapField(columnIndex);
            MutableColorMap mutableColorMap = this.H.get(treeMapField);
            if (mutableColorMap == null) {
                mutableColorMap = this.colorMapFactory.createAutoSegmentedColorMap((Number)this.getNumericMin(treeMapField), (Number)this.getNumericMax(treeMapField));
                this.H.put(treeMapField, mutableColorMap);
            }
            return mutableColorMap;
        }
    }

    @Override
    public double getSize(N node) {
        return node.getSize();
    }

    @Override
    public double getMaximumSize() {
        return this.D;
    }

    @Override
    public void setShape(N node, Shape shape) {
        node.setShape(shape);
    }

    @Override
    public Shape getShape(N node) {
        return node.getShape();
    }

    @Override
    public void setNestedShape(N node, Shape shape) {
        node.setNestedShape(shape);
    }

    @Override
    public Shape getNestedShape(N node) {
        return node.getNestedShape();
    }

    @Override
    public Rectangle2D getBounds(N node) {
        return node.getBounds();
    }

    @Override
    public int getLevel(N node) {
        return node.getLevel();
    }

    @Override
    public TreeMapField<N, Column> getGroupByField(N node) {
        return node.getGroupByField();
    }

    @Override
    public TreeMapField<N, Column> getChildrenGroupByField(N node) {
        return node.getChildrenGroupByField();
    }

    @Override
    public boolean hasNoChildren(N node) {
        return node == null || node.hasNoChildren();
    }

    @Override
    public boolean isLeaf(N node) {
        return node.isLeaf();
    }

    @Override
    public Iterable<N> parentPreorderEnumeration(N parent) {
        return new Iterable<N>(){
            final /* synthetic */ MutableTreeMapNode a;
            {
                this.a = mutableTreeMapNode;
            }

            @Override
            public Iterator<N> iterator() {
                return new I(AbstractTreeMapModel.this, this.a);
            }
        };
    }

    @Override
    public Iterable<N> preorderEnumeration(N parent) {
        return new Iterable<N>(){
            final /* synthetic */ MutableTreeMapNode a;
            {
                this.a = mutableTreeMapNode;
            }

            @Override
            public Iterator<N> iterator() {
                return new K(AbstractTreeMapModel.this, this.a);
            }
        };
    }

    @Override
    public Iterable<N> breadthFirstIterator(N parent) {
        return new Iterable<N>(){
            final /* synthetic */ MutableTreeMapNode a;
            {
                this.a = mutableTreeMapNode;
            }

            @Override
            public Iterator<N> iterator() {
                return new BreadthFirstIterator(AbstractTreeMapModel.this, this.a);
            }
        };
    }

    @Override
    public Iterable<N> depthFirstIterator(N parent) {
        return new Iterable<N>(){
            final /* synthetic */ MutableTreeMapNode a;
            {
                this.a = mutableTreeMapNode;
            }

            @Override
            public Iterator<N> iterator() {
                return new J(AbstractTreeMapModel.this, this.a);
            }
        };
    }

    @Override
    public double getNormalizedLightSourceX() {
        return this.z;
    }

    @Override
    public double getNormalizedLightSourceY() {
        return this.A;
    }

    @Override
    public double getNormalizedLightSourceZ() {
        return this.B;
    }

    @Override
    @JsMethod
    public Object getAggregateValue(N node, final TreeMapField<N, Column> field) {
        if (field != null && field.isValid()) {
            Column Column = field.getIndex();
            if (this.hasNoChildren(node)) {
                return this.getValueAt(node, Column);
            }
            a<N> a2 = new a<N>(node, field);
            if (this.n.containsKey(a2)) {
                return this.n.get(a2);
            }
            if (this.cpHelper.isAssignableFrom(Number.class, this.getColumnClass(Column))) {
                Aggregation aggregation = this.getSettings().getFieldSettings(this.getTreeMapField(Column)).getAggregation();
                if (aggregation == AggregationFactory.SUM_AGGREGATION) {
                    DoubleIterable doubleIterable = DoubleIterables.conditional(this.getChildren(node), (Iterables.Condition)new Iterables.Condition<N>(){

                        public boolean a(N n2) {
                            return !AbstractTreeMapModel.this.getFilter().isFiltered(n2) && !AbstractTreeMapModel.this.getSearch().isFiltered(n2);
                        }

                        public /* synthetic */ boolean apply(Object object) {
                            return this.a((MutableTreeMapNode)object);
                        }
                    }, (DoubleIterables.DoubleConverter)new DoubleIterables.DoubleConverter<N>(){

                        public double a(N n2) {
                            Number number = (Number)AbstractTreeMapModel.this.getAggregateValue(n2, field);
                            if (number != null) {
                                return number.doubleValue();
                            }
                            return Double.NaN;
                        }

                        public /* synthetic */ double convert(Object object) {
                            return this.a((MutableTreeMapNode)object);
                        }
                    });
                    Double d2 = aggregation.aggregate(doubleIterable);
                    if (d2 != null) {
                        this.n.put(a2, d2);
                    }
                    return d2;
                }
                DoubleIterable doubleIterable = aggregation.requestSizeWeightValues() ? this.b(node, field) : this.a(node, field);
                Double d3 = aggregation.aggregate(doubleIterable);
                if (d3 != null) {
                    this.n.put(a2, d3);
                }
                return d3;
            }
            if (this.cpHelper.isAssignableFrom(String.class, this.getColumnClass(Column))) {
                String string = null;
                boolean bl = true;
                for (MutableTreeMapNode mutableTreeMapNode : this.getChildren(node)) {
                    if (this.getFilter().isFiltered((Object)mutableTreeMapNode) || this.getSearch().isFiltered((Object)mutableTreeMapNode)) continue;
                    String string2 = (String)this.getAggregateValue(mutableTreeMapNode, field);
                    if (bl) {
                        string = string2;
                        bl = false;
                        continue;
                    }
                    if (string == null || string.equals(string2)) continue;
                    string = null;
                    break;
                }
                return string;
            }
            return null;
        }
        return null;
    }

    @Override
    public String getStringValue(N node, TreeMapField<N, Column> field, TreeMapFieldSettings<Color, Font> settings) {
        if (field != null && field.isValid() && node != null) {
            String string;
            Object object = this.hasNoChildren(node) ? this.getValueAt(node, field.getIndex()) : this.getAggregateValue(node, field);
            CPFormat cPFormat = settings.getFormat();
            if (cPFormat != null) {
                try {
                    return cPFormat.formatHtml(object, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return " ";
                }
            }
            if (object == null) {
                object = " ";
            }
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Number) {
                string = this.formatFactory.createDecimalFormat().formatHtml(object, false);
            } else {
                if (object.getClass().isArray()) {
                    Object[] objectArray = (Object[])object;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        Object object2 = objectArray[i2];
                        stringBuilder.append(object2);
                        if (i2 >= objectArray.length - 1) continue;
                        stringBuilder.append("/");
                    }
                    return stringBuilder.toString();
                }
                string = object.toString();
            }
            return string;
        }
        return null;
    }

    @Override
    public N getRoot() {
        return this.p;
    }

    @Override
    public N getCurrentRoot() {
        return (N)((MutableTreeMapNode)this.q.getValue());
    }

    @Override
    public void setCurrentRoot(N currentRoot) {
        this.q.setValue(currentRoot);
    }

    protected void scheduleUpdateLayout() {
        this.c();
        this.u = true;
        this.i.restart();
    }

    @Override
    public MutableSingleSelection<N> getProbing() {
        return this.c;
    }

    @Override
    public MutableSelection<N> getHighlighting() {
        return this.d;
    }

    @Override
    public MutableSelection<N> getSelection() {
        return this.e;
    }

    @Override
    public MutableFilter<N> getFilter() {
        return this.f;
    }

    @Override
    public MutableFilter<N> getSearch() {
        return this.g;
    }

    @Override
    public TreeMapSettings getSettings() {
        return this._settings;
    }

    @Override
    public TreeMapWorker getWorker() {
        return this.r;
    }

    @Override
    public Future<Void> getWorkerFuture() {
        return this.s;
    }

    @Override
    public void addListener(TreeMapListener treeMapListener) {
        this.h.add(treeMapListener);
    }

    @Override
    public void removeListener(TreeMapListener treeMapListener) {
        this.h.remove(treeMapListener);
    }

    @Override
    public N getNode(Point position) {
        Object object;
        Shape shape;
        Object object2;
        if (position != null && (object2 = this.getCurrentRoot()) != null && (shape = this.getShape((N)object2)) != null && shape.contains((Point2D)new Point2D.Double(position.getX(), position.getY())) && (object = this.a(object2, position)) != null && object != object2 && !this.getFilter().isFiltered(object) && !this.getSearch().isFiltered(object)) {
            return (N)object;
        }
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.v || this.u || this.t;
    }

    @Override
    public void waitUntilReady() {
        this.cpHelper.sleep(100L);
        while (this.isDirty()) {
            this.cpHelper.sleep(50L);
            while (this.getRoot() == null || this.getShape((N)this.getRoot()) == null) {
                this.cpHelper.sleep(50L);
            }
            Future<Void> future = this.getWorkerFuture();
            while (future == null || !future.isDone() || future.isCancelled()) {
                try {
                    future.get();
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                future = this.getWorkerFuture();
            }
        }
    }

    @Override
    public ColorProvider<N, Color> getColorProvider() {
        return this.E;
    }

    @Override
    public void setColorProvider(ColorProvider<N, Color> colorProvider) {
        if (this.E != colorProvider) {
            this.E = colorProvider;
            this.scheduleUpdateColors();
        }
    }

    @Override
    public CPColor<Color> getColor(N node) {
        return this.E.getColor(node);
    }

    @Override
    public void setColor(N node, CPColor<Color> color) {
        node.setColor(color);
    }

    @Override
    public MutableProperty<Integer> progressProperty() {
        return this.C;
    }

    public void setProgress(int progress) {
        this.C.setValue((Object)progress);
    }

    private N a(N n2, Point point) {
        for (MutableTreeMapNode mutableTreeMapNode : this.getChildren(n2)) {
            Shape shape = this.getShape((N)mutableTreeMapNode);
            if (shape == null && !this.hasNoChildren(n2)) {
                MutableTreeMapNode mutableTreeMapNode2 = this.a(mutableTreeMapNode, point);
                if (mutableTreeMapNode2 == mutableTreeMapNode) continue;
                return (N)mutableTreeMapNode2;
            }
            if (!this.a(point, shape)) continue;
            return (N)this.a(mutableTreeMapNode, point);
        }
        return n2;
    }

    private boolean a(Point point, Shape shape) {
        if (shape instanceof TextShape) {
            return shape.getBounds2D().contains((Point2D)new Point2D.Double((double)point.x, (double)point.y));
        }
        return shape.contains((Point2D)new Point2D.Double(point.getX(), point.getY()));
    }

    private AbstractTreeMapModel d() {
        return this;
    }

    @Override
    public String getFormatPattern(int columnIndex) {
        CPFormat cPFormat = this.getSettings().getFieldSettings(this.getTreeMapField(columnIndex)).getFormat();
        if (cPFormat != null) {
            return cPFormat.getPattern();
        }
        return null;
    }

    @Override
    public void setFormatPattern(int columnIndex, String pattern) {
        TreeMapField treeMapField = this.getTreeMapField(columnIndex);
        if (this.isNumericType(treeMapField)) {
            this.getSettings().getFieldSettings(treeMapField).setFormat(this.formatFactory.createNumberFormat(pattern));
        } else if (this.isTemporalType(treeMapField)) {
            this.getSettings().getFieldSettings(treeMapField).setFormat(this.formatFactory.createDateFormat(pattern));
        }
    }

    @Override
    public CPColorFactory<Color> getColorFactory() {
        return this.colorFactory;
    }

    @Override
    public CPImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public class Worker
    implements TreeMapWorker,
    Callable<Void> {
        private boolean b = false;

        @Override
        public Void call() throws Exception {
            try {
                if ((AbstractTreeMapModel.this.t || AbstractTreeMapModel.this.u || AbstractTreeMapModel.this.v) && !this.isCancelled()) {
                    MutableTreeMapNode mutableTreeMapNode;
                    Object object;
                    this.setProgress(0);
                    if (AbstractTreeMapModel.this.t) {
                        if (!this.isCancelled()) {
                            TreeMapField<N, Column>[] treeMapFieldArray = AbstractTreeMapModel.this._settings.getGroupByTreeMapFields();
                            object = treeMapFieldArray == null || treeMapFieldArray.length == 0 ? AbstractTreeMapModel.this.createRootNode(AbstractTreeMapModel.this._settings.getSizeTreeMapField()) : AbstractTreeMapModel.this.createRootNode(treeMapFieldArray[0]);
                            mutableTreeMapNode = object;
                            AbstractTreeMapModel.this.doGroupBy(object, this);
                            if (this.isCancelled()) {
                                AbstractTreeMapModel.this.t = true;
                                return null;
                            }
                            AbstractTreeMapModel.this.p = object;
                            AbstractTreeMapModel.this.w = true;
                            AbstractTreeMapModel.this.t = false;
                            AbstractTreeMapModel.this.u = true;
                            AbstractTreeMapModel.this.v = true;
                            AbstractTreeMapModel.this.q.setValue((Object)mutableTreeMapNode);
                        } else {
                            object = AbstractTreeMapModel.this.p;
                            mutableTreeMapNode = (MutableTreeMapNode)AbstractTreeMapModel.this.q.getValue();
                        }
                    } else {
                        object = AbstractTreeMapModel.this.p;
                        mutableTreeMapNode = (MutableTreeMapNode)AbstractTreeMapModel.this.q.getValue();
                    }
                    if (AbstractTreeMapModel.this.u) {
                        if (!this.isCancelled() && mutableTreeMapNode != null && AbstractTreeMapModel.this._settings.getDimension() != null) {
                            AbstractTreeMapModel.this.doLayout(mutableTreeMapNode, this);
                        }
                        if (this.isCancelled()) {
                            AbstractTreeMapModel.this.u = true;
                            return null;
                        }
                        AbstractTreeMapModel.this.x = true;
                        AbstractTreeMapModel.this.u = false;
                        AbstractTreeMapModel.this.v = true;
                    }
                    if (AbstractTreeMapModel.this.v) {
                        if (!this.isCancelled() && object != null) {
                            AbstractTreeMapModel.this.b();
                            AbstractTreeMapModel.this.doColors(object, this);
                        }
                        if (this.isCancelled()) {
                            AbstractTreeMapModel.this.v = true;
                            return null;
                        }
                        AbstractTreeMapModel.this.y = true;
                        AbstractTreeMapModel.this.v = false;
                    }
                    if (!this.isCancelled()) {
                        AbstractTreeMapModel.this.p = object;
                        AbstractTreeMapModel.this.q.setValue((Object)mutableTreeMapNode);
                        AbstractTreeMapModel.this.clearAggregationCache();
                        AbstractTreeMapModel.this.a(new TreeMapEvent(AbstractTreeMapModel.this.w, AbstractTreeMapModel.this.x, AbstractTreeMapModel.this.y));
                        AbstractTreeMapModel.this.w = false;
                        AbstractTreeMapModel.this.x = false;
                        AbstractTreeMapModel.this.y = false;
                        this.setProgress(100);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return null;
        }

        @Override
        public void cancel() {
            this.b = true;
            this.setProgress(0);
        }

        @Override
        public boolean isCancelled() {
            return this.b;
        }

        @Override
        public void setProgress(int progress) {
            AbstractTreeMapModel.this.setProgress(progress);
        }
    }

    private final class a<N> {
        private final N b;
        private final TreeMapField<N, Column> c;

        private a(N n2, TreeMapField<N, Column> treeMapField) {
            this.b = n2;
            this.c = treeMapField;
        }

        public int hashCode() {
            int n2 = this.b.hashCode();
            n2 = 31 * n2 + this.c.hashCode();
            return n2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            a a2 = (a)o2;
            if (!this.c.equals(a2.c)) {
                return false;
            }
            return this.b.equals(a2.b);
        }
    }
}

