/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.Algorithm;
import com.treemap.Itertools;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class CirclePackingAlgorithm<N, Row, Column, Color, Font>
implements Algorithm<N, Row, Column, Color, Font> {
    private static boolean a = true;
    protected int verticalAlignment = 0;
    protected int horizontalAlignment = 0;

    @Override
    public MutableProperties getProperties() {
        return null;
    }

    @Override
    public Iterable iterator(TreeMapModel<N, Row, Column, Color, Font> model, N root) {
        return model.depthFirstIterator(root);
    }

    @Override
    public void startLayout(Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root, TreeMapWorker worker) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean depthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        void var13_21;
        Ellipse2D ellipse2D;
        Object object;
        Circle circle3;
        ArrayList<Circle> arrayList = new ArrayList<Circle>();
        for (MutableTreeMapNode rectangle2D2 : children) {
            circle3 = new Circle();
            if (rectangle2D2.hasNoChildren()) {
                circle3.radius = Math.max(0.0, Math.sqrt(rectangle2D2.getSize() / Math.PI));
            } else {
                object = rectangle2D2.getShape();
                if (object != null) {
                    if (object instanceof Ellipse2D) {
                        ellipse2D = (Ellipse2D)object;
                        circle3.radius = ellipse2D.getWidth() / 2.0;
                    } else {
                        circle3.radius = Math.max(0.0, Math.sqrt(rectangle2D2.getSize() / Math.PI));
                    }
                } else {
                    circle3.radius = Math.max(0.0, Math.sqrt(rectangle2D2.getSize() / Math.PI));
                }
            }
            arrayList.add(circle3);
        }
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        Collections.sort(arrayList2);
        ArrayList<Circle> arrayList3 = CirclePackingAlgorithm.a(arrayList2);
        for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
            Circle circle2 = arrayList3.get(i2);
            circle3 = (Circle)arrayList2.get(i2);
            circle3.cx = circle2.cx;
            circle3.cy = circle2.cy;
            circle3.radius = circle2.radius;
        }
        Circle circle2 = CirclePackingAlgorithm.b(arrayList);
        for (Circle circle3 : arrayList) {
            circle3.cx -= circle2.cx;
            circle3.cy -= circle2.cy;
        }
        circle2 = CirclePackingAlgorithm.b(arrayList);
        if (shape == null) {
            if (circle2 != null && !Double.isNaN(circle2.radius)) {
                Rectangle2D rectangle2D = circle2.getBounds2D();
                parent.setShape((Shape)new Ellipse2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
            } else {
                parent.setShape(null);
            }
        }
        boolean bl = false;
        while (var13_21 < children.length) {
            circle3 = arrayList.get((int)var13_21);
            object = children[var13_21];
            if (circle3 != null && !Double.isNaN(circle3.radius) && circle3.radius > 0.0) {
                ellipse2D = circle3.getBounds2D();
                object.setShape((Shape)new Ellipse2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight()));
            } else {
                object.setShape(null);
            }
            ++var13_21;
        }
        return false;
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D rectangle2D2 = this.a(children);
        if (rectangle2D2 != null) {
            double d2 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
            double d3 = d2 / rectangle2D2.getWidth();
            double d4 = d2 / rectangle2D2.getHeight();
            for (MutableTreeMapNode mutableTreeMapNode : children) {
                double d5 = -rectangle2D2.getMinX() * d3 + rectangle2D.getX();
                double d6 = -rectangle2D2.getMinY() * d4 + rectangle2D.getY();
                switch (this.horizontalAlignment) {
                    case 0: {
                        d5 += (rectangle2D.getWidth() - d2) / 2.0;
                        break;
                    }
                    case 2: {
                        d5 += rectangle2D.getWidth() - d2;
                    }
                }
                switch (this.verticalAlignment) {
                    case 0: {
                        d6 += (rectangle2D.getHeight() - d2) / 2.0;
                        break;
                    }
                    case 3: {
                        d6 += rectangle2D.getHeight() - d2;
                    }
                }
                AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d4, d5, d6);
                Shape shape2 = mutableTreeMapNode.getShape();
                if (shape2 != null) {
                    Rectangle2D rectangle2D3 = shape2.getBounds2D();
                    Shape shape3 = affineTransform.createTransformedShape((Shape)new Rectangle2D.Double(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight()));
                    Rectangle2D rectangle2D4 = shape3.getBounds2D();
                    mutableTreeMapNode.setShape((Shape)new Ellipse2D.Double(rectangle2D4.getX(), rectangle2D4.getY(), rectangle2D4.getWidth(), rectangle2D4.getHeight()));
                    continue;
                }
                mutableTreeMapNode.setShape(null);
            }
        } else {
            for (MutableTreeMapNode mutableTreeMapNode : children) {
                mutableTreeMapNode.setShape(null);
            }
        }
        return false;
    }

    private Rectangle2D a(MutableTreeMapNode[] mutableTreeMapNodeArray) {
        ArrayList<Circle> arrayList = new ArrayList<Circle>();
        for (MutableTreeMapNode mutableTreeMapNode : mutableTreeMapNodeArray) {
            Shape shape = mutableTreeMapNode.getShape();
            if (shape == null || !(shape instanceof Ellipse2D)) continue;
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            Circle circle = new Circle(ellipse2D.getCenterX(), ellipse2D.getCenterY(), ellipse2D.getWidth() / 2.0);
            arrayList.add(circle);
        }
        if (arrayList.size() > 0) {
            Circle circle = CirclePackingAlgorithm.b(arrayList);
            Rectangle2D rectangle2D = circle.getBounds2D();
            return new Ellipse2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()).getBounds2D();
        }
        return null;
    }

    @Override
    public void finishLayout(Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root) {
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return true;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return true;
    }

    @Override
    public boolean isChildContained() {
        return true;
    }

    @Override
    public boolean isColorParent() {
        return false;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    String a() {
        return "Circle Packing";
    }

    public String toString() {
        return this.a();
    }

    static ArrayList<Circle> a(ArrayList<Circle> arrayList) {
        switch (arrayList.size()) {
            case 0: {
                return arrayList;
            }
            case 1: {
                Circle circle = arrayList.get(0);
                circle.cx = 0.0;
                circle.cy = 0.0;
                return arrayList;
            }
        }
        ArrayList<Circle> arrayList2 = new ArrayList<Circle>();
        double d2 = 2.220446049250313E-16;
        for (Circle circle : arrayList) {
            System.out.println("Processing " + String.valueOf(circle));
            double d3 = circle.radius;
            int n2 = arrayList2.size();
            if (n2 <= 1) {
                double d4 = n2 == 0 ? d3 : -d3;
                Iterator<Circle> iterator = circle;
                ((Circle)((Object)iterator)).cx = d4;
                ((Circle)((Object)iterator)).cy = 0.0;
                ((Circle)((Object)iterator)).radius = d3;
                arrayList2.add((Circle)((Object)iterator));
                System.out.println("Initial " + String.valueOf(iterator));
                continue;
            }
            Double d5 = null;
            Circle circle2 = null;
            for (List list : Itertools.combinations(arrayList2, 2)) {
                Circle circle3 = (Circle)list.get(0);
                Circle circle4 = (Circle)list.get(1);
                double d4 = d2;
                for (Circle circle5 : CirclePackingAlgorithm.a(d3, circle3, circle4, d4)) {
                    if (circle5 == null) continue;
                    ArrayList<Circle> arrayList3 = new ArrayList<Circle>(arrayList2);
                    if (circle3 != null) {
                        arrayList3.remove(circle3);
                    }
                    if (circle4 != null) {
                        arrayList3.remove(circle4);
                    }
                    boolean bl = false;
                    for (Circle circle6 : arrayList3) {
                        double d6 = CirclePackingAlgorithm.a(circle6, circle5);
                        if (!(d6 < -d2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    double d7 = CirclePackingAlgorithm.a(circle5, arrayList2, circle3, circle4);
                    if (d5 != null && !(d7 > d5)) continue;
                    d5 = d7;
                    circle2 = circle5;
                }
            }
            if (circle2 == null) {
                System.err.println("cannot place circle for value " + String.valueOf(circle));
                for (Circle circle7 : arrayList) {
                    System.err.println("Circle: " + String.valueOf(circle7));
                }
                circle2 = circle;
            }
            System.out.println("Placing " + String.valueOf(circle2));
            arrayList2.add(circle2);
        }
        return arrayList2;
    }

    private static double a(Circle circle, Circle circle2) {
        double d2 = circle.cx;
        double d3 = circle.cy;
        double d4 = circle.radius;
        double d5 = circle2.cx;
        double d6 = circle2.cy;
        double d7 = circle2.radius;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        return Math.sqrt(d8 * d8 + d9 * d9) - d4 - d7;
    }

    private static double a(Circle circle, ArrayList<Circle> arrayList, Circle circle2, Circle circle3) {
        double d2 = 0.0;
        for (Circle circle4 : arrayList) {
            if (circle2 != null && circle2.equals(circle4) || circle3 != null && circle3.equals(circle4)) continue;
            d2 += Math.sqrt(Math.pow(circle.getCY() - circle4.getCY(), 2.0) + Math.pow(circle.getCX() - circle4.getCX(), 2.0));
        }
        return -Math.sqrt(d2);
    }

    private static Circle[] a(double d2, Circle circle, Circle circle2, double d3) {
        Circle circle3;
        Circle circle4;
        Circle circle5;
        Circle circle6;
        if (a) {
            circle6 = new Circle(circle.cx, circle.cy, circle.radius + (d2 + d3));
            circle5 = new Circle(circle2.cx, circle2.cy, circle2.radius + (d2 + d3));
        } else {
            circle6 = circle;
            circle6.radius += d2 + d3;
            circle5 = circle2;
            circle5.radius += d2 + d3;
        }
        Point2D[] point2DArray = CirclePackingAlgorithm.b(circle6, circle5);
        Point2D point2D = point2DArray[0];
        Point2D point2D2 = point2DArray[1];
        if (point2D == null) {
            return new Circle[]{null, null};
        }
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        if (a) {
            circle4 = new Circle(d4, d5, d2);
        } else {
            circle4 = circle6;
            circle4.cx = d4;
            circle4.cy = d5;
            circle4.radius = d2;
        }
        if (point2D2 == null) {
            return new Circle[]{circle4, null};
        }
        double d6 = point2D2.getX();
        double d7 = point2D2.getY();
        if (a) {
            circle3 = new Circle(d6, d7, d2);
        } else {
            circle3 = circle5;
            circle3.cx = d6;
            circle3.cy = d7;
            circle3.radius = d2;
        }
        return new Circle[]{circle4, circle3};
    }

    private static Point2D[] b(Circle circle, Circle circle2) {
        double d2 = circle.cx;
        double d3 = circle.cy;
        double d4 = circle.radius;
        double d5 = circle2.cx;
        double d6 = circle2.cy;
        double d7 = circle2.radius;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        if (d10 > d4 + d7) {
            System.err.println("no solution, the circles are separate: " + String.valueOf(circle) + ", " + String.valueOf(circle2));
            return new Point2D[]{null, null};
        }
        if (d10 < Math.abs(d4 - d7)) {
            System.err.println("no solution, circles contained within each other: " + String.valueOf(circle) + ", " + String.valueOf(circle2));
            return new Point2D[]{null, null};
        }
        if (d10 == 0.0 && d4 == d7) {
            System.err.println("no solution, circles are coincident: " + String.valueOf(circle) + ", " + String.valueOf(circle2));
            return new Point2D[]{null, null};
        }
        double d11 = (d4 * d4 - d7 * d7 + d10 * d10) / (2.0 * d10);
        double d12 = Math.sqrt(d4 * d4 - d11 * d11);
        double d13 = d2 + d11 * d8 / d10;
        double d14 = d3 + d11 * d9 / d10;
        double d15 = d13 + d12 * d9 / d10;
        double d16 = d13 - d12 * d9 / d10;
        double d17 = d14 - d12 * d8 / d10;
        double d18 = d14 + d12 * d8 / d10;
        if (d15 == d16 && d17 == d18) {
            return new Point2D[]{new Point2D.Double(d15, d17), null};
        }
        return new Point2D[]{new Point2D.Double(d15, d17), new Point2D.Double(d16, d18)};
    }

    private static Circle a(Circle circle, Circle circle2, Circle circle3) {
        double d2 = circle.radius;
        double d3 = circle2.radius;
        double d4 = circle3.radius;
        double d5 = 1.0 / d2;
        double d6 = 1.0 / d3;
        double d7 = 1.0 / d4;
        double d8 = Math.abs(d5 + d6 + d7 - 2.0 * Math.sqrt(d5 * d6 + d6 * d7 + d7 * d5));
        a a2 = new a(d5, 0.0).c(new a(circle.cx, circle.cy));
        a a3 = new a(d6, 0.0).c(new a(circle2.cx, circle2.cy));
        a a4 = new a(d7, 0.0).c(new a(circle3.cx, circle3.cy));
        a a5 = a2.a(a3).a(a4).b(new a(2.0, 0.0).c(a2.c(a3).a(a3.c(a4)).a(a4.c(a2)).e()));
        a a6 = a5.d(new a(d8, 0.0));
        if (a6.f() || Double.isNaN(1.0 / d8)) {
            return new Circle();
        }
        return new Circle(-a6.a(), -a6.b(), 1.0 / d8);
    }

    private static Circle b(ArrayList<Circle> arrayList) {
        Circle circle3;
        Circle circle2 = null;
        if (arrayList.size() >= 3) {
            circle2 = CirclePackingAlgorithm.a(arrayList.get(0), arrayList.get(1), arrayList.get(2));
            for (Circle circle3 : arrayList) {
                double d2 = Math.sqrt((circle2.cx - circle3.cx) * (circle2.cx - circle3.cx) + (circle2.cy - circle3.cy) * (circle2.cy - circle3.cy));
                circle2.radius = Math.max(circle2.radius, d2 + circle3.radius);
            }
        }
        Rectangle2D.Double double_ = CirclePackingAlgorithm.c(arrayList);
        circle3 = new Circle(double_.getCenterX(), double_.getCenterY(), Math.max(double_.getWidth(), double_.getHeight()) / 2.0);
        for (Circle circle4 : arrayList) {
            double d3 = Math.sqrt((circle3.cx - circle4.cx) * (circle3.cx - circle4.cx) + (circle3.cy - circle4.cy) * (circle3.cy - circle4.cy));
            circle3.radius = Math.max(circle3.radius, d3 + circle4.radius);
        }
        return circle2 == null || circle3.radius < circle2.radius ? circle3 : circle2;
    }

    private static Rectangle2D.Double c(ArrayList<Circle> arrayList) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        for (Circle circle : arrayList) {
            d2 = Math.min(d2, circle.cx - circle.radius);
            d3 = Math.max(d3, circle.cx + circle.radius);
            d4 = Math.min(d4, circle.cy - circle.radius);
            d5 = Math.max(d5, circle.cy + circle.radius);
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    static final class Circle
    implements Comparable<Circle> {
        public double cx;
        public double cy;
        public double radius;

        public Circle() {
        }

        public Circle(double cx, double cy, double r2) {
            this.cx = cx;
            this.cy = cy;
            this.radius = r2;
        }

        public double getCX() {
            return this.cx;
        }

        public double getCY() {
            return this.cy;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.cx - this.radius, this.cy - this.radius, this.radius * 2.0, this.radius * 2.0);
        }

        @Override
        public int compareTo(Circle c2) {
            double d2 = this.radius - c2.radius;
            return d2 < 0.0 ? 1 : (d2 > 0.0 ? -1 : 0);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Circle)) {
                return false;
            }
            Circle circle = (Circle)o2;
            return Double.compare(circle.cx, this.cx) == 0 && Double.compare(circle.cy, this.cy) == 0 && Double.compare(circle.radius, this.radius) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.cx, this.cy, this.radius);
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "[x:" + this.cx + ",y:" + this.cy + ",r:" + this.radius + "]";
        }
    }

    private static final class a {
        private final double a;
        private final double b;

        public a(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }

        public double a() {
            return this.a;
        }

        public double b() {
            return this.b;
        }

        public a a(a a2) {
            return new a(this.a + a2.a, this.b + a2.b);
        }

        public a b(a a2) {
            return new a(this.a - a2.a, this.b - a2.b);
        }

        public a c(a a2) {
            return new a(this.a * a2.a - this.b * a2.b, this.a * a2.b + this.b * a2.a);
        }

        public a d(a a2) {
            return new a((this.a * a2.a + this.b * a2.b) / (a2.a * a2.a + a2.b * a2.b), (this.b * a2.a - this.a * a2.b) / (a2.a * a2.a + a2.b * a2.b));
        }

        double c() {
            return Math.atan2(this.b, this.a);
        }

        double d() {
            return Math.sqrt(this.a * this.a + this.b * this.b);
        }

        public a e() {
            double d2 = Math.sqrt(this.d());
            double d3 = this.c() / 2.0;
            return new a(d2 * Math.cos(d3), d2 * Math.sin(d3));
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                a a2 = (a)o2;
                return a2.a == this.a && a2.b == this.b;
            }
            return false;
        }

        public int hashCode() {
            long l2 = Double.doubleToLongBits(this.a);
            return (int)(l2 ^= Double.doubleToLongBits(this.b) * 31L) ^ (int)(l2 >> 32);
        }

        public String toString() {
            if (this.b >= 0.0) {
                return "(" + this.a + "+" + this.b + "i)";
            }
            return "(" + this.a + this.b + "i)";
        }

        public boolean f() {
            return Double.isNaN(this.a) || Double.isNaN(this.b);
        }
    }
}

