/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPImage;
import com.macrofocus.igraphics.IGraphics;
import com.treemap.AbstractRendering;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import com.treemap.tagcloud.TextShape;

public class CushionRendering<C, N, Row, Column, Color, Font>
extends AbstractRendering<C, N, Row, Column, Color, Font> {
    private final boolean a = false;

    @Override
    public boolean paintNode(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int pass, Rectangle bounds, Shape shape) {
        boolean bl = true;
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = view.getModel();
        switch (pass) {
            case 0: {
                if (!treeMapModel.getFilter().isFiltered(node) && !treeMapModel.getSearch().isFiltered(node)) {
                    CPColor<Color> cPColor;
                    CPImage cPImage;
                    boolean bl2;
                    if (shape instanceof TextShape) {
                        CPColor<Color> cPColor2;
                        TextShape textShape = (TextShape)shape;
                        CPColor<Color> cPColor3 = treeMapModel.getCushionColor(node);
                        CPColor<Color> cPColor4 = cPColor2 = cPColor3 != null ? cPColor3 : treeMapModel.getColor(node);
                        if (cPColor2 == null) break;
                        g2.setFill(cPColor2);
                        if (textShape.isTextOutline()) {
                            g2.fill(shape);
                            break;
                        }
                        g2.setFont(textShape.getFont().getNativeFont());
                        Rectangle2D rectangle2D = textShape.getBounds2D();
                        g2.fillText(textShape.getText(), (float)rectangle2D.getX(), (float)rectangle2D.getMaxY());
                        break;
                    }
                    boolean bl3 = bl2 = shape instanceof Rectangle2D && bounds.width > 4 && bounds.height > 4 || !(shape instanceof Rectangle2D) && bounds.width > 6 && bounds.height > 6;
                    if (bl2) {
                        try {
                            cPImage = view.getModel().getCushionImage(node);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            cPImage = null;
                        }
                    } else {
                        cPImage = null;
                    }
                    if (cPImage != null) {
                        bl = this.a(g2, view, cPImage, bounds, shape);
                        break;
                    }
                    CPColor<Color> cPColor5 = treeMapModel.getCushionColor(node);
                    CPColor<Color> cPColor6 = cPColor = cPColor5 != null ? cPColor5 : treeMapModel.getColor(node);
                    if (cPColor == null) break;
                    g2.setFill(cPColor);
                    g2.fill(shape);
                    break;
                }
                CPColor<Color> cPColor = view.getBackground();
                if (cPColor == null) break;
                g2.setFill(cPColor);
                g2.fill(shape);
                break;
            }
            case 1: {
                CPColor<Color> cPColor;
                CPImage cPImage;
                boolean bl4;
                if (!(shape instanceof Rectangle2D) || treeMapModel.getFilter().isFiltered(node) || treeMapModel.getSearch().isFiltered(node)) break;
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                Rectangle2D rectangle2D2 = (Rectangle2D)this.getRenderedShape(view, treeMapModel, node, shape);
                boolean bl5 = bl4 = shape instanceof Rectangle2D && bounds.width > 4 && bounds.height > 4 || !(shape instanceof Rectangle2D) && bounds.width > 6 && bounds.height > 6;
                if (bl4) {
                    try {
                        cPImage = view.getModel().getCushionImage(node);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        cPImage = null;
                    }
                } else {
                    cPImage = null;
                }
                if (cPImage != null) {
                    cPColor = rectangle2D2.getBounds2D();
                    bl = this.a(g2, view, cPImage, new Rectangle((int)cPColor.getX(), (int)cPColor.getY(), (int)cPColor.getWidth(), (int)cPColor.getHeight()), (Shape)rectangle2D2);
                } else {
                    cPColor = treeMapModel.getCushionColor(node);
                    g2.setFill(cPColor != null ? cPColor : treeMapModel.getColor(node));
                    g2.fill(shape);
                }
                cPColor = treeMapModel.getColor(node);
                IGraphics<Color, Font> iGraphics = g2.getIGraphics();
                iGraphics.beginPath();
                iGraphics.moveTo((double)((int)rectangle2D2.getMinX()), (double)((int)rectangle2D2.getMaxY()));
                iGraphics.lineTo((double)((int)rectangle2D.getX()), (double)((int)rectangle2D.getMaxY()));
                iGraphics.lineTo((double)((int)rectangle2D.getMaxX()), (double)((int)rectangle2D.getMaxY()));
                iGraphics.lineTo((double)((int)rectangle2D2.getMaxX()), (double)((int)rectangle2D2.getMaxY()));
                iGraphics.closePath();
                iGraphics.setColor(cPColor.darker());
                iGraphics.fill();
                iGraphics.beginPath();
                iGraphics.moveTo((double)((int)rectangle2D2.getMaxX()), (double)((int)rectangle2D2.getMaxY()));
                iGraphics.lineTo((double)((int)rectangle2D.getMaxX()), (double)((int)rectangle2D.getMaxY()));
                iGraphics.lineTo((double)((int)rectangle2D.getMaxX()), (double)((int)rectangle2D.getMinY()));
                iGraphics.lineTo((double)((int)rectangle2D2.getMaxX()), (double)((int)rectangle2D2.getMinY()));
                iGraphics.closePath();
                iGraphics.setColor(cPColor.darker());
                iGraphics.fill();
            }
        }
        return bl;
    }

    private boolean a(TGraphics<Color, Font> tGraphics, TreeMapView<C, N, Row, Column, Color, Font> treeMapView, CPImage cPImage, Rectangle rectangle, Shape shape) {
        boolean bl = true;
        if (shape instanceof Rectangle2D) {
            if (rectangle.width > cPImage.getWidth() || rectangle.height > cPImage.getHeight()) {
                boolean bl2 = tGraphics.isInterpolationBilinear();
                tGraphics.setInterpolationBilinear(true);
                bl = tGraphics.drawImage(cPImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                tGraphics.setInterpolationBilinear(bl2);
            } else {
                bl = tGraphics.drawImage(cPImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            int n2 = Math.min(rectangle.width, treeMapView.getSize().width);
            int n3 = Math.min(rectangle.height, treeMapView.getSize().height);
            if (rectangle.width > cPImage.getWidth() || rectangle.height > cPImage.getHeight()) {
                boolean bl3 = tGraphics.isInterpolationBilinear();
                tGraphics.setInterpolationBilinear(true);
                bl = tGraphics.drawClippedImage(cPImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, n3, rectangle, shape);
                tGraphics.setInterpolationBilinear(bl3);
            } else {
                bl = tGraphics.drawClippedImage(cPImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, n3, rectangle, shape);
            }
        }
        return bl;
    }

    @Override
    public void paintBorder(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int pass, Rectangle bounds, Shape shape) {
    }

    public String toString() {
        return "Cushion";
    }
}

