/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.Insets;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapModel;

public class DefaultTreeMapHeaderRenderer<N, Row, Column, Color, Font>
extends EnhancedLabel<Color, Font>
implements TreeMapHeaderRenderer<N, Row, Column, Color, Font> {
    private static final Insets a = new Insets(0, 0, 0, 0);
    private CPFont<Font> b;
    private boolean c;
    private String d;

    public DefaultTreeMapHeaderRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.headerRenderer");
        this.setInsets(DefaultTreeMapHeaderRenderer.a.top, DefaultTreeMapHeaderRenderer.a.left, DefaultTreeMapHeaderRenderer.a.bottom, DefaultTreeMapHeaderRenderer.a.right);
        this.setEffect(EnhancedLabel.Effect.Emphasize);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(1);
        this.setRendering(EnhancedLabel.Rendering.Clip);
        this.b = this.getFont();
    }

    @Override
    public EnhancedLabel<Color, Font> getTreeMapHeaderRendererComponent(TreeMapModel<N, Row, Column, Color, Font> model, N node, Dimension dimension) {
        Insets insets;
        Float f2;
        Integer n2;
        EnhancedLabel.Rendering rendering;
        Integer n3;
        Integer n4;
        String string = model.getLabelName(node);
        this.setValue(string);
        TreeMapFieldSettings<Color, Font> treeMapFieldSettings = model.getSettings().getFieldSettings(model.getGroupByField(node));
        EnhancedLabel.Effect effect = treeMapFieldSettings.getHeaderEffect();
        if (effect != null) {
            this.setEffect(effect);
        }
        if ((n4 = treeMapFieldSettings.getHeaderHorizontalAlignment()) != null) {
            this.setHorizontalAlignment(n4);
        }
        if ((n3 = treeMapFieldSettings.getHeaderVerticalAlignment()) != null) {
            this.setVerticalAlignment(n3);
        }
        if ((rendering = treeMapFieldSettings.getHeaderRendering()) != null) {
            this.setRendering(rendering);
        }
        if ((n2 = treeMapFieldSettings.getHeaderMinimumCharactersToDisplay()) != null) {
            this.setMinimumCharactersToDisplay(n2);
        }
        if ((f2 = treeMapFieldSettings.getHeaderEffectOpacity()) != null) {
            this.setEffectOpacity(f2.floatValue());
        }
        if ((insets = treeMapFieldSettings.getHeaderInsets()) != null) {
            this.setInsets(insets.top, insets.left, insets.bottom, insets.right);
        } else {
            this.setInsets(0, 0, 0, 0);
        }
        this.setDesiredWidth(dimension.width);
        this.setDesiredHeight(dimension.height);
        return this;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    public void setOpaque(boolean opaque) {
        this.c = opaque;
    }

    public boolean isOpaque() {
        return this.c;
    }

    public void setName(String name) {
        this.d = name;
    }

    public String getName() {
        return this.d;
    }
}

