/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.ColoredSurroundLabeling;
import com.treemap.E;
import com.treemap.ExpandLabeling;
import com.treemap.Labeling;
import com.treemap.OverlayLabeling;
import com.treemap.SurroundLabeling;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsinterop.annotations.JsType;

@JsType
public class LabelingFactory {
    public static final Labeling OVERLAY = new OverlayLabeling();
    public static final SurroundLabeling SURROUND = new SurroundLabeling();
    public static final SurroundLabeling COLORED_SURROUND = new ColoredSurroundLabeling();
    public static final Labeling NONE = new E();
    public static final Labeling EXPAND = new ExpandLabeling();
    private final List<Labeling> a = new ArrayList<Labeling>();
    private static final LabelingFactory b = new LabelingFactory(OVERLAY, SURROUND, COLORED_SURROUND, NONE, EXPAND);

    private LabelingFactory(Labeling ... entries) {
        this.a.addAll(Arrays.asList(entries));
    }

    public static LabelingFactory getInstance() {
        return b;
    }

    public void add(Labeling entry) {
        this.a.add(entry);
    }

    public Labeling getDefault() {
        return SURROUND;
    }

    public List<Labeling> getLabelings() {
        return this.a;
    }

    public Labeling get(String name) {
        for (Labeling labeling : this.a) {
            if (!labeling.toString().equals(name)) continue;
            return labeling;
        }
        if ("On top".equals(name)) {
            return SURROUND;
        }
        if ("On top (no border)".equals(name)) {
            return OVERLAY;
        }
        if ("Overlaid".equals(name)) {
            return EXPAND;
        }
        if ("Leaf Only".equals(name)) {
            return NONE;
        }
        return this.getDefault();
    }
}

