/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapNode;
import com.treemap.TreeMapWorker;

public class PivotByAlgorithm
extends AbstractAlgorithm {
    private final Type a;

    public PivotByAlgorithm() {
        this(new SplitSize());
    }

    public PivotByAlgorithm(Type type) {
        this.a = type;
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = rectangle2D.getWidth() * rectangle2D.getHeight();
        double d3 = Math.sqrt(d2 / sumSizes);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth() / d3, rectangle2D.getHeight() / d3);
        Rectangle2D[] rectangle2DArray = this.a(children, (Rectangle2D)double_);
        for (int i2 = 0; i2 < children.length; ++i2) {
            children[i2].setShape((Shape)new Rectangle2D.Double(rectangle2DArray[i2].getX() * d3 + rectangle2D.getX(), rectangle2DArray[i2].getY() * d3 + rectangle2D.getY(), rectangle2DArray[i2].getWidth() * d3, rectangle2DArray[i2].getHeight() * d3));
        }
        return false;
    }

    Rectangle2D[] a(TreeMapNode[] treeMapNodeArray, Rectangle2D rectangle2D) {
        Rectangle2D.Double double_;
        Rectangle2D.Double double_2;
        Rectangle2D.Double double_3;
        double d2;
        double d3;
        double d4 = rectangle2D.getWidth() / rectangle2D.getHeight();
        if (treeMapNodeArray.length == 1) {
            Rectangle2D[] rectangle2DArray = new Rectangle2D[]{rectangle2D};
            return rectangle2DArray;
        }
        if (treeMapNodeArray.length == 2) {
            Rectangle2D[] rectangle2DArray = new Rectangle2D[2];
            double d5 = treeMapNodeArray[0].getSize() / (treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize());
            if (d4 >= 1.0) {
                double d6 = d5 * rectangle2D.getWidth();
                rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d6, rectangle2D.getHeight());
                rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX() + d6, rectangle2D.getY(), rectangle2D.getWidth() - d6, rectangle2D.getHeight());
            } else {
                double d7 = d5 * rectangle2D.getHeight();
                rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d7);
                rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d7, rectangle2D.getWidth(), rectangle2D.getHeight() - d7);
            }
            return rectangle2DArray;
        }
        int n2 = this.a.computePivotIndex(treeMapNodeArray);
        TreeMapNode treeMapNode = treeMapNodeArray[n2];
        int n3 = treeMapNodeArray.length - n2 - 1;
        TreeMapNode[] treeMapNodeArray2 = new TreeMapNode[n2];
        System.arraycopy(treeMapNodeArray, 0, treeMapNodeArray2, 0, n2);
        double d8 = PivotByAlgorithm.sum(treeMapNodeArray2, 0, treeMapNodeArray2.length - 1);
        if (d4 >= 1.0) {
            d3 = rectangle2D.getHeight();
            d2 = d8 / d3;
            double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d2, d3);
            double_2 = new Rectangle2D.Double(double_3.getX() + double_3.getWidth(), rectangle2D.getY(), rectangle2D.getWidth() - double_3.getWidth(), rectangle2D.getHeight());
        } else {
            d3 = rectangle2D.getWidth();
            d2 = d8 / d3;
            double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d3, d2);
            double_2 = new Rectangle2D.Double(double_3.getX(), double_3.getY() + double_3.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight() - double_3.getHeight());
        }
        TreeMapNode[] treeMapNodeArray3 = null;
        TreeMapNode[] treeMapNodeArray4 = null;
        Rectangle2D.Double double_4 = null;
        Rectangle2D.Double double_5 = null;
        if (n3 >= 3) {
            boolean bl = true;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            int n4 = 0;
            for (int i2 = n2 + 1; i2 < treeMapNodeArray.length; ++i2) {
                double d12;
                double d13;
                double d14 = PivotByAlgorithm.sum(treeMapNodeArray, n2 + 1, i2);
                double d15 = PivotByAlgorithm.sum(treeMapNodeArray, i2 + 1, treeMapNodeArray.length - 1);
                double d16 = (treeMapNode.getSize() + d14) / (treeMapNode.getSize() + d14 + d15);
                if (d4 >= 1.0) {
                    d13 = d16 * double_2.getWidth();
                    d16 = treeMapNode.getSize() / (treeMapNode.getSize() + d14);
                    d12 = d16 * double_2.getHeight();
                } else {
                    d12 = d16 * double_2.getHeight();
                    d16 = treeMapNode.getSize() / (treeMapNode.getSize() + d14);
                    d13 = d16 * double_2.getWidth();
                }
                double d17 = d13 / d12;
                if (bl) {
                    bl = false;
                    d9 = d17;
                    d10 = d13;
                    d11 = d12;
                    n4 = i2;
                    continue;
                }
                if (!(Math.abs(d17 - 1.0) < Math.abs(d9 - 1.0))) continue;
                d9 = d17;
                d10 = d13;
                d11 = d12;
                n4 = i2;
            }
            treeMapNodeArray3 = new TreeMapNode[n4 - n2];
            System.arraycopy(treeMapNodeArray, n2 + 1, treeMapNodeArray3, 0, treeMapNodeArray3.length);
            if (treeMapNodeArray.length - 1 - n4 > 0) {
                treeMapNodeArray4 = new TreeMapNode[treeMapNodeArray.length - 1 - n4];
                System.arraycopy(treeMapNodeArray, n4 + 1, treeMapNodeArray4, 0, treeMapNodeArray4.length);
            } else {
                treeMapNodeArray4 = null;
            }
            if (d4 >= 1.0) {
                double_ = new Rectangle2D.Double(double_2.getX(), double_2.getY(), d10, d11);
                double_4 = new Rectangle2D.Double(double_2.getX(), double_2.getY() + d11, d10, double_2.getHeight() - d11);
                if (treeMapNodeArray4 != null) {
                    double_5 = new Rectangle2D.Double(double_2.getX() + d10, double_2.getY(), double_2.getWidth() - d10, double_2.getHeight());
                }
            } else {
                double_ = new Rectangle2D.Double(double_2.getX(), double_2.getY(), d10, d11);
                double_4 = new Rectangle2D.Double(double_2.getX() + d10, double_2.getY(), double_2.getWidth() - d10, d11);
                if (treeMapNodeArray4 != null) {
                    double_5 = new Rectangle2D.Double(double_2.getX(), double_2.getY() + d11, double_2.getWidth(), double_2.getHeight() - d11);
                }
            }
        } else if (n3 > 0) {
            double d18;
            treeMapNodeArray3 = new TreeMapNode[n3];
            System.arraycopy(treeMapNodeArray, n2 + 1, treeMapNodeArray3, 0, n3);
            double d19 = treeMapNode.getSize() / (treeMapNode.getSize() + PivotByAlgorithm.sum(treeMapNodeArray3, 0, treeMapNodeArray3.length - 1));
            if (d4 >= 1.0) {
                d18 = d19 * double_2.getHeight();
                double_ = new Rectangle2D.Double(double_2.getX(), double_2.getY(), double_2.getWidth(), d18);
                double_4 = new Rectangle2D.Double(double_2.getX(), double_2.getY() + d18, double_2.getWidth(), double_2.getHeight() - d18);
            } else {
                d18 = d19 * double_2.getWidth();
                double_ = new Rectangle2D.Double(double_2.getX(), double_2.getY(), d18, double_2.getHeight());
                double_4 = new Rectangle2D.Double(double_2.getX() + d18, double_2.getY(), double_2.getWidth() - d18, double_2.getHeight());
            }
        } else {
            double_ = double_2;
        }
        Object object = treeMapNodeArray2.length > 1 ? this.a(treeMapNodeArray2, (Rectangle2D)double_3) : (treeMapNodeArray2.length == 1 ? new Rectangle2D[]{double_3} : null);
        Object object2 = treeMapNodeArray3 != null ? (treeMapNodeArray3.length > 1 ? this.a(treeMapNodeArray3, (Rectangle2D)double_4) : (treeMapNodeArray3.length == 1 ? new Rectangle2D[]{double_4} : null)) : null;
        Object object3 = treeMapNodeArray4 != null ? (treeMapNodeArray4.length > 1 ? this.a(treeMapNodeArray4, (Rectangle2D)double_5) : (treeMapNodeArray4.length == 1 ? new Rectangle2D[]{double_5} : null)) : null;
        int n5 = treeMapNodeArray2.length + 1;
        if (treeMapNodeArray3 != null) {
            n5 += treeMapNodeArray3.length;
        }
        if (treeMapNodeArray4 != null) {
            n5 += treeMapNodeArray4.length;
        }
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n5];
        int n6 = 0;
        if (object != null) {
            System.arraycopy(object, 0, rectangle2DArray, 0, ((Rectangle2D[])object).length);
            n6 = ((Rectangle2D[])object).length;
        }
        rectangle2DArray[n6] = double_;
        ++n6;
        if (object2 != null) {
            System.arraycopy(object2, 0, rectangle2DArray, n6, ((Rectangle2D[])object2).length);
            n6 += ((Rectangle2D[])object2).length;
        }
        if (object3 != null) {
            System.arraycopy(object3, 0, rectangle2DArray, n6, ((Rectangle2D[])object3).length);
        }
        if (rectangle2DArray.length >= 3 && rectangle2DArray.length <= 5) {
            return this.a(treeMapNodeArray, rectangle2D, rectangle2DArray);
        }
        return rectangle2DArray;
    }

    Rectangle2D[] a(TreeMapNode[] treeMapNodeArray, Rectangle2D rectangle2D, Rectangle2D[] rectangle2DArray) {
        Rectangle2D[] rectangle2DArray2 = rectangle2DArray;
        switch (treeMapNodeArray.length) {
            case 3: {
                Rectangle2D[] rectangle2DArray3 = this.b(treeMapNodeArray, rectangle2D);
                if (!(this.a(rectangle2DArray3) < this.a(rectangle2DArray2))) break;
                rectangle2DArray2 = rectangle2DArray3;
                break;
            }
            case 4: {
                Rectangle2D[] rectangle2DArray4 = this.c(treeMapNodeArray, rectangle2D);
                if (this.a(rectangle2DArray4) < this.a(rectangle2DArray2)) {
                    rectangle2DArray2 = rectangle2DArray4;
                }
                if (!(this.a(rectangle2DArray4 = this.d(treeMapNodeArray, rectangle2D)) < this.a(rectangle2DArray2))) break;
                rectangle2DArray2 = rectangle2DArray4;
                break;
            }
            case 5: {
                Rectangle2D[] rectangle2DArray5 = this.e(treeMapNodeArray, rectangle2D);
                if (!(this.a(rectangle2DArray5) < this.a(rectangle2DArray2))) break;
                rectangle2DArray2 = rectangle2DArray5;
                break;
            }
        }
        return rectangle2DArray2;
    }

    private Rectangle2D[] b(TreeMapNode[] treeMapNodeArray, Rectangle2D rectangle2D) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[3];
        double d2 = treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize() + treeMapNodeArray[2].getSize();
        double d3 = treeMapNodeArray[0].getSize() / d2;
        double d4 = treeMapNodeArray[1].getSize() / d2;
        double d5 = treeMapNodeArray[2].getSize() / d2;
        double d6 = rectangle2D.getWidth() / rectangle2D.getHeight();
        if (d6 >= 1.0) {
            double d7 = d3 * rectangle2D.getWidth();
            double d8 = d4 * rectangle2D.getWidth();
            double d9 = d5 * rectangle2D.getWidth();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d7, rectangle2D.getHeight());
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX() + d7, rectangle2D.getY(), d8, rectangle2D.getHeight());
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX() + d7 + d8, rectangle2D.getY(), d9, rectangle2D.getHeight());
        } else {
            double d10 = d3 * rectangle2D.getHeight();
            double d11 = d4 * rectangle2D.getHeight();
            double d12 = d5 * rectangle2D.getHeight();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d10);
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d10, rectangle2D.getWidth(), d11);
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d10 + d11, rectangle2D.getWidth(), d12);
        }
        return rectangle2DArray;
    }

    private Rectangle2D[] c(TreeMapNode[] treeMapNodeArray, Rectangle2D rectangle2D) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        double d2 = treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize() + treeMapNodeArray[2].getSize() + treeMapNodeArray[3].getSize();
        double d3 = (treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize()) / d2;
        double d4 = rectangle2D.getWidth() / rectangle2D.getHeight();
        if (d4 >= 1.0) {
            double d5 = d3 * rectangle2D.getWidth();
            double d6 = treeMapNodeArray[0].getSize() / (treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize());
            double d7 = d6 * rectangle2D.getHeight();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d5, d7);
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d7, d5, rectangle2D.getHeight() - d7);
            d6 = treeMapNodeArray[2].getSize() / (treeMapNodeArray[2].getSize() + treeMapNodeArray[3].getSize());
            d7 = d6 * rectangle2D.getHeight();
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX() + d5, rectangle2D.getY(), rectangle2D.getWidth() - d5, d7);
            rectangle2DArray[3] = new Rectangle2D.Double(rectangle2D.getX() + d5, rectangle2D.getY() + d7, rectangle2D.getWidth() - d5, rectangle2D.getHeight() - d7);
        } else {
            double d8 = d3 * rectangle2D.getHeight();
            double d9 = treeMapNodeArray[0].getSize() / (treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize());
            double d10 = d9 * rectangle2D.getWidth();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d10, d8);
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d8, d10, rectangle2D.getHeight() - d8);
            d9 = treeMapNodeArray[2].getSize() / (treeMapNodeArray[2].getSize() + treeMapNodeArray[3].getSize());
            d8 = d9 * rectangle2D.getHeight();
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX() + d10, rectangle2D.getY(), rectangle2D.getWidth() - d10, d8);
            rectangle2DArray[3] = new Rectangle2D.Double(rectangle2D.getX() + d10, rectangle2D.getY() + d8, rectangle2D.getWidth() - d10, rectangle2D.getHeight() - d8);
        }
        return rectangle2DArray;
    }

    private Rectangle2D[] d(TreeMapNode[] treeMapNodeArray, Rectangle2D rectangle2D) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        double d2 = treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize() + treeMapNodeArray[2].getSize() + treeMapNodeArray[3].getSize();
        double d3 = treeMapNodeArray[0].getSize() / d2;
        double d4 = treeMapNodeArray[1].getSize() / d2;
        double d5 = treeMapNodeArray[2].getSize() / d2;
        double d6 = treeMapNodeArray[3].getSize() / d2;
        double d7 = rectangle2D.getWidth() / rectangle2D.getHeight();
        if (d7 >= 1.0) {
            double d8 = d3 * rectangle2D.getWidth();
            double d9 = d4 * rectangle2D.getWidth();
            double d10 = d5 * rectangle2D.getWidth();
            double d11 = d6 * rectangle2D.getWidth();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d8, rectangle2D.getHeight());
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX() + d8, rectangle2D.getY(), d9, rectangle2D.getHeight());
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX() + d8 + d9, rectangle2D.getY(), d10, rectangle2D.getHeight());
            rectangle2DArray[3] = new Rectangle2D.Double(rectangle2D.getX() + d8 + d9 + d10, rectangle2D.getY(), d11, rectangle2D.getHeight());
        } else {
            double d12 = d3 * rectangle2D.getHeight();
            double d13 = d4 * rectangle2D.getHeight();
            double d14 = d5 * rectangle2D.getHeight();
            double d15 = d6 * rectangle2D.getHeight();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d12);
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d12, rectangle2D.getWidth(), d13);
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d12 + d13, rectangle2D.getWidth(), d14);
            rectangle2DArray[3] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d12 + d13 + d14, rectangle2D.getWidth(), d15);
        }
        return rectangle2DArray;
    }

    private Rectangle2D[] e(TreeMapNode[] treeMapNodeArray, Rectangle2D rectangle2D) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[5];
        double d2 = treeMapNodeArray[0].getSize() + treeMapNodeArray[1].getSize() + treeMapNodeArray[2].getSize() + treeMapNodeArray[3].getSize() + treeMapNodeArray[4].getSize();
        double d3 = treeMapNodeArray[0].getSize() / d2;
        double d4 = treeMapNodeArray[1].getSize() / d2;
        double d5 = treeMapNodeArray[2].getSize() / d2;
        double d6 = treeMapNodeArray[3].getSize() / d2;
        double d7 = treeMapNodeArray[4].getSize() / d2;
        double d8 = rectangle2D.getWidth() / rectangle2D.getHeight();
        if (d8 >= 1.0) {
            double d9 = d3 * rectangle2D.getWidth();
            double d10 = d4 * rectangle2D.getWidth();
            double d11 = d5 * rectangle2D.getWidth();
            double d12 = d6 * rectangle2D.getWidth();
            double d13 = d7 * rectangle2D.getWidth();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d9, rectangle2D.getHeight());
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX() + d9, rectangle2D.getY(), d10, rectangle2D.getHeight());
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX() + d9 + d10, rectangle2D.getY(), d11, rectangle2D.getHeight());
            rectangle2DArray[3] = new Rectangle2D.Double(rectangle2D.getX() + d9 + d10 + d11, rectangle2D.getY(), d12, rectangle2D.getHeight());
            rectangle2DArray[4] = new Rectangle2D.Double(rectangle2D.getX() + d9 + d10 + d11 + d12, rectangle2D.getY(), d13, rectangle2D.getHeight());
        } else {
            double d14 = d3 * rectangle2D.getHeight();
            double d15 = d4 * rectangle2D.getHeight();
            double d16 = d5 * rectangle2D.getHeight();
            double d17 = d6 * rectangle2D.getHeight();
            double d18 = d7 * rectangle2D.getHeight();
            rectangle2DArray[0] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d14);
            rectangle2DArray[1] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d14, rectangle2D.getWidth(), d15);
            rectangle2DArray[2] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d14 + d15, rectangle2D.getWidth(), d16);
            rectangle2DArray[3] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d14 + d15 + d16, rectangle2D.getWidth(), d17);
            rectangle2DArray[4] = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d14 + d15 + d16 + d17, rectangle2D.getWidth(), d18);
        }
        return rectangle2DArray;
    }

    double a(Rectangle2D[] rectangle2DArray) {
        double d2 = 0.0;
        int n2 = 0;
        for (int i2 = 0; i2 < rectangle2DArray.length; ++i2) {
            double d3 = rectangle2DArray[i2].getWidth();
            double d4 = rectangle2DArray[i2].getHeight();
            if (d3 == 0.0 || d4 == 0.0) continue;
            double d5 = Math.max(d3 / d4, d4 / d3);
            d2 += d5;
            ++n2;
        }
        return d2 / (double)n2;
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    String a() {
        return "Pivot by " + this.a.toString();
    }

    public String toString() {
        return this.a();
    }

    public static class SplitSize
    implements Type {
        @Override
        public int computePivotIndex(TreeMapNode[] children) {
            int n2 = 0;
            double d2 = 0.0;
            boolean bl = true;
            double d3 = 0.0;
            double d4 = AbstractAlgorithm.sum(children, 0, children.length - 1);
            for (int i2 = 0; i2 < children.length; ++i2) {
                double d5 = Math.max(d3 / d4, d4 / d3);
                if (bl || d5 < d2) {
                    bl = false;
                    d2 = d5;
                    n2 = i2;
                }
                d3 += children[i2].getSize();
                d4 -= children[i2].getSize();
            }
            return n2;
        }

        public String toString() {
            return "Split Size";
        }
    }

    public static interface Type {
        public int computePivotIndex(TreeMapNode[] var1);
    }

    public static class Middle
    implements Type {
        @Override
        public int computePivotIndex(TreeMapNode[] children) {
            return (children.length - 1) / 2;
        }

        public String toString() {
            return "Middle";
        }
    }

    public static class Biggest
    implements Type {
        @Override
        public int computePivotIndex(TreeMapNode[] children) {
            int n2 = 0;
            double d2 = 0.0;
            boolean bl = true;
            for (int i2 = 0; i2 < children.length; ++i2) {
                if (!bl && !(children[i2].getSize() > d2)) continue;
                bl = false;
                d2 = children[i2].getSize();
                n2 = i2;
            }
            return n2;
        }

        public String toString() {
            return "Biggest";
        }
    }
}

